/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrgWeaponItem;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSSummonKeyblade {
    ResourceLocation formToSummonFrom;
    boolean hasForm;
    boolean forceDesummon;
    Utils.OrgMember alignment;

    public CSSummonKeyblade() {
        this.hasForm = false;
        this.forceDesummon = false;
        this.alignment = Utils.OrgMember.NONE;
    }

    public CSSummonKeyblade(boolean forceDesummon) {
        this.forceDesummon = forceDesummon;
        this.alignment = Utils.OrgMember.NONE;
    }

    public CSSummonKeyblade(ResourceLocation formToSummonFrom) {
        this.formToSummonFrom = formToSummonFrom;
        this.hasForm = true;
        this.forceDesummon = false;
        this.alignment = Utils.OrgMember.NONE;
    }

    public CSSummonKeyblade(ResourceLocation formToSummonFrom, boolean forceDesummon) {
        this.formToSummonFrom = formToSummonFrom;
        this.hasForm = true;
        this.forceDesummon = forceDesummon;
        this.alignment = Utils.OrgMember.NONE;
    }

    public CSSummonKeyblade(boolean forceDesummon, Utils.OrgMember alignment) {
        this.hasForm = false;
        this.forceDesummon = forceDesummon;
        this.alignment = alignment;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.forceDesummon);
        buffer.writeBoolean(this.hasForm);
        buffer.writeInt(this.alignment.ordinal());
        if (this.formToSummonFrom != null) {
            buffer.func_192572_a(this.formToSummonFrom);
        }
    }

    public static CSSummonKeyblade decode(PacketBuffer buffer) {
        CSSummonKeyblade msg = new CSSummonKeyblade();
        msg.forceDesummon = buffer.readBoolean();
        msg.hasForm = buffer.readBoolean();
        msg.alignment = Utils.OrgMember.values()[buffer.readInt()];
        if (msg.hasForm) {
            msg.formToSummonFrom = buffer.func_192575_l();
        }
        return msg;
    }

    public static void handle(CSSummonKeyblade message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack keyblade;
            ItemStack summonedExtraStack;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti")) {
                return;
            }
            ItemStack orgWeapon = null;
            if (playerData.getAlignment() != Utils.OrgMember.NONE) {
                orgWeapon = playerData.getEquippedWeapon().func_77946_l();
            }
            if (orgWeapon == null && message.alignment != Utils.OrgMember.NONE) {
                orgWeapon = playerData.getEquippedWeapon().func_77946_l();
            }
            ItemStack heldStack = player.func_184614_ca();
            ItemStack offHeldStack = player.func_184592_cb();
            ItemStack chain = playerData.getEquippedKeychain(DriveForm.NONE);
            ItemStack extraChain = null;
            if (message.formToSummonFrom != null) {
                if (!message.formToSummonFrom.equals((Object)DriveForm.NONE)) {
                    if (playerData.getEquippedKeychains().containsKey(message.formToSummonFrom)) {
                        extraChain = playerData.getEquippedKeychain(message.formToSummonFrom);
                    }
                } else {
                    KingdomKeys.LOGGER.fatal(".-.");
                }
            }
            int slotSummoned = Utils.findSummoned(player.field_71071_by, chain, false);
            int extraSlotSummoned = -1;
            if (extraChain != null) {
                extraSlotSummoned = Utils.findSummoned(player.field_71071_by, extraChain, false);
            }
            if (orgWeapon != null) {
                slotSummoned = Utils.findSummoned(player.field_71071_by, orgWeapon, true);
            }
            ItemStack summonedStack = slotSummoned > -1 ? player.field_71071_by.func_70301_a(slotSummoned) : ItemStack.field_190927_a;
            ItemStack itemStack = summonedExtraStack = extraSlotSummoned > -1 ? player.field_71071_by.func_70301_a(extraSlotSummoned) : ItemStack.field_190927_a;
            if (message.forceDesummon && !ItemStack.func_77989_b((ItemStack)(heldStack = summonedStack), (ItemStack)ItemStack.field_190927_a)) {
                offHeldStack = summonedExtraStack;
            }
            if (message.forceDesummon || !ItemStack.func_77989_b((ItemStack)offHeldStack, (ItemStack)ItemStack.field_190927_a) && Utils.hasID(offHeldStack)) {
                if ((message.forceDesummon || !ItemStack.func_77989_b((ItemStack)heldStack, (ItemStack)ItemStack.field_190927_a) && ItemStack.func_77989_b((ItemStack)heldStack, (ItemStack)summonedStack)) && offHeldStack.func_77973_b() instanceof KeybladeItem && offHeldStack.func_77978_p().func_186857_a("keybladeID").equals(extraChain.func_77978_p().func_186857_a("keybladeID"))) {
                    extraChain.func_77982_d(offHeldStack.func_77978_p());
                    playerData.equipKeychain(message.formToSummonFrom, extraChain);
                    player.field_71071_by.func_70299_a(extraSlotSummoned, ItemStack.field_190927_a);
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.unsummon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                }
            } else if (extraSlotSummoned > -1) {
                Utils.swapStack(player.field_71071_by, 40, extraSlotSummoned);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.summon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            } else if (extraChain != null && !ItemStack.func_77989_b((ItemStack)extraChain, (ItemStack)ItemStack.field_190927_a)) {
                if (ItemStack.func_77989_b((ItemStack)offHeldStack, (ItemStack)ItemStack.field_190927_a)) {
                    keyblade = new ItemStack((IItemProvider)((IKeychain)extraChain.func_77973_b()).toSummon());
                    keyblade.func_77982_d(extraChain.func_77978_p());
                    player.field_71071_by.func_70299_a(40, keyblade);
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.summon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                } else if (player.field_71071_by.func_70447_i() > -1) {
                    keyblade = new ItemStack((IItemProvider)((IKeychain)extraChain.func_77973_b()).toSummon());
                    keyblade.func_77982_d(extraChain.func_77978_p());
                    Utils.swapStack(player.field_71071_by, player.field_71071_by.func_70447_i(), 40);
                    player.field_71071_by.func_70299_a(40, keyblade);
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.summon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                }
            }
            if (message.forceDesummon || !ItemStack.func_77989_b((ItemStack)heldStack, (ItemStack)ItemStack.field_190927_a) && (Utils.hasID(heldStack) || orgWeapon != null && (heldStack.func_77973_b() instanceof IOrgWeapon || heldStack.func_77973_b() instanceof KeybladeItem))) {
                if (heldStack.func_77973_b() instanceof KeybladeItem && orgWeapon == null) {
                    if (heldStack.func_77978_p().func_186857_a("keybladeID").equals(chain.func_77978_p().func_186857_a("keybladeID"))) {
                        chain.func_77982_d(heldStack.func_77978_p());
                        playerData.equipKeychain(DriveForm.NONE, chain);
                        player.field_71071_by.func_70299_a(slotSummoned, ItemStack.field_190927_a);
                        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.unsummon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                    }
                } else if (heldStack.func_77973_b() instanceof OrgWeaponItem || heldStack.func_77973_b() instanceof KeybladeItem) {
                    Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                    for (ItemStack weapon : weapons) {
                        if (!ItemStack.func_179545_c((ItemStack)weapon, (ItemStack)heldStack)) continue;
                        weapon.func_77982_d(heldStack.func_77978_p());
                        break;
                    }
                    playerData.setWeaponsUnlocked(weapons);
                    player.field_71071_by.func_70299_a(slotSummoned, ItemStack.field_190927_a);
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.unsummon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                }
            } else if (slotSummoned > -1) {
                Utils.swapStack(player.field_71071_by, player.field_71071_by.field_70461_c, slotSummoned);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.summon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            } else if (!ItemStack.func_77989_b((ItemStack)chain, (ItemStack)ItemStack.field_190927_a) || orgWeapon != null) {
                if (ItemStack.func_77989_b((ItemStack)heldStack, (ItemStack)ItemStack.field_190927_a)) {
                    if (orgWeapon == null) {
                        keyblade = new ItemStack((IItemProvider)((IKeychain)chain.func_77973_b()).toSummon());
                        keyblade.func_77982_d(chain.func_77978_p());
                    } else {
                        keyblade = orgWeapon;
                        Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                        for (ItemStack weapon : weapons) {
                            if (!ItemStack.func_179545_c((ItemStack)weapon, (ItemStack)keyblade)) continue;
                            keyblade.func_77982_d(weapon.func_77978_p());
                            break;
                        }
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, keyblade);
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.summon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                } else if (player.field_71071_by.func_70447_i() > -1) {
                    if (orgWeapon == null) {
                        keyblade = new ItemStack((IItemProvider)((IKeychain)chain.func_77973_b()).toSummon());
                        keyblade.func_77982_d(chain.func_77978_p());
                    } else {
                        keyblade = orgWeapon;
                        Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                        for (ItemStack weapon : weapons) {
                            if (!ItemStack.func_179545_c((ItemStack)weapon, (ItemStack)keyblade)) continue;
                            keyblade.func_77982_d(weapon.func_77978_p());
                            break;
                        }
                    }
                    Utils.swapStack(player.field_71071_by, player.field_71071_by.func_70447_i(), player.field_71071_by.field_70461_c);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, keyblade);
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.summon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void containerClose(PlayerContainerEvent.Close event) {
            PlayerContainer playerContainer;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            Container openContainer = event.getContainer();
            if (!openContainer.equals(playerContainer = player.field_71069_bz)) {
                openContainer.field_75151_b.forEach(slot -> {
                    ItemStack stack = slot.func_75211_c();
                    IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
                    if (slot.field_75224_c != player.field_71071_by && (Utils.hasID(stack) && stack.func_77973_b() instanceof KeybladeItem || playerData.getAlignment() != Utils.OrgMember.NONE && (stack.func_77973_b() instanceof OrgWeaponItem || playerData.getEquippedWeapon().func_77973_b() == stack.func_77973_b()))) {
                        slot.func_75215_d(ItemStack.field_190927_a);
                        if (stack.func_77973_b() instanceof OrgWeaponItem || playerData.getAlignment() != Utils.OrgMember.NONE) {
                            Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                            for (ItemStack weapon : weapons) {
                                if (!ItemStack.func_179545_c((ItemStack)weapon, (ItemStack)stack)) continue;
                                weapon.func_77982_d(stack.func_77978_p());
                                break;
                            }
                            playerData.setWeaponsUnlocked(weapons);
                        }
                        openContainer.func_75142_b();
                        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.unsummon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void dropItem(ItemTossEvent event) {
            ItemStack droppedItem = event.getEntityItem().func_92059_d();
            PlayerEntity player = event.getPlayer();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (droppedItem != null) {
                if (playerData.getEquippedWeapon() != null && (droppedItem.func_77973_b() instanceof OrgWeaponItem || droppedItem.func_77973_b() instanceof KeybladeItem && playerData.getAlignment() != Utils.OrgMember.NONE || playerData.getEquippedWeapon().func_77973_b() == droppedItem.func_77973_b())) {
                    if (droppedItem.func_77973_b() instanceof OrgWeaponItem || droppedItem.func_77973_b() instanceof KeybladeItem && playerData.getAlignment() != Utils.OrgMember.NONE) {
                        Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                        for (ItemStack weapon : weapons) {
                            if (!ItemStack.func_179545_c((ItemStack)weapon, (ItemStack)droppedItem)) continue;
                            weapon.func_77982_d(droppedItem.func_77978_p());
                            break;
                        }
                        playerData.setWeaponsUnlocked(weapons);
                    }
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.unsummon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                    event.setCanceled(true);
                    return;
                }
                if (Utils.hasID(droppedItem) && droppedItem.func_77973_b() instanceof KeybladeItem) {
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.unsummon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                    event.setCanceled(true);
                }
            }
        }
    }
}

