/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSUseLimitPacket {
    int index;
    int targetID;

    public CSUseLimitPacket() {
    }

    public CSUseLimitPacket(int level) {
        this.index = level;
        this.targetID = -1;
    }

    public CSUseLimitPacket(LivingEntity target, int level) {
        this.index = level;
        this.targetID = target.func_145782_y();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.index);
        buffer.writeInt(this.targetID);
    }

    public static CSUseLimitPacket decode(PacketBuffer buffer) {
        CSUseLimitPacket msg = new CSUseLimitPacket();
        msg.index = buffer.readInt();
        msg.targetID = buffer.readInt();
        return msg;
    }

    public static void handle(CSUseLimitPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            Limit limit = Utils.getPlayerLimitAttacks((PlayerEntity)player).get(message.index);
            int cost = limit.getCost();
            if (playerData.getDP() >= (double)cost) {
                playerData.remDP(cost);
                playerData.setLimitCooldownTicks(600);
                PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
                if (message.targetID > -1) {
                    limit.onUse((PlayerEntity)player, (LivingEntity)player.field_70170_p.func_73045_a(message.targetID));
                } else {
                    limit.onUse((PlayerEntity)player, (LivingEntity)player);
                }
            }
            PacketHandler.syncToAllAround((PlayerEntity)player, playerData);
        });
        ctx.get().setPacketHandled(true);
    }
}

