/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;

public class CSUseReactionCommandPacket {
    int index;

    public CSUseReactionCommandPacket() {
    }

    public CSUseReactionCommandPacket(int level) {
        this.index = level;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.index);
    }

    public static CSUseReactionCommandPacket decode(PacketBuffer buffer) {
        CSUseReactionCommandPacket msg = new CSUseReactionCommandPacket();
        msg.index = buffer.readInt();
        return msg;
    }

    public static void handle(CSUseReactionCommandPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            String reactionName = playerData.getReactionCommands().get(message.index);
            ReactionCommand reaction = (ReactionCommand)ModReactionCommands.registry.getValue(new ResourceLocation(reactionName));
            reaction.onUse((PlayerEntity)player, (LivingEntity)player);
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        });
        ctx.get().setPacketHandled(true);
    }
}

