/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class SCSyncCapabilityPacket {
    int level = 0;
    private int exp = 0;
    private int expGiven = 0;
    private int strength = 0;
    private int magic = 0;
    private int defense = 0;
    private int maxHp;
    private int maxAP;
    private int munny = 0;
    private int antipoints = 0;
    private double MP;
    private double maxMP;
    private double dp;
    private double maxDP;
    private double fp;
    private double focus;
    private double maxFocus;
    private boolean recharge;
    List<String> messages;
    List<String> dfMessages;
    String driveForm;
    List<ResourceLocation> recipeList = new ArrayList<ResourceLocation>();
    LinkedHashMap<String, Integer> magicsMap = new LinkedHashMap();
    List<String> shotlockList = new ArrayList<String>();
    List<String> reactionList = new ArrayList<String>();
    String equippedShotlock;
    LinkedHashMap<String, int[]> driveFormMap = new LinkedHashMap();
    LinkedHashMap<String, int[]> abilityMap = new LinkedHashMap();
    List<String> partyList = new ArrayList<String>(10);
    TreeMap<String, Integer> materialMap = new TreeMap();
    Map<ResourceLocation, ItemStack> keychains = new HashMap<ResourceLocation, ItemStack>();
    Map<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
    SoAState soAstate;
    SoAState choice;
    SoAState sacrifice;
    BlockPos choicePedestal;
    BlockPos sacrificePedestal;
    Vector3d returnPos;
    RegistryKey<World> returnDim;
    int hearts;
    Utils.OrgMember alignment;
    ItemStack equippedWeapon;
    Set<ItemStack> unlocks;
    int limitCooldownTicks;
    int magicCooldownTicks;

    public SCSyncCapabilityPacket() {
    }

    public SCSyncCapabilityPacket(IPlayerCapabilities capability) {
        this.level = capability.getLevel();
        this.exp = capability.getExperience();
        this.expGiven = capability.getExperienceGiven();
        this.strength = capability.getStrength();
        this.magic = capability.getMagic();
        this.defense = capability.getDefense();
        this.MP = capability.getMP();
        this.maxMP = capability.getMaxMP();
        this.recharge = capability.getRecharge();
        this.maxHp = capability.getMaxHP();
        this.maxAP = capability.getMaxAP();
        this.dp = capability.getDP();
        this.maxDP = capability.getMaxDP();
        this.fp = capability.getFP();
        this.antipoints = capability.getAntiPoints();
        this.munny = capability.getMunny();
        this.focus = capability.getFocus();
        this.maxFocus = capability.getMaxFocus();
        this.recipeList = capability.getKnownRecipeList();
        this.magicsMap = capability.getMagicsMap();
        this.shotlockList = capability.getShotlockList();
        this.equippedShotlock = capability.getEquippedShotlock();
        this.driveFormMap = capability.getDriveFormMap();
        this.abilityMap = capability.getAbilityMap();
        this.partyList = capability.getPartiesInvited();
        this.materialMap = capability.getMaterialMap();
        this.keychains = capability.getEquippedKeychains();
        this.items = capability.getEquippedItems();
        this.messages = capability.getMessages();
        this.dfMessages = capability.getDFMessages();
        this.soAstate = capability.getSoAState();
        this.choice = capability.getChosen();
        this.choicePedestal = capability.getChoicePedestal();
        this.sacrifice = capability.getSacrificed();
        this.sacrificePedestal = capability.getSacrificePedestal();
        this.driveForm = capability.getActiveDriveForm();
        this.returnPos = capability.getReturnLocation();
        this.returnDim = capability.getReturnDimension();
        this.hearts = capability.getHearts();
        this.alignment = capability.getAlignment();
        this.equippedWeapon = capability.getEquippedWeapon();
        this.unlocks = capability.getWeaponsUnlocked();
        this.limitCooldownTicks = capability.getLimitCooldownTicks();
        this.magicCooldownTicks = capability.getMagicCooldownTicks();
        this.reactionList = capability.getReactionCommands();
    }

    public void encode(PacketBuffer buffer) {
        int i;
        buffer.writeInt(this.level);
        buffer.writeInt(this.exp);
        buffer.writeInt(this.expGiven);
        buffer.writeInt(this.strength);
        buffer.writeInt(this.magic);
        buffer.writeInt(this.defense);
        buffer.writeDouble(this.MP);
        buffer.writeDouble(this.maxMP);
        buffer.writeBoolean(this.recharge);
        buffer.writeInt(this.maxHp);
        buffer.writeInt(this.maxAP);
        buffer.writeDouble(this.dp);
        buffer.writeDouble(this.maxDP);
        buffer.writeDouble(this.fp);
        buffer.writeInt(this.antipoints);
        buffer.writeInt(this.munny);
        buffer.writeDouble(this.focus);
        buffer.writeDouble(this.maxFocus);
        CompoundNBT recipes = new CompoundNBT();
        for (ResourceLocation r : this.recipeList) {
            recipes.func_74778_a(r.toString(), r.toString());
        }
        buffer.func_150786_a(recipes);
        CompoundNBT magics = new CompoundNBT();
        for (Map.Entry<String, Integer> pair : this.magicsMap.entrySet()) {
            magics.func_74768_a(pair.getKey().toString(), pair.getValue().intValue());
        }
        buffer.func_150786_a(magics);
        CompoundNBT shotlocks = new CompoundNBT();
        for (String s : this.shotlockList) {
            shotlocks.func_74768_a(s, 1);
        }
        buffer.func_150786_a(shotlocks);
        buffer.func_211400_a(this.equippedShotlock, 100);
        CompoundNBT forms = new CompoundNBT();
        for (Map.Entry<String, int[]> pair : this.driveFormMap.entrySet()) {
            forms.func_74783_a(pair.getKey().toString(), pair.getValue());
        }
        buffer.func_150786_a(forms);
        CompoundNBT abilities = new CompoundNBT();
        for (Map.Entry<String, int[]> pair : this.abilityMap.entrySet()) {
            abilities.func_74783_a(pair.getKey().toString(), pair.getValue());
        }
        buffer.func_150786_a(abilities);
        CompoundNBT keychains = new CompoundNBT();
        this.keychains.forEach((key, value) -> keychains.func_218657_a(key.toString(), (INBT)value.serializeNBT()));
        buffer.func_150786_a(keychains);
        CompoundNBT items = new CompoundNBT();
        this.items.forEach((key, value) -> items.func_218657_a(key.toString(), (INBT)value.serializeNBT()));
        buffer.func_150786_a(items);
        buffer.writeInt(this.partyList.size());
        for (int i2 = 0; i2 < this.partyList.size(); ++i2) {
            buffer.writeInt(this.partyList.get(i2).length());
            buffer.func_180714_a(this.partyList.get(i2));
        }
        CompoundNBT materials = new CompoundNBT();
        for (Map.Entry<String, Integer> pair : this.materialMap.entrySet()) {
            materials.func_74768_a(pair.getKey().toString(), pair.getValue().intValue());
            if (materials.func_74762_e(pair.getKey()) != 0 || pair.getKey().toString() == null) continue;
            materials.func_82580_o(pair.getKey().toString());
        }
        buffer.func_150786_a(materials);
        buffer.writeInt(this.messages.size());
        buffer.writeInt(this.dfMessages.size());
        for (i = 0; i < this.messages.size(); ++i) {
            buffer.func_180714_a(this.messages.get(i));
        }
        for (i = 0; i < this.dfMessages.size(); ++i) {
            buffer.func_180714_a(this.dfMessages.get(i));
        }
        buffer.writeInt(this.driveForm.length());
        buffer.func_180714_a(this.driveForm);
        buffer.func_192572_a(this.returnDim.func_240901_a_());
        buffer.writeDouble(this.returnPos.field_72450_a);
        buffer.writeDouble(this.returnPos.field_72448_b);
        buffer.writeDouble(this.returnPos.field_72449_c);
        buffer.writeByte((int)this.soAstate.get());
        buffer.writeByte((int)this.choice.get());
        buffer.writeByte((int)this.sacrifice.get());
        buffer.func_179255_a(this.choicePedestal);
        buffer.func_179255_a(this.sacrificePedestal);
        buffer.writeInt(this.hearts);
        buffer.writeInt(this.alignment.ordinal());
        buffer.func_150788_a(this.equippedWeapon);
        buffer.writeInt(this.unlocks.size());
        this.unlocks.forEach(arg_0 -> ((PacketBuffer)buffer).func_150788_a(arg_0));
        buffer.writeInt(this.limitCooldownTicks);
        buffer.writeInt(this.magicCooldownTicks);
        buffer.writeInt(this.reactionList.size());
        for (i = 0; i < this.reactionList.size(); ++i) {
            buffer.func_211400_a(this.reactionList.get(i), 100);
        }
    }

    public static SCSyncCapabilityPacket decode(PacketBuffer buffer) {
        int i;
        SCSyncCapabilityPacket msg = new SCSyncCapabilityPacket();
        msg.level = buffer.readInt();
        msg.exp = buffer.readInt();
        msg.expGiven = buffer.readInt();
        msg.strength = buffer.readInt();
        msg.magic = buffer.readInt();
        msg.defense = buffer.readInt();
        msg.MP = buffer.readDouble();
        msg.maxMP = buffer.readDouble();
        msg.recharge = buffer.readBoolean();
        msg.maxHp = buffer.readInt();
        msg.maxAP = buffer.readInt();
        msg.dp = buffer.readDouble();
        msg.maxDP = buffer.readDouble();
        msg.fp = buffer.readDouble();
        msg.antipoints = buffer.readInt();
        msg.munny = buffer.readInt();
        msg.focus = buffer.readDouble();
        msg.maxFocus = buffer.readDouble();
        CompoundNBT recipesTag = buffer.func_150793_b();
        for (String key2 : recipesTag.func_150296_c()) {
            msg.recipeList.add(new ResourceLocation(key2));
        }
        CompoundNBT magicsTag = buffer.func_150793_b();
        for (String magicName : magicsTag.func_150296_c()) {
            msg.magicsMap.put(magicName, magicsTag.func_74762_e(magicName));
        }
        CompoundNBT shotlocksTag = buffer.func_150793_b();
        for (String key3 : shotlocksTag.func_150296_c()) {
            msg.shotlockList.add(key3);
        }
        msg.equippedShotlock = buffer.func_150789_c(100);
        CompoundNBT driveFormsTag = buffer.func_150793_b();
        for (String driveFormName : driveFormsTag.func_150296_c()) {
            msg.driveFormMap.put(driveFormName, driveFormsTag.func_74759_k(driveFormName));
        }
        CompoundNBT abilitiesTag = buffer.func_150793_b();
        for (String abilityName : abilitiesTag.func_150296_c()) {
            msg.abilityMap.put(abilityName, abilitiesTag.func_74759_k(abilityName));
        }
        CompoundNBT keychainsNBT = buffer.func_150793_b();
        keychainsNBT.func_150296_c().forEach(key -> msg.keychains.put(new ResourceLocation(key), ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)keychainsNBT.func_74781_a(key)))));
        CompoundNBT itemsNBT = buffer.func_150793_b();
        itemsNBT.func_150296_c().forEach(key -> msg.items.put(Integer.parseInt(key), ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)itemsNBT.func_74781_a(key)))));
        int amount = buffer.readInt();
        msg.partyList = new ArrayList<String>();
        for (int i2 = 0; i2 < amount; ++i2) {
            int length = buffer.readInt();
            msg.partyList.add(buffer.func_150789_c(length));
        }
        CompoundNBT materialsTag = buffer.func_150793_b();
        for (String matName : materialsTag.func_150296_c()) {
            msg.materialMap.put(matName, materialsTag.func_74762_e(matName));
        }
        int msgSize = buffer.readInt();
        int dfMsgSize = buffer.readInt();
        msg.messages = new ArrayList<String>();
        for (i = 0; i < msgSize; ++i) {
            msg.messages.add(buffer.func_150789_c(100));
        }
        msg.dfMessages = new ArrayList<String>();
        for (i = 0; i < dfMsgSize; ++i) {
            msg.dfMessages.add(buffer.func_150789_c(100));
        }
        int length = buffer.readInt();
        msg.driveForm = buffer.func_150789_c(length);
        msg.returnDim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buffer.func_192575_l());
        msg.returnPos = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        msg.soAstate = SoAState.fromByte(buffer.readByte());
        msg.choice = SoAState.fromByte(buffer.readByte());
        msg.sacrifice = SoAState.fromByte(buffer.readByte());
        msg.choicePedestal = buffer.func_179259_c();
        msg.sacrificePedestal = buffer.func_179259_c();
        msg.hearts = buffer.readInt();
        msg.alignment = Utils.OrgMember.values()[buffer.readInt()];
        msg.equippedWeapon = buffer.func_150791_c();
        msg.unlocks = new HashSet<ItemStack>();
        int unlockSize = buffer.readInt();
        for (int i3 = 0; i3 < unlockSize; ++i3) {
            msg.unlocks.add(buffer.func_150791_c());
        }
        msg.limitCooldownTicks = buffer.readInt();
        msg.magicCooldownTicks = buffer.readInt();
        int rSize = buffer.readInt();
        for (int i4 = 0; i4 < rSize; ++i4) {
            msg.reactionList.add(buffer.func_150789_c(100));
        }
        return msg;
    }

    public static void handle(SCSyncCapabilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(KingdomKeys.proxy.getClientPlayer());
            playerData.setLevel(message.level);
            playerData.setExperience(message.exp);
            playerData.setExperienceGiven(message.expGiven);
            playerData.setStrength(message.strength);
            playerData.setMagic(message.magic);
            playerData.setDefense(message.defense);
            playerData.setMP(message.MP);
            playerData.setMaxMP(message.maxMP);
            playerData.setRecharge(message.recharge);
            playerData.setMaxHP(message.maxHp);
            playerData.setMaxAP(message.maxAP);
            playerData.setDP(message.dp);
            playerData.setFP(message.fp);
            playerData.setMaxDP(message.maxDP);
            playerData.setMunny(message.munny);
            playerData.setFocus(message.focus);
            playerData.setMaxFocus(message.maxFocus);
            playerData.setMessages(message.messages);
            playerData.setDFMessages(message.dfMessages);
            playerData.setKnownRecipeList(message.recipeList);
            playerData.setMagicsMap(message.magicsMap);
            playerData.setShotlockList(message.shotlockList);
            playerData.setEquippedShotlock(message.equippedShotlock);
            playerData.setDriveFormMap(message.driveFormMap);
            playerData.setAbilityMap(message.abilityMap);
            playerData.setAntiPoints(message.antipoints);
            playerData.setPartiesInvited(message.partyList);
            playerData.setMaterialMap(message.materialMap);
            playerData.equipAllKeychains(message.keychains, false);
            playerData.equipAllItems(message.items, false);
            playerData.setActiveDriveForm(message.driveForm);
            playerData.setReturnDimension(message.returnDim);
            playerData.setReturnLocation(message.returnPos);
            playerData.setSoAState(message.soAstate);
            playerData.setChoice(message.choice);
            playerData.setSacrifice(message.sacrifice);
            playerData.setChoicePedestal(message.choicePedestal);
            playerData.setSacrificePedestal(message.sacrificePedestal);
            playerData.setHearts(message.hearts);
            playerData.setAlignment(message.alignment);
            playerData.equipWeapon(message.equippedWeapon);
            playerData.setWeaponsUnlocked(message.unlocks);
            playerData.setLimitCooldownTicks(message.limitCooldownTicks);
            playerData.setMagicCooldownTicks(message.magicCooldownTicks);
            playerData.setReactionCommands(message.reactionList);
            KingdomKeys.proxy.getClientPlayer().func_110148_a(Attributes.field_233818_a_).func_111128_a((double)message.maxHp);
        });
        ctx.get().setPacketHandled(true);
    }
}

