/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;

public class SCSyncGlobalCapabilityToAllPacket {
    int id;
    private int stopTicks;
    private int flatTicks;
    private float stopDmg;

    public SCSyncGlobalCapabilityToAllPacket() {
    }

    public SCSyncGlobalCapabilityToAllPacket(int id, IGlobalCapabilities capability) {
        this.id = id;
        this.stopTicks = capability.getStoppedTicks();
        this.stopDmg = capability.getDamage();
        this.flatTicks = capability.getFlatTicks();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.id);
        buffer.writeInt(this.stopTicks);
        buffer.writeFloat(this.stopDmg);
        buffer.writeInt(this.flatTicks);
    }

    public static SCSyncGlobalCapabilityToAllPacket decode(PacketBuffer buffer) {
        SCSyncGlobalCapabilityToAllPacket msg = new SCSyncGlobalCapabilityToAllPacket();
        msg.id = buffer.readInt();
        msg.stopTicks = buffer.readInt();
        msg.stopDmg = buffer.readFloat();
        msg.flatTicks = buffer.readInt();
        return msg;
    }

    public static void handle(SCSyncGlobalCapabilityToAllPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LivingEntity entity = (LivingEntity)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
            if (entity != null) {
                LazyOptional globalData = entity.getCapability(ModCapabilities.GLOBAL_CAPABILITIES);
                globalData.ifPresent(cap -> cap.setStoppedTicks(message.stopTicks));
                globalData.ifPresent(cap -> cap.setDamage(message.stopDmg));
                globalData.ifPresent(cap -> cap.setFlatTicks(message.flatTicks));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

