/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationData;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationDataDeserializer;
import org.apache.commons.io.IOUtils;

public class SCSyncOrganizationData {
    public static final Gson GSON_BUILDER = new GsonBuilder().registerTypeAdapter(OrganizationData.class, (Object)new OrganizationDataDeserializer()).setPrettyPrinting().create();
    List<String> names = new LinkedList<String>();
    List<String> data = new LinkedList<String>();

    public SCSyncOrganizationData() {
    }

    public SCSyncOrganizationData(List<String> names, List<String> data) {
        this.names = names;
        this.data = data;
    }

    public void encode(PacketBuffer buffer) {
        int i;
        buffer.writeInt(this.names.size());
        buffer.writeInt(this.data.size());
        for (i = 0; i < this.names.size(); ++i) {
            String n = this.names.get(i);
            buffer.writeInt(n.length());
            buffer.func_180714_a(n);
        }
        for (i = 0; i < this.data.size(); ++i) {
            String d = this.data.get(i);
            buffer.writeInt(d.length());
            buffer.func_180714_a(d);
        }
    }

    public static SCSyncOrganizationData decode(PacketBuffer buffer) {
        int l;
        int i;
        SCSyncOrganizationData msg = new SCSyncOrganizationData();
        int nLen = buffer.readInt();
        int dLen = buffer.readInt();
        for (i = 0; i < nLen; ++i) {
            l = buffer.readInt();
            msg.names.add(buffer.func_150789_c(l));
        }
        for (i = 0; i < dLen; ++i) {
            l = buffer.readInt();
            msg.data.add(buffer.func_150789_c(l));
        }
        return msg;
    }

    public static void handle(SCSyncOrganizationData message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = KingdomKeys.proxy.getClientPlayer();
            for (int i = 0; i < message.names.size(); ++i) {
                OrganizationData result;
                IOrgWeapon weapon = (IOrgWeapon)ForgeRegistries.ITEMS.getValue(new ResourceLocation(message.names.get(i)));
                String d = message.data.get(i);
                BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(d.getBytes())));
                try {
                    result = (OrganizationData)GSON_BUILDER.fromJson((Reader)br, OrganizationData.class);
                }
                catch (JsonParseException e) {
                    KingdomKeys.LOGGER.error("Error parsing json file {}: {}", (Object)message.names.get(i), (Object)e);
                    continue;
                }
                weapon.setOrganizationData(result);
                IOUtils.closeQuietly((Reader)br);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

