/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;

public class SCSyncSynthesisData {
    List<Recipe> recipes = new LinkedList<Recipe>();

    public SCSyncSynthesisData() {
    }

    public SCSyncSynthesisData(List<Recipe> recipes) {
        this.recipes = recipes;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.recipes.size());
        CompoundNBT compoundNBT = new CompoundNBT();
        for (int i = 0; i < this.recipes.size(); ++i) {
            compoundNBT.func_218657_a("recipe" + i, (INBT)this.recipes.get(i).serializeNBT());
        }
        buffer.func_150786_a(compoundNBT);
    }

    public static SCSyncSynthesisData decode(PacketBuffer buffer) {
        SCSyncSynthesisData msg = new SCSyncSynthesisData();
        int size = buffer.readInt();
        CompoundNBT compoundNBT = buffer.func_150793_b();
        for (int i = 0; i < size; ++i) {
            Recipe r = new Recipe();
            r.deserializeNBT((CompoundNBT)compoundNBT.func_74781_a("recipe" + i));
            msg.recipes.add(r);
        }
        return msg;
    }

    public static void handle(SCSyncSynthesisData message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = KingdomKeys.proxy.getClientPlayer();
            RecipeRegistry.getInstance().clearRegistry();
            message.recipes.forEach(recipe -> RecipeRegistry.getInstance().register((Recipe)recipe));
        });
        ctx.get().setPacketHandled(true);
    }
}

