/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.ConfirmChoiceMenuPopup;
import online.kingdomkeys.kingdomkeys.client.gui.SoAMessages;
import online.kingdomkeys.kingdomkeys.entity.block.PedestalTileEntity;
import online.kingdomkeys.kingdomkeys.lib.SoAState;

public class SCUpdateSoA {
    SoAState state;
    BlockPos choicePos;
    BlockPos sacrificePos;

    public SCUpdateSoA() {
    }

    public SCUpdateSoA(IPlayerCapabilities playerData) {
        this.state = playerData.getSoAState();
        this.choicePos = playerData.getChoicePedestal();
        this.sacrificePos = playerData.getSacrificePedestal();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeByte((int)this.state.get());
        buffer.func_179255_a(this.choicePos);
        buffer.func_179255_a(this.sacrificePos);
    }

    public static SCUpdateSoA decode(PacketBuffer buffer) {
        SCUpdateSoA msg = new SCUpdateSoA();
        msg.state = SoAState.fromByte(buffer.readByte());
        msg.choicePos = buffer.func_179259_c();
        msg.sacrificePos = buffer.func_179259_c();
        return msg;
    }

    public static void handle(SCUpdateSoA message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SCUpdateSoA message) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            TileEntity teChoice = world.func_175625_s(message.choicePos);
            TileEntity teSacrifice = world.func_175625_s(message.sacrificePos);
            if (teChoice != null) {
                ((PedestalTileEntity)teChoice).hide = true;
            }
            if (teSacrifice != null) {
                ((PedestalTileEntity)teSacrifice).hide = true;
            }
            if (message.state == SoAState.CHOICE) {
                SoAMessages.INSTANCE.clearMessage();
                SoAMessages.INSTANCE.queueMessages(new SoAMessages.Title("soa.title", "soa.subtitle"), new SoAMessages.Title(null, "soa.choice.intro.1", 20, 60, 20), new SoAMessages.Title(null, "soa.choice.intro.2", 20, 60, 20), new SoAMessages.Title(null, "soa.choice.intro.3", 20, 60, 20), new SoAMessages.Title(null, "soa.choice.intro.4", 20, 60, 20));
            }
            if (message.state == SoAState.SACRIFICE) {
                SoAMessages.INSTANCE.clearMessage();
                SoAMessages.INSTANCE.queueMessages(new SoAMessages.Title(null, "soa.sacrifice.intro.1", 10, 35, 20), new SoAMessages.Title(null, "soa.sacrifice.intro.2", 10, 70, 20));
            }
            if (message.state == SoAState.CONFIRM) {
                Minecraft.func_71410_x().func_147108_a((Screen)new ConfirmChoiceMenuPopup(SoAState.CONFIRM, SoAState.NONE, new BlockPos(0, 0, 0)));
            }
        }
    }
}

