/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.reactioncommands;

import java.util.ArrayList;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.util.Utils;

@Mod.EventBusSubscriber(modid="kingdomkeys")
public class ReactionAutoForm
extends ReactionCommand {
    String form;
    String abilityName;

    public ReactionAutoForm(String registryName, String abilityName, String form) {
        super(registryName);
        this.form = form;
        this.abilityName = abilityName;
    }

    public String getFormName() {
        return this.form;
    }

    public String getAbilityName() {
        return this.abilityName;
    }

    public DriveForm getForm() {
        return (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(this.form));
    }

    public boolean isAutoForm() {
        return this.form != null;
    }

    @Override
    public void onUse(PlayerEntity player, LivingEntity target) {
        if (this.conditionsToAppear(player, target)) {
            DriveForm forma;
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.drive.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) && this.form.equals(DriveForm.NONE.toString())) {
                forma = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(playerData.getActiveDriveForm()));
                forma.endDrive(player);
            } else if (!this.form.equals(DriveForm.NONE.toString())) {
                forma = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(this.form));
                forma.initDrive(player);
            }
            playerData.removeReactionCommand(this.getRegistryName().toString());
            ArrayList<ReactionCommand> list = new ArrayList<ReactionCommand>();
            for (String name : playerData.getReactionCommands()) {
                ReactionCommand rc = (ReactionCommand)ModReactionCommands.registry.getValue(new ResourceLocation(name));
                if (!(rc instanceof ReactionAutoForm)) continue;
                list.add(rc);
            }
            for (ReactionCommand rc : list) {
                if (!(rc instanceof ReactionAutoForm)) continue;
                playerData.removeReactionCommand(rc.getName());
            }
        }
    }

    @Override
    public boolean conditionsToAppear(PlayerEntity player, LivingEntity target) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        if (playerData != null && Utils.isPlayerLowHP(player) && playerData.getAlignment() == Utils.OrgMember.NONE && playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
            ResourceLocation resourceLocation = new ResourceLocation(this.form);
            if (playerData.getDP() >= (double)((DriveForm)ModDriveForms.registry.getValue(resourceLocation)).getDriveCost() && playerData.getEquippedAbilityLevel(this.abilityName)[1] > 0) {
                return true;
            }
        }
        return false;
    }
}

