/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.keybladeforge;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeLevel;

public class KeybladeData {
    @Nullable
    public KeychainItem keychain;
    int baseStrength;
    int baseMagic;
    @Nullable
    List<KeybladeLevel> levels;
    String description;

    public KeybladeData() {
    }

    public KeybladeData(@Nullable KeychainItem keychain, @Nullable List<KeybladeLevel> levels, String description, int baseStrength, int baseMagic) {
        this.keychain = keychain;
        this.levels = levels;
        this.description = description;
        this.baseStrength = baseStrength;
        this.baseMagic = baseMagic;
    }

    public int getStrength(int level) {
        return level == 0 ? this.baseStrength : this.levels.get(level - 1).getStrength();
    }

    public int getMagic(int level) {
        return level == 0 ? this.baseMagic : this.levels.get(level - 1).getMagic();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setKeychain(Item keychain) {
        this.keychain = keychain instanceof KeychainItem ? (KeychainItem)keychain : null;
    }

    public KeychainItem getKeychain() {
        return this.keychain;
    }

    public void setLevels(List<KeybladeLevel> levels) {
        this.levels = levels;
    }

    public KeybladeLevel getLevelData(int level) {
        return this.levels.get(level);
    }

    public void setBaseMagic(int baseMagic) {
        this.baseMagic = baseMagic;
    }

    public void setBaseStrength(int baseStrength) {
        this.baseStrength = baseStrength;
    }
}

