/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.keybladeforge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncKeybladeData;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeData;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeDataDeserializer;
import org.apache.commons.io.IOUtils;

public class KeybladeDataLoader
extends JsonReloadListener {
    public static final Gson GSON_BUILDER = new GsonBuilder().registerTypeAdapter(KeybladeData.class, (Object)new KeybladeDataDeserializer()).create();
    public static List<String> names = new LinkedList<String>();
    public static List<String> dataList = new LinkedList<String>();

    public KeybladeDataLoader() {
        super(GSON_BUILDER, "keyblades");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        KingdomKeys.LOGGER.info("Loading keyblade data");
        this.loadData(resourceManagerIn);
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                PacketHandler.sendTo(new SCSyncKeybladeData(names, dataList), player);
            }
        }
    }

    public void loadData(IResourceManager manager) {
        String folder = "keyblades";
        String extension = ".json";
        for (ResourceLocation file : manager.func_199003_a(folder, n -> n.endsWith(extension))) {
            ResourceLocation keybladeDataID = new ResourceLocation(file.func_110624_b(), file.func_110623_a().substring(folder.length() + 1, file.func_110623_a().length() - extension.length()));
            KeybladeItem keyblade = (KeybladeItem)ForgeRegistries.ITEMS.getValue(keybladeDataID);
            try {
                KeybladeData result;
                BufferedReader br = new BufferedReader(new InputStreamReader(manager.func_199002_a(file).func_199027_b()));
                BufferedReader br2 = new BufferedReader(new InputStreamReader(manager.func_199002_a(file).func_199027_b()));
                String data = "";
                while (br.ready()) {
                    data = data + br.readLine();
                }
                dataList.add(data);
                try {
                    result = (KeybladeData)GSON_BUILDER.fromJson((Reader)br2, KeybladeData.class);
                    names.add(keybladeDataID.toString());
                }
                catch (JsonParseException e) {
                    KingdomKeys.LOGGER.error("Error parsing json file {}: {}", (Object)manager.func_199002_a(file).func_199029_a().toString(), (Object)e);
                    continue;
                }
                keyblade.setKeybladeData(result);
                if (result.keychain != null) {
                    result.keychain.setKeyblade(keyblade);
                }
                IOUtils.closeQuietly((Closeable)manager.func_199002_a(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

