/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncSynthesisData;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeDataDeserializer;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RecipeDataLoader
extends JsonReloadListener {
    public static final Gson GSON_BUILDER = new GsonBuilder().registerTypeAdapter(Recipe.class, (Object)new RecipeDataDeserializer()).setPrettyPrinting().create();

    public RecipeDataLoader() {
        super(GSON_BUILDER, "synthesis");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        KingdomKeys.LOGGER.info("Loading recipe data");
        this.loadData(resourceManagerIn);
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                PacketHandler.sendTo(new SCSyncSynthesisData(RecipeRegistry.getInstance().getValues()), player);
            }
        }
    }

    public void loadData(IResourceManager manager) {
        String folder = "synthesis";
        String extension = ".json";
        RecipeRegistry.getInstance().clearRegistry();
        for (ResourceLocation file : manager.func_199003_a(folder, n -> n.endsWith(extension))) {
            ResourceLocation recipe = new ResourceLocation(file.func_110624_b(), file.func_110623_a().substring(folder.length() + 1, file.func_110623_a().length() - extension.length()));
            try {
                Recipe result;
                try {
                    result = (Recipe)GSON_BUILDER.fromJson((Reader)new BufferedReader(new InputStreamReader(manager.func_199002_a(file).func_199027_b())), Recipe.class);
                    result.setRegistryName(file.func_110624_b(), file.func_110623_a().substring(folder.length() + 1, file.func_110623_a().length() - extension.length()));
                }
                catch (JsonParseException e) {
                    System.out.println(file + " is having issues " + recipe);
                    KingdomKeys.LOGGER.error("Error parsing json file {}: {}", (Object)manager.func_199002_a(file).func_199029_a().toString(), (Object)e);
                    continue;
                }
                RecipeRegistry.getInstance().register(result);
                IOUtils.closeQuietly((Closeable)manager.func_199002_a(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

