/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.recipe;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.lib.Lists;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;

public class RecipeRegistry {
    private static RecipeRegistry INSTANCE;
    private Map<ResourceLocation, Recipe> registry = new HashMap<ResourceLocation, Recipe>();

    private RecipeRegistry() {
    }

    public static RecipeRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RecipeRegistry();
        }
        return INSTANCE;
    }

    public void register(Recipe recipe) {
        if (recipe.getRegistryName() != null) {
            this.registry.put(recipe.getRegistryName(), recipe);
            if (ModConfigs.debugConsoleOutput) {
                KingdomKeys.LOGGER.info("Successfully registered synthesis recipe {}", (Object)recipe.getRegistryName());
            }
            switch (recipe.type) {
                case "keyblade": {
                    Lists.keybladeRecipes.add(recipe.getRegistryName());
                    break;
                }
                case "item": {
                    Lists.itemRecipes.add(recipe.getRegistryName());
                }
            }
        } else {
            KingdomKeys.LOGGER.error("Cannot register Synthesis Recipe with no registry name");
        }
    }

    public Recipe getValue(ResourceLocation key) {
        if (this.containsKey(key)) {
            return this.registry.get(key);
        }
        KingdomKeys.LOGGER.error("Synthesis Recipe registry does not contain location: {}", (Object)key);
        return null;
    }

    public boolean containsKey(ResourceLocation key) {
        return this.registry.containsKey(key);
    }

    public void clearRegistry() {
        this.registry.clear();
        KingdomKeys.LOGGER.info("Synthesis Recipe registry cleared");
    }

    public Map<ResourceLocation, Recipe> getRegistry() {
        return this.registry;
    }

    public List<Recipe> getValues() {
        return new LinkedList<Recipe>(this.registry.values());
    }

    public void setRegistry(Map<ResourceLocation, Recipe> registry) {
        this.registry = registry;
    }
}

