/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.block.MosaicStainedGlassBlock;
import online.kingdomkeys.kingdomkeys.block.SoAPlatformCoreBlock;
import online.kingdomkeys.kingdomkeys.entity.block.PedestalTileEntity;
import online.kingdomkeys.kingdomkeys.entity.block.SoAPlatformTileEntity;
import online.kingdomkeys.kingdomkeys.item.ModItems;

public class DiveToTheHeartChunkGenerator
extends ChunkGenerator {
    private DimensionStructuresSettings settings;
    public static final Codec<DiveToTheHeartChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(surfaceChunkGenerator -> surfaceChunkGenerator.field_222542_c), (App)DimensionStructuresSettings.field_236190_a_.fieldOf("structures").forGetter(ChunkGenerator::func_235957_b_)).apply((Applicative)instance, instance.stable(DiveToTheHeartChunkGenerator::new)));
    private static final BlockPos SPAWN_POS = new BlockPos(0, 25, 0);
    private static final ChunkPos SPAWN_CHUNK_POS = new ChunkPos(SPAWN_POS);
    int width = 17;
    int height = 25;
    int depth = 17;
    String topOfPlatform = "0000000000000000000000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004000000000005000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    String structureTop = "0000011111110000000011111111111000001111111111111000111111111111111001111111111111110111111111111111111111111111111111111111111111111111111111112111111111111111111111111111111111111111111111111111111111110111111111111111001111111111111110001111111111111000001111111111100000000111111100000";
    String structureMiddle = "0000011111110000000011000000011000001000000000001000100000000000001001000000000000010100000000000000011000000000000000110000000000000001100000000000000011000000000000000110000000000000001100000000000000010100000000000001001000000000000010001000000000001000001100000001100000000111111100000";
    String structureBottom = "0000011111110000000011111111111000001111111111111000111111111111111001111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111001111111111111110001111111111111000001111111111100000000111111100000";

    public static void registerChunkGenerator() {
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)new ResourceLocation("kingdomkeys", "dive_to_the_heart_generator"), CODEC);
    }

    public DiveToTheHeartChunkGenerator(BiomeProvider biomeSource, DimensionStructuresSettings dimensionStructuresSettings) {
        this(biomeSource, biomeSource, dimensionStructuresSettings);
    }

    private DiveToTheHeartChunkGenerator(BiomeProvider biomeSource, BiomeProvider biomeSource2, DimensionStructuresSettings dimensionStructuresSettings) {
        super(biomeSource, biomeSource2, dimensionStructuresSettings, 0L);
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChunkGenerator func_230349_a_(long seed) {
        return new DiveToTheHeartChunkGenerator(this.field_222542_c.func_230320_a_(seed), this.settings);
    }

    public void func_225551_a_(WorldGenRegion p_225551_1_, IChunk p_225551_2_) {
    }

    private static int distance(int firstX, int firstZ, int secondX, int secondZ) {
        return Math.max(Math.abs(firstX - secondX), Math.abs(firstZ - secondZ));
    }

    public int func_205470_d() {
        return 0;
    }

    public void func_230352_b_(IWorld worldIn, StructureManager structureManagerIn, IChunk chunkIn) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        if (DiveToTheHeartChunkGenerator.distance(chunkIn.func_76632_l().field_77276_a, chunkIn.func_76632_l().field_77275_b, DiveToTheHeartChunkGenerator.SPAWN_CHUNK_POS.field_77276_a, DiveToTheHeartChunkGenerator.SPAWN_CHUNK_POS.field_77275_b) < 1) {
            int startZ = chunkIn.func_76632_l().func_180333_d() - this.depth / 2;
            int startX = chunkIn.func_76632_l().func_180334_c() - this.width / 2;
            for (int y = 0; y < this.height; ++y) {
                for (int z = startZ; z <= chunkIn.func_76632_l().func_180333_d() + this.depth / 2; ++z) {
                    for (int x = startX; x <= chunkIn.func_76632_l().func_180334_c() + this.width / 2; ++x) {
                        blockpos$mutable.func_181079_c(x, SPAWN_POS.func_177956_o() - y, z);
                        int strucX = x - startX;
                        int strucZ = z - startZ;
                        if (y == 0) {
                            this.stateToPlace(this.topOfPlatform.charAt(strucX + strucZ * this.width), worldIn, blockpos$mutable);
                            continue;
                        }
                        if (y == 1) {
                            this.stateToPlace(this.structureTop.charAt(strucX + strucZ * this.width), worldIn, blockpos$mutable);
                            continue;
                        }
                        if (y == this.height - 1) {
                            this.stateToPlace(this.structureBottom.charAt(strucX + strucZ * this.width), worldIn, blockpos$mutable);
                            continue;
                        }
                        this.stateToPlace(this.structureMiddle.charAt(strucX + strucZ * this.width), worldIn, blockpos$mutable);
                    }
                }
            }
        }
    }

    private void stateToPlace(char c, IWorld world, BlockPos.Mutable pos) {
        switch (c) {
            case '0': {
                return;
            }
            case '1': {
                world.func_180501_a((BlockPos)pos, (BlockState)((Block)ModBlocks.mosaic_stained_glass.get()).func_176223_P().func_206870_a((Property)MosaicStainedGlassBlock.STRUCTURE, (Comparable)Boolean.valueOf(true)), 2);
                break;
            }
            case '2': {
                world.func_180501_a((BlockPos)pos, (BlockState)((Block)ModBlocks.station_of_awakening_core.get()).func_176223_P().func_206870_a((Property)SoAPlatformCoreBlock.STRUCTURE, (Comparable)Boolean.valueOf(true)), 2);
                ((SoAPlatformTileEntity)world.func_175625_s((BlockPos)pos)).setMultiblockFormed(true);
                break;
            }
            case '3': {
                this.createPedestal(world, pos, new ItemStack((IItemProvider)ModItems.dreamSword.get()));
                break;
            }
            case '4': {
                this.createPedestal(world, pos, new ItemStack((IItemProvider)ModItems.dreamShield.get()));
                break;
            }
            case '5': {
                this.createPedestal(world, pos, new ItemStack((IItemProvider)ModItems.dreamStaff.get()));
            }
        }
    }

    private void createPedestal(IWorld world, BlockPos.Mutable pos, ItemStack toDisplay) {
        world.func_180501_a((BlockPos)pos, ((Block)ModBlocks.pedestal.get()).func_176223_P(), 2);
        PedestalTileEntity te = (PedestalTileEntity)world.func_175625_s((BlockPos)pos);
        te.setStationOfAwakeningMarker(true);
        te.setDisplayStack(toDisplay);
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        return 0;
    }

    public IBlockReader func_230348_a_(int p_230348_1_, int p_230348_2_) {
        return null;
    }
}

