/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.features;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.IRuleTestType;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.world.features.BloxOreFeature;
import online.kingdomkeys.kingdomkeys.world.features.BloxOreFeatureConfig;
import online.kingdomkeys.kingdomkeys.world.features.MultipleBlockMatchRuleTest;

public class ModFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"kingdomkeys");
    public static final RegistryObject<Feature<BloxOreFeatureConfig>> BLOX = FEATURES.register("blox", () -> new BloxOreFeature(BloxOreFeatureConfig.CODEC));
    public static final IRuleTestType<?> OVERWORLD_GROUND = IRuleTestType.func_237129_a_((String)"multiple_block_match", MultipleBlockMatchRuleTest.CODEC);
    public static ConfiguredFeature<?, ?> TWILIGHT_ORE_NETHER;
    public static ConfiguredFeature<?, ?> WELLSPRING_ORE_NETHER;
    public static ConfiguredFeature<?, ?> WRITHING_ORE_NETHER;
    public static ConfiguredFeature<?, ?> BLAZING_ORE_NETHER;
    public static ConfiguredFeature<?, ?> WRITHING_ORE_END;
    public static ConfiguredFeature<?, ?> PULSING_ORE_END;
    public static ConfiguredFeature<?, ?> BLOX_CLUSTER_END;
    public static ConfiguredFeature<?, ?> PRIZE_BLOX_CLUSTER_END;
    public static ConfiguredFeature<?, ?> BLOX_CLUSTER;
    public static ConfiguredFeature<?, ?> PRIZE_BLOX_CLUSTER;
    public static ConfiguredFeature<?, ?> BETWIXT_ORE;
    public static ConfiguredFeature<?, ?> SINISTER_ORE;
    public static ConfiguredFeature<?, ?> STORMY_ORE;
    public static ConfiguredFeature<?, ?> WRITHING_ORE;
    public static ConfiguredFeature<?, ?> HUNGRY_ORE;
    public static ConfiguredFeature<?, ?> LIGHTNING_ORE;
    public static ConfiguredFeature<?, ?> LUCID_ORE;
    public static ConfiguredFeature<?, ?> REMEMBRANCE_ORE;
    public static ConfiguredFeature<?, ?> SOOTHING_ORE;
    public static ConfiguredFeature<?, ?> TRANQUILITY_ORE;
    public static ConfiguredFeature<?, ?> TWILIGHT_ORE;
    public static ConfiguredFeature<?, ?> WELLSPRING_ORE;
    public static ConfiguredFeature<?, ?> BLAZING_ORE_WARM;
    public static ConfiguredFeature<?, ?> FROST_ORE_COLD;
    public static ConfiguredFeature<?, ?> PULSING_ORE_COLD;
    public static ConfiguredFeature<?, ?> FROST_ORE_COLDER;
    public static ConfiguredFeature<?, ?> PULSING_ORE_WET;
    public static ConfiguredFeature<?, ?> STORMY_ORE_WET;

    private static ConfiguredFeature<?, ?> addBloxOreFeature(ResourceLocation registryName, List<BlockState> blocks, int size, int height, int count) {
        ConfiguredFeature feature = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)BLOX.get()).func_225566_b_((IFeatureConfig)new BloxOreFeatureConfig(BloxOreFeatureConfig.FillerBlockType.OVERWORLD, blocks, size)).func_242733_d(height)).func_242728_a()).func_242731_b(count);
        return ModFeatures.register(registryName, feature);
    }

    private static ConfiguredFeature<?, ?> addEndBloxOreFeature(ResourceLocation registryName, List<BlockState> blocks, int size, int height, int count) {
        ConfiguredFeature feature = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)BLOX.get()).func_225566_b_((IFeatureConfig)new BloxOreFeatureConfig(BloxOreFeatureConfig.FillerBlockType.END, blocks, size)).func_242733_d(height)).func_242728_a()).func_242731_b(count);
        return ModFeatures.register(registryName, feature);
    }

    private static ConfiguredFeature<?, ?> addOreFeature(ResourceLocation registryName, RuleTest fillerBlock, Block block, int size, int height, int count) {
        ConfiguredFeature feature = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(fillerBlock, block.func_176223_P(), size)).func_242733_d(height)).func_242728_a()).func_242731_b(count);
        return ModFeatures.register(registryName, feature);
    }

    private static ConfiguredFeature<?, ?> addEndOre(ResourceLocation registryName, Block block, int size, int height, int count) {
        BlockMatchRuleTest END = new BlockMatchRuleTest(Blocks.field_150377_bs);
        return ModFeatures.addOreFeature(registryName, (RuleTest)END, block, size, height, count);
    }

    private static ConfiguredFeature<?, ?> addNetherOre(ResourceLocation registryName, Block block, int size, int height, int count) {
        return ModFeatures.addOreFeature(registryName, OreFeatureConfig.FillerBlockType.field_241883_b, block, size, height, count);
    }

    private static ConfiguredFeature<?, ?> addOverworldOre(ResourceLocation registryName, Block block, int size, int height, int count) {
        return ModFeatures.addOreFeature(registryName, OreFeatureConfig.FillerBlockType.field_241882_a, block, size, height, count);
    }

    private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> register(ResourceLocation key, ConfiguredFeature<FC, ?> configuredFeature) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)key, configuredFeature);
    }

    public static void registerConfiguredFeatures() {
        List<BlockState> BLOX_LIST = Arrays.asList(((Block)ModBlocks.normalBlox.get()).func_176223_P(), ((Block)ModBlocks.hardBlox.get()).func_176223_P(), ((Block)ModBlocks.metalBlox.get()).func_176223_P(), ((Block)ModBlocks.dangerBlox.get()).func_176223_P());
        List<BlockState> PRIZE_BLOX_LIST = Arrays.asList(((Block)ModBlocks.prizeBlox.get()).func_176223_P(), ((Block)ModBlocks.prizeBlox.get()).func_176223_P(), ((Block)ModBlocks.prizeBlox.get()).func_176223_P(), ((Block)ModBlocks.prizeBlox.get()).func_176223_P(), ((Block)ModBlocks.rarePrizeBlox.get()).func_176223_P(), ((Block)ModBlocks.rarePrizeBlox.get()).func_176223_P(), ((Block)ModBlocks.dangerBlox.get()).func_176223_P(), ((Block)ModBlocks.blastBlox.get()).func_176223_P());
        TWILIGHT_ORE_NETHER = ModFeatures.addNetherOre(ModFeatures.rl("twilight_ore_nether"), (Block)ModBlocks.twilightOreN.get(), 10, 100, 8);
        WELLSPRING_ORE_NETHER = ModFeatures.addNetherOre(ModFeatures.rl("wellspring_ore_nether"), (Block)ModBlocks.wellspringOreN.get(), 10, 100, 8);
        WRITHING_ORE_NETHER = ModFeatures.addNetherOre(ModFeatures.rl("writhing_ore_nether"), (Block)ModBlocks.writhingOreN.get(), 10, 100, 8);
        BLAZING_ORE_NETHER = ModFeatures.addNetherOre(ModFeatures.rl("blazing_ore_nether"), (Block)ModBlocks.blazingOreN.get(), 10, 100, 8);
        WRITHING_ORE_END = ModFeatures.addEndOre(ModFeatures.rl("writhing_ore_end"), (Block)ModBlocks.writhingOreE.get(), 6, 200, 8);
        PULSING_ORE_END = ModFeatures.addEndOre(ModFeatures.rl("pulsing_ore_end"), (Block)ModBlocks.pulsingOreE.get(), 6, 200, 8);
        BLOX_CLUSTER_END = ModFeatures.addEndBloxOreFeature(ModFeatures.rl("blox_cluster_end"), BLOX_LIST, 6, 216, 8);
        PRIZE_BLOX_CLUSTER_END = ModFeatures.addEndBloxOreFeature(ModFeatures.rl("prize_blox_cluster_end"), PRIZE_BLOX_LIST, 2, 216, 8);
        BLOX_CLUSTER = ModFeatures.addBloxOreFeature(ModFeatures.rl("blox_cluster"), BLOX_LIST, 10, 256, 10);
        PRIZE_BLOX_CLUSTER = ModFeatures.addBloxOreFeature(ModFeatures.rl("prize_blox_cluster"), PRIZE_BLOX_LIST, 6, 256, 4);
        BETWIXT_ORE = ModFeatures.addOverworldOre(ModFeatures.rl("betwixt_ore"), (Block)ModBlocks.betwixtOre.get(), 4, 20, 7);
        SINISTER_ORE = ModFeatures.addOverworldOre(ModFeatures.rl("sinister_ore"), (Block)ModBlocks.sinisterOre.get(), 4, 20, 7);
        STORMY_ORE = ModFeatures.addOverworldOre(ModFeatures.rl("stormy_ore"), (Block)ModBlocks.stormyOre.get(), 4, 20, 7);
        WRITHING_ORE = ModFeatures.addOverworldOre(ModFeatures.rl("writhing_ore"), (Block)ModBlocks.writhingOre.get(), 4, 20, 7);
        HUNGRY_ORE = ModFeatures.addOverworldOre(ModFeatures.rl("hungry_ore"), (Block)ModBlocks.hungryOre.get(), 4, 100, 7);
        LIGHTNING_ORE = ModFeatures.addOverworldOre(ModFeatures.rl("lightning_ore"), (Block)ModBlocks.lightningOre.get(), 4, 100, 7);
        LUCID_ORE = ModFeatures.addOverworldOre(ModFeatures.rl("lucid_ore"), (Block)ModBlocks.lucidOre.get(), 4, 100, 7);
        REMEMBRANCE_ORE = ModFeatures.addOverworldOre(ModFeatures.rl("remembrance_ore"), (Block)ModBlocks.remembranceOre.get(), 4, 100, 7);
        SOOTHING_ORE = ModFeatures.addOverworldOre(ModFeatures.rl("soothing_ore"), (Block)ModBlocks.soothingOre.get(), 4, 100, 7);
        TRANQUILITY_ORE = ModFeatures.addOverworldOre(ModFeatures.rl("tranquility_ore"), (Block)ModBlocks.tranquilityOre.get(), 4, 100, 7);
        TWILIGHT_ORE = ModFeatures.addOverworldOre(ModFeatures.rl("twilight_ore"), (Block)ModBlocks.twilightOre.get(), 4, 100, 7);
        WELLSPRING_ORE = ModFeatures.addOverworldOre(ModFeatures.rl("wellspring_ore"), (Block)ModBlocks.wellspringOre.get(), 4, 100, 7);
        BLAZING_ORE_WARM = ModFeatures.addOverworldOre(ModFeatures.rl("blazing_ore_warm"), (Block)ModBlocks.blazingOre.get(), 4, 100, 7);
        FROST_ORE_COLD = ModFeatures.addOverworldOre(ModFeatures.rl("frost_ore_cold"), (Block)ModBlocks.frostOre.get(), 4, 100, 7);
        PULSING_ORE_COLD = ModFeatures.addOverworldOre(ModFeatures.rl("pulsing_ore_cold"), (Block)ModBlocks.pulsingOre.get(), 4, 20, 7);
        FROST_ORE_COLDER = ModFeatures.addOverworldOre(ModFeatures.rl("forst_ore_colder"), (Block)ModBlocks.frostOre.get(), 4, 20, 7);
        PULSING_ORE_WET = ModFeatures.addOverworldOre(ModFeatures.rl("pulsing_ore_wet"), (Block)ModBlocks.pulsingOre.get(), 4, 20, 7);
        STORMY_ORE_WET = ModFeatures.addOverworldOre(ModFeatures.rl("stormy_ore_wet"), (Block)ModBlocks.stormyOre.get(), 4, 100, 7);
    }

    private static ResourceLocation rl(String string) {
        return new ResourceLocation("kingdomkeys", string);
    }

    public static void register() {
    }
}

