/*
 * Decompiled with CFR 0.152.
 */
package com.Mrbysco.LiquidBlocks.blocks;

import com.Mrbysco.LiquidBlocks.LiquidBlocks;
import com.Mrbysco.LiquidBlocks.config.LiquidConfigGen;
import com.Mrbysco.LiquidBlocks.tile.TileLiquidBlock;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BlockLiquidBlock
extends BlockFluidClassic
implements ITileEntityProvider {
    private final IBlockState block;
    private final int solidTime;

    public BlockLiquidBlock(Fluid fluid, Material material, IBlockState block, int solidTime) {
        super(fluid, material);
        this.block = block;
        this.solidTime = solidTime;
        this.func_149647_a(LiquidBlocks.liquidTab);
    }

    @Nonnull
    public String func_149739_a() {
        Fluid fluid = FluidRegistry.getFluid((String)this.fluidName);
        if (fluid != null) {
            return fluid.getUnlocalizedName();
        }
        return super.func_149739_a();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int adjacentSourceBlocks;
        if (!this.isSourceBlock((IBlockAccess)world, pos) && ForgeEventFactory.canCreateFluidSource((World)world, (BlockPos)pos, (IBlockState)state, (boolean)false) && (adjacentSourceBlocks = (this.isSourceBlock((IBlockAccess)world, pos.func_177978_c()) ? 1 : 0) + (this.isSourceBlock((IBlockAccess)world, pos.func_177968_d()) ? 1 : 0) + (this.isSourceBlock((IBlockAccess)world, pos.func_177974_f()) ? 1 : 0) + (this.isSourceBlock((IBlockAccess)world, pos.func_177976_e()) ? 1 : 0)) >= 2 && (world.func_180495_p(pos.func_177981_b(this.densityDir)).func_185904_a().func_76220_a() || this.isSourceBlock((IBlockAccess)world, pos.func_177981_b(this.densityDir)))) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        }
        int quantaRemaining = this.quantaPerBlock - (Integer)state.func_177229_b((IProperty)LEVEL);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            if (world.func_180495_p(pos.func_177982_a(0, -this.densityDir, 0)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(-1, -this.densityDir, 0)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(1, -this.densityDir, 0)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(0, -this.densityDir, -1)).func_177230_c() == this || world.func_180495_p(pos.func_177982_a(0, -this.densityDir, 1)).func_177230_c() == this) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(-1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(0, 0, -1), maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177982_a(0, 0, 1), maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    if (LiquidConfigGen.general.completelyFill) {
                        if (rand.nextInt(5) == 1) {
                            this.convertBlock(world, pos);
                        }
                    } else {
                        world.func_175698_g(pos);
                    }
                } else {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(this.quantaPerBlock - expQuanta)), 2);
                    world.func_175684_a(pos, (Block)this, this.tickRate);
                    world.func_175685_c(pos, (Block)this, false);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.func_180501_a(pos, this.func_176223_P(), 2);
        }
        if (this.canDisplace((IBlockAccess)world, pos.func_177981_b(this.densityDir))) {
            this.flowIntoBlock(world, pos.func_177981_b(this.densityDir), 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((IBlockAccess)world, pos) || !this.isFlowingVertically((IBlockAccess)world, pos)) {
            boolean[] flowTo;
            if (world.func_180495_p(pos.func_177979_c(this.densityDir)).func_177230_c() == this) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, pos))[0]) {
                this.flowIntoBlock(world, pos.func_177982_a(-1, 0, 0), flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, pos.func_177982_a(1, 0, 0), flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, pos.func_177982_a(0, 0, -1), flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, pos.func_177982_a(0, 0, 1), flowMeta);
            }
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        return super.displaceIfPossible(world, pos);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public void convertBlock(World world, BlockPos pos) {
        world.func_175713_t(pos);
        world.func_175656_a(pos, this.block);
        if (LiquidConfigGen.general.netherrackFireChance > 0 && this.block.func_177230_c() == Blocks.field_150424_aL && (!world.func_180495_p(pos.func_177984_a()).func_185917_h() || world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j()) && world.field_73012_v.nextInt(LiquidConfigGen.general.netherrackFireChance) <= 1) {
            world.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P().func_177226_a((IProperty)BlockFire.field_176543_a, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(15))));
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)entityIn;
            if (state.func_185904_a() == Material.field_151586_h) {
                if (LiquidConfigGen.general.liquidsCausesNausea) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 1));
                }
                if (LiquidConfigGen.general.liquidsCausesSlowness) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 1));
                }
            }
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileLiquidBlock(this.solidTime);
    }
}

