/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.liquidblocks.blocks;

import com.mrbysco.liquidblocks.config.LiquidConfig;
import com.mrbysco.liquidblocks.tile.TileLiquidBlock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class LiquidBlockBlock
extends FlowingFluidBlock {
    private final Supplier<Block> blockSupplier;

    public LiquidBlockBlock(AbstractBlock.Properties properties, Supplier<? extends FlowingFluid> supplier, Supplier<Block> blockSupplier) {
        super(supplier, properties);
        this.blockSupplier = blockSupplier;
    }

    public void convertBlock(World world, BlockPos pos) {
        world.func_175713_t(pos);
        world.func_175656_a(pos, this.blockSupplier.get().func_176223_P());
        int fireChance = (Integer)LiquidConfig.COMMON.netherrackFireChance.get();
        if (fireChance > 0 && this.blockSupplier.get() == Blocks.field_150424_aL && (!world.func_180495_p(pos.func_177984_a()).func_200132_m() || world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j()) && world.field_73012_v.nextInt(fireChance) <= 1) {
            world.func_175656_a(pos.func_177984_a(), (BlockState)Blocks.field_150480_ab.func_176223_P().func_206870_a((Property)FireBlock.field_176543_a, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(15))));
        }
    }

    public Supplier<Block> getLiquifiedBlock() {
        return this.blockSupplier;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (entityIn instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityIn;
            if (state.func_185904_a() == Material.field_151586_h) {
                if (((Boolean)LiquidConfig.COMMON.liquidCausesNausea.get()).booleanValue()) {
                    entity.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 1, false, false));
                }
                if (((Boolean)LiquidConfig.COMMON.liquidCausesSlowness.get()).booleanValue()) {
                    entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1, false, false));
                }
            }
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileLiquidBlock();
    }
}

