/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.liquidblocks.config;

import com.mrbysco.liquidblocks.LiquidBlocks;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class LiquidConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        LiquidBlocks.LOGGER.debug("Loaded Liquid Blocks' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        LiquidBlocks.LOGGER.fatal("Liquid Blocks' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue liquidCausesNausea;
        public final ForgeConfigSpec.BooleanValue liquidCausesSlowness;
        public final ForgeConfigSpec.BooleanValue completelyFill;
        public final ForgeConfigSpec.IntValue netherrackFireChance;
        public final ForgeConfigSpec.IntValue oreChance;
        public final ForgeConfigSpec.BooleanValue craftWithIce;
        public final ForgeConfigSpec.BooleanValue craftWithWaterBottle;
        public final ForgeConfigSpec.BooleanValue craftWithWaterBucket;
        public final ForgeConfigSpec.BooleanValue craftLiquidOre;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("general");
            this.liquidCausesNausea = builder.comment("When enabled causes water based liquid blocks to cause nausea when collided [default: true]").define("liquidCausesNausea", true);
            this.liquidCausesSlowness = builder.comment("When enabled causes water based liquid blocks to cause slowness when collided [default: true]").define("liquidCausesSlowness", true);
            this.completelyFill = builder.comment("When enabled causes will try to make the liquid turn every bit into a block [default: true]").define("completelyFill", true);
            this.netherrackFireChance = builder.comment("Makes liquid netherrack have a 1 in X chance of drying with fire on top (0 = disabled) [default: 30]").defineInRange("netherrackFireChance", 30, 1, Integer.MAX_VALUE);
            this.oreChance = builder.comment("Makes liquid ore have a 1 in X chance of drying into an ore block (higher = less chance) [default: 64]").defineInRange("oreChance", 64, 6, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Crafting settings").push("crafting");
            this.craftWithIce = builder.comment("Enable crafting buckets with ice [default: true]").define("craftWithIce", true);
            this.craftWithWaterBottle = builder.comment("Enable crafting buckets with a water bottle where applicable [default: true]").define("craftWithWaterBottle", true);
            this.craftWithWaterBucket = builder.comment("Enable crafting buckets with a bucket of the fitting liquid [default: true]").define("craftWithWaterBucket", true);
            this.craftLiquidOre = builder.comment("Enables the crafting of the Liquid Ore bucket [default: true]").define("craftLiquidOre", true);
            builder.pop();
        }
    }
}

