/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.liquidblocks.init;

import com.mrbysco.liquidblocks.blocks.LiquidBlockBlock;
import com.mrbysco.liquidblocks.blocks.LiquidOreBlock;
import com.mrbysco.liquidblocks.fluid.LiquidBlockFluid;
import com.mrbysco.liquidblocks.init.LiquidRegistry;
import com.mrbysco.liquidblocks.init.LiquidTab;
import com.mrbysco.liquidblocks.item.LiquidBucketItem;
import com.mrbysco.liquidblocks.util.FluidHelper;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.RegistryObject;

public class LiquidBlockReg<B extends FlowingFluidBlock> {
    private String name;
    private RegistryObject<ForgeFlowingFluid> source;
    private RegistryObject<ForgeFlowingFluid> flowing;
    private RegistryObject<FlowingFluidBlock> fluidblock;
    private RegistryObject<Item> bucket;

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public RegistryObject<ForgeFlowingFluid> getSource() {
        return this.source;
    }

    @Nonnull
    public RegistryObject<ForgeFlowingFluid> getFlowing() {
        return this.flowing;
    }

    @Nonnull
    public FlowingFluidBlock getFluidblock() {
        return (FlowingFluidBlock)this.fluidblock.get();
    }

    public RegistryObject<Item> getBucket() {
        return this.bucket;
    }

    public static ForgeFlowingFluid.Properties createProperties(FluidAttributes.Builder attributeBuilder, Supplier<ForgeFlowingFluid> still, Supplier<ForgeFlowingFluid> flowing, Supplier<Item> bucket, Supplier<FlowingFluidBlock> block) {
        return new ForgeFlowingFluid.Properties(still, flowing, attributeBuilder).bucket(bucket).block(block);
    }

    public LiquidBlockReg(String name, Supplier<Block> blockSupplier, Material material, int color) {
        this.name = name;
        this.source = LiquidRegistry.FLUIDS.register(name, () -> new LiquidBlockFluid.Source(LiquidBlockReg.createProperties(FluidHelper.createAttributes(color).temperature(material == Material.field_151586_h ? 300 : 1000), this.source, this.flowing, this.bucket, this.fluidblock)));
        this.flowing = LiquidRegistry.FLUIDS.register(name + "_flowing", () -> new LiquidBlockFluid.Flowing(LiquidBlockReg.createProperties(FluidHelper.createAttributes(color).temperature(material == Material.field_151586_h ? 300 : 1000), this.source, this.flowing, this.bucket, this.fluidblock)));
        this.fluidblock = name.equals("liquid_ore") ? LiquidRegistry.BLOCKS.register(name, () -> new LiquidOreBlock(AbstractBlock.Properties.func_200945_a((Material)material).func_200942_a().func_200943_b(100.0f).func_222380_e(), (Supplier<? extends FlowingFluid>)this.source, blockSupplier)) : LiquidRegistry.BLOCKS.register(name, () -> new LiquidBlockBlock(AbstractBlock.Properties.func_200945_a((Material)material).func_200942_a().func_200943_b(100.0f).func_222380_e(), (Supplier<? extends FlowingFluid>)this.source, blockSupplier));
        this.bucket = LiquidRegistry.ITEMS.register(name + "_bucket", () -> new LiquidBucketItem(new Item.Properties().func_200919_a(Items.field_151133_ar).func_200917_a(1).func_200916_a(LiquidTab.MAIN_TAB), (Supplier<? extends Fluid>)this.source));
    }

    public LiquidBlockReg(String name, Supplier<Block> blockSupplier, Material material, int color, int luminosity) {
        this.name = name;
        this.source = LiquidRegistry.FLUIDS.register(name, () -> new LiquidBlockFluid.Source(LiquidBlockReg.createProperties(FluidHelper.createAttributes(color).temperature(material == Material.field_151586_h ? 300 : 1000).luminosity(luminosity), this.source, this.flowing, this.bucket, this.fluidblock)));
        this.flowing = LiquidRegistry.FLUIDS.register(name + "_flowing", () -> new LiquidBlockFluid.Flowing(LiquidBlockReg.createProperties(FluidHelper.createAttributes(color).temperature(material == Material.field_151586_h ? 300 : 1000).luminosity(luminosity), this.source, this.flowing, this.bucket, this.fluidblock)));
        this.fluidblock = LiquidRegistry.BLOCKS.register(name, () -> new LiquidBlockBlock(AbstractBlock.Properties.func_200945_a((Material)material).func_200942_a().func_200943_b(100.0f).func_200944_c().func_222380_e().func_235838_a_(state -> luminosity), (Supplier<? extends FlowingFluid>)this.source, blockSupplier));
        this.bucket = LiquidRegistry.ITEMS.register(name + "_bucket", () -> new LiquidBucketItem(new Item.Properties().func_200919_a(Items.field_151133_ar).func_200917_a(1).func_200916_a(LiquidTab.MAIN_TAB), (Supplier<? extends Fluid>)this.source));
    }
}

