/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.liquidblocks.init.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrbysco.liquidblocks.init.recipes.LiquidRecipes;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapelessNoRemainderRecipe
extends ShapelessRecipe {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    private final ResourceLocation id;
    private final String group;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> recipeItems;
    private final boolean isSimple;

    public ShapelessNoRemainderRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(idIn, groupIn, recipeOutputIn, recipeItemsIn);
        this.id = idIn;
        this.group = groupIn;
        this.recipeOutput = recipeOutputIn;
        this.recipeItems = recipeItemsIn;
        this.isSimple = recipeItemsIn.stream().allMatch(Ingredient::isSimple);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)LiquidRecipes.SHAPELESS_NO_REMAINDER_SERIALIZER.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        return NonNullList.func_191196_a();
    }

    public static class SerializerShapelessNoRemainderRecipe
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapelessNoRemainderRecipe> {
        public ShapelessNoRemainderRecipe read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = SerializerShapelessNoRemainderRecipe.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > MAX_WIDTH * MAX_HEIGHT) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is " + MAX_WIDTH * MAX_HEIGHT);
            }
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new ShapelessNoRemainderRecipe(recipeId, s, itemstack, nonnulllist);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public ShapelessNoRemainderRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int i = buffer.func_150792_a();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new ShapelessNoRemainderRecipe(recipeId, s, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void write(PacketBuffer buffer, ShapelessNoRemainderRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            buffer.func_150787_b(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.recipeOutput);
        }
    }
}

