/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry;

import com.erfurt.magicaljewelry.MagicalJewelry;
import com.erfurt.magicaljewelry.command.JewelCommands;
import com.erfurt.magicaljewelry.init.ItemInit;
import com.erfurt.magicaljewelry.init.LootInit;
import com.erfurt.magicaljewelry.loot.conditions.BossEntityCondition;
import com.erfurt.magicaljewelry.loot.conditions.HostileEntityCondition;
import com.erfurt.magicaljewelry.loot.conditions.WaterEntityCondition;
import com.erfurt.magicaljewelry.loot.conditions.WaterHostileEntityCondition;
import com.erfurt.magicaljewelry.util.config.MagicalJewelryConfig;
import com.erfurt.magicaljewelry.util.handlers.ModColorHandler;
import com.erfurt.magicaljewelry.util.interfaces.IJewelAttributes;
import com.erfurt.magicaljewelry.util.interfaces.IJewelEffects;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Tuple;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;

public class SideProxy {
    SideProxy() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, MagicalJewelryConfig.COMMON_CONFIG);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, MagicalJewelryConfig.CLIENT_CONFIG);
        IJewelEffects.init();
        IJewelAttributes.init();
        LootInit.init();
        ItemInit.ITEMS.register(modEventBus);
        LootInit.GLM.register(modEventBus);
        modEventBus.addGenericListener(GlobalLootModifierSerializer.class, SideProxy::lootModifierRegistries);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::serverStarting);
        modEventBus.addListener(SideProxy::enqueue);
    }

    private static void enqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("necklace"));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("ring").setSize(2));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("bracelet").setSize(2));
        InterModComms.sendTo((String)"curios", (String)"register_icon", () -> new Tuple((Object)"bracelet", (Object)MagicalJewelry.getId("item/empty_bracelet_slot")));
        MagicalJewelry.LOGGER.info("enqueue method registered.");
    }

    private static void lootModifierRegistries(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new HostileEntityCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new BossEntityCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new WaterEntityCondition.Serializer());
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new WaterHostileEntityCondition.Serializer());
        MagicalJewelry.LOGGER.info("lootModifierRegistries method registered.");
    }

    private static void serverStarting(FMLServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().func_195571_aL().func_197054_a();
        JewelCommands.register((CommandDispatcher<CommandSource>)dispatcher);
    }

    static class Server
    extends SideProxy {
        Server() {
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addListener(Server::serverSetup);
        }

        private static void serverSetup(FMLDedicatedServerSetupEvent event) {
        }
    }

    static class Client
    extends SideProxy {
        Client() {
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addListener(Client::clientSetup);
            modEventBus.addListener(ModColorHandler::registerItemColor);
            modEventBus.addListener(this::stitchTextures);
        }

        private static void clientSetup(FMLClientSetupEvent event) {
        }

        private void stitchTextures(TextureStitchEvent.Pre event) {
            if (event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
                event.addSprite(MagicalJewelry.getId("item/empty_bracelet_slot"));
            }
        }
    }
}

