/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.objects.items;

import com.erfurt.magicaljewelry.MagicalJewelry;
import com.erfurt.magicaljewelry.capability.JewelItemCapability;
import com.erfurt.magicaljewelry.init.ItemInit;
import com.erfurt.magicaljewelry.objects.items.JewelAmuletItem;
import com.erfurt.magicaljewelry.render.model.JewelAmuletModel;
import com.erfurt.magicaljewelry.util.config.MagicalJewelryConfigBuilder;
import com.erfurt.magicaljewelry.util.enums.JewelRarity;
import com.erfurt.magicaljewelry.util.interfaces.IJewel;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import top.theillusivec4.curios.api.capability.ICurio;

public class JewelItem
extends Item
implements IJewel {
    private static final String NBT_RARITY = "Rarity";
    private static final String NBT_EFFECTS = "Effects";
    private static final String NBT_LEGENDARY_EFFECT = "LegendaryEffect";
    private static final String NBT_ATTRIBUTES = "Attributes";
    private static final String NBT_UUID = "UUID";
    private static final String NBT_COLOR = "GemColor";
    public static List<Integer> jewelEffects = new ArrayList<Integer>();
    public static Map<LivingEntity, Map<Effect, Integer>> totalJewelEffectsPlayer = new LinkedHashMap<LivingEntity, Map<Effect, Integer>>();
    public static Multimap<String, AttributeModifier> jewelAttributesForRemoval = HashMultimap.create();
    public static final ResourceLocation GOLD_AMULET_TEXTURE = MagicalJewelry.getId("textures/models/amulet/gold_amulet.png");
    public static final ResourceLocation SILVER_AMULET_TEXTURE = MagicalJewelry.getId("textures/models/amulet/silver_amulet.png");
    public static final ResourceLocation GEM_AMULET_TEXTURE = MagicalJewelry.getId("textures/models/amulet/gem_amulet.png");

    public JewelItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(MagicalJewelry.GROUP));
    }

    public int getMaxDamage(ItemStack stack) {
        String rarity;
        int durability = ((Boolean)MagicalJewelryConfigBuilder.JEWEL_DURABILITY.get()).booleanValue() ? ((rarity = JewelItem.getJewelRarity(stack)).equals(JewelRarity.UNCOMMON.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_UNCOMMON_DURABILITY.get() : (rarity.equals(JewelRarity.RARE.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_RARE_DURABILITY.get() : (rarity.equals(JewelRarity.EPIC.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_EPIC_DURABILITY.get() : 0))) : 0;
        return durability;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        return JewelItemCapability.createProvider(new ICurio(){
            private Object amuletModel;

            public boolean hasRender(String identifier, LivingEntity livingEntity) {
                return stack.func_77973_b() instanceof JewelAmuletItem;
            }

            public void render(String identifier, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                ICurio.RenderHelper.translateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
                ICurio.RenderHelper.rotateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
                if (!(this.amuletModel instanceof JewelAmuletModel)) {
                    this.amuletModel = new JewelAmuletModel();
                }
                JewelAmuletModel jewelAmuletModel = (JewelAmuletModel)((Object)this.amuletModel);
                IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)jewelAmuletModel.func_228282_a_(JewelItem.getRenderType(stack)), (boolean)false, (boolean)stack.func_77962_s());
                jewelAmuletModel.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                float[] i = DyeColor.func_204271_a((String)JewelItem.getGemColor(stack), (DyeColor)DyeColor.WHITE).func_193349_f();
                float red = i[0];
                float green = i[1];
                float blue = i[2];
                IVertexBuilder vertexBuilderGem = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)jewelAmuletModel.func_228282_a_(GEM_AMULET_TEXTURE), (boolean)false, (boolean)stack.func_77962_s());
                jewelAmuletModel.func_225598_a_(matrixStack, vertexBuilderGem, light, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
            }

            public void onCurioTick(String identifier, int index, LivingEntity livingEntity) {
                if (!livingEntity.func_130014_f_().field_72995_K && stack.func_77973_b() instanceof JewelItem) {
                    if (livingEntity.field_70173_aa % 19 == 0) {
                        stack.func_222118_a(1, livingEntity, livingEntity1 -> {});
                    }
                    if (livingEntity.field_70173_aa % 199 == 0 && totalJewelEffectsPlayer.containsKey(livingEntity) && !totalJewelEffectsPlayer.get(livingEntity).isEmpty()) {
                        JewelItem.this.updateJewelEffects(stack, livingEntity, false);
                        if (!((Boolean)MagicalJewelryConfigBuilder.JEWEL_ATTRIBUTES.get()).booleanValue()) {
                            livingEntity.func_110140_aT().func_111148_a(jewelAttributesForRemoval);
                        }
                    }
                }
            }

            public void onEquipped(String identifier, LivingEntity livingEntity) {
                if (stack.func_77973_b() instanceof JewelItem) {
                    JewelItem.this.getTotalJewelEffects(stack, livingEntity);
                    JewelItem.this.updateJewelEffects(stack, livingEntity, false);
                }
            }

            public void onUnequipped(String identifier, LivingEntity livingEntity) {
                if (stack.func_77973_b() instanceof JewelItem) {
                    JewelItem.this.updateJewelEffects(stack, livingEntity, true);
                }
            }

            public Multimap<String, AttributeModifier> getAttributeModifiers(String identifier) {
                HashMultimap attributes = HashMultimap.create();
                if (stack.func_77973_b() instanceof JewelItem && stack.func_77978_p().func_74764_b(JewelItem.NBT_ATTRIBUTES) && stack.func_77978_p().func_74764_b(JewelItem.NBT_UUID)) {
                    JewelItem.this.updateJewelAttributes(stack, (Multimap<String, AttributeModifier>)attributes);
                }
                return attributes;
            }

            public boolean canRightClickEquip() {
                return true;
            }
        });
    }

    private static ResourceLocation getRenderType(ItemStack stack) {
        if (stack.func_77973_b() == ((Item)ItemInit.GOLD_AMULET.get()).getItem()) {
            return GOLD_AMULET_TEXTURE;
        }
        return SILVER_AMULET_TEXTURE;
    }

    public void updateJewelEffects(ItemStack stack, LivingEntity player, boolean removeEffects) {
        block10: {
            block9: {
                if (!removeEffects) break block9;
                if (this.legendaryEffectsEnabled(stack)) {
                    int j = JewelItem.getJewelLegendaryEffect(stack);
                    Effect effect = (Effect)legendaryEffectsList.toArray()[j];
                    this.updateJewelEffects(player, effect);
                }
                for (int i = 0; i < this.effectsLength(stack); ++i) {
                    int j = JewelItem.getJewelEffects(stack)[i];
                    Effect effect = (Effect)defaultEffectsList.toArray()[j];
                    this.updateJewelEffects(player, effect);
                }
                break block10;
            }
            String rarity = JewelItem.getJewelRarity(stack);
            if (!JewelRarity.containsRarity(rarity)) break block10;
            for (int i = 0; i < totalJewelEffectsPlayer.get(player).size(); ++i) {
                Effect effect = (Effect)totalJewelEffectsPlayer.get(player).keySet().toArray()[i];
                int level = (Integer)totalJewelEffectsPlayer.get(player).values().toArray()[i] - 1;
                int maxLevel = (Integer)MagicalJewelryConfigBuilder.JEWEL_MAX_EFFECT_LEVEL.get();
                switch (maxLevel) {
                    case 1: {
                        level = 0;
                        break;
                    }
                    case 2: {
                        if (level <= 1) break;
                        level = 1;
                        break;
                    }
                    case 3: {
                        if (level <= 2) break;
                        level = 2;
                    }
                }
                boolean legendaryFlag = legendaryEffectsList.contains(effect);
                if (legendaryFlag) {
                    level = 0;
                }
                player.func_195064_c(new EffectInstance(effect, Integer.MAX_VALUE, level, true, false, (Boolean)MagicalJewelryConfigBuilder.JEWEL_EFFECT_ICON.get() == false));
                if (!rarity.equals(JewelRarity.LEGENDARY.getName())) continue;
                this.legendaryEffectRemoval(stack, player);
            }
        }
    }

    private void updateJewelEffects(LivingEntity player, Effect effect) {
        int length = totalJewelEffectsPlayer.get(player).size();
        for (int k = 0; k < length; ++k) {
            if (!totalJewelEffectsPlayer.get(player).keySet().toArray()[k].equals(effect)) continue;
            int oldValue = (Integer)totalJewelEffectsPlayer.get(player).values().toArray()[k];
            int newValue = (Integer)totalJewelEffectsPlayer.get(player).values().toArray()[k] - 1;
            totalJewelEffectsPlayer.get(player).replace(effect, oldValue, newValue);
            if (newValue < 1) {
                totalJewelEffectsPlayer.get(player).remove(effect);
                player.func_195063_d(effect);
                break;
            }
            boolean legendaryFlag = legendaryEffectsList.contains(effect);
            if (legendaryFlag || newValue >= (Integer)MagicalJewelryConfigBuilder.JEWEL_MAX_EFFECT_LEVEL.get()) continue;
            player.func_195063_d(effect);
            player.func_195064_c(new EffectInstance(effect, Integer.MAX_VALUE, newValue - 1, true, false, (Boolean)MagicalJewelryConfigBuilder.JEWEL_EFFECT_ICON.get() == false));
        }
    }

    private void legendaryEffectRemoval(ItemStack stack, LivingEntity player) {
        if (!this.legendaryEffectsEnabled(stack)) {
            int j = JewelItem.getJewelLegendaryEffect(stack);
            Effect effect = (Effect)legendaryEffectsList.toArray()[j];
            boolean effectIsActive = player.func_193076_bZ().containsKey(effect);
            if (effectIsActive) {
                boolean effectDuration;
                boolean bl = effectDuration = player.func_70660_b(effect).func_76459_b() > 10000;
                if (effectDuration) {
                    player.func_195063_d(effect);
                }
            }
        }
    }

    public void getTotalJewelEffects(ItemStack stack, LivingEntity player) {
        if (this.legendaryEffectsEnabled(stack)) {
            int j = JewelItem.getJewelLegendaryEffect(stack);
            Effect effect = (Effect)legendaryEffectsList.toArray()[j];
            this.updateTotalJewelEffects(effect, player);
        }
        for (int i = 0; i < this.effectsLength(stack); ++i) {
            int j = JewelItem.getJewelEffects(stack)[i];
            Effect effect = (Effect)defaultEffectsList.toArray()[j];
            this.updateTotalJewelEffects(effect, player);
        }
    }

    private void updateTotalJewelEffects(Effect effect, LivingEntity player) {
        if (totalJewelEffectsPlayer.containsKey(player)) {
            if (!totalJewelEffectsPlayer.get(player).isEmpty()) {
                int length = totalJewelEffectsPlayer.get(player).size();
                for (int k = 0; k < length; ++k) {
                    if (totalJewelEffectsPlayer.get(player).keySet().toArray()[k].equals(effect)) {
                        int oldValue = (Integer)totalJewelEffectsPlayer.get(player).values().toArray()[k];
                        int newValue = (Integer)totalJewelEffectsPlayer.get(player).values().toArray()[k] + 1;
                        totalJewelEffectsPlayer.get(player).replace(effect, oldValue, newValue);
                        break;
                    }
                    if (k != length - 1) continue;
                    totalJewelEffectsPlayer.get(player).put(effect, 1);
                }
            } else {
                totalJewelEffectsPlayer.get(player).put(effect, 1);
            }
        } else {
            totalJewelEffectsPlayer.put(player, new HashMap());
            totalJewelEffectsPlayer.get(player).put(effect, 1);
        }
    }

    public void updateJewelAttributes(ItemStack stack, Multimap<String, AttributeModifier> jewelAttributes) {
        if (JewelItem.getJewelRarity(stack).equals(JewelRarity.LEGENDARY.getName()) || JewelItem.getJewelRarity(stack).equals(JewelRarity.EPIC.getName())) {
            double amount = 2.0;
            int index = JewelItem.getJewelAttributes(stack);
            switch (index) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (!(stack.func_77973_b() instanceof JewelAmuletItem)) break;
                    amount = 4.0;
                    break;
                }
                case 3: {
                    if (stack.func_77973_b() instanceof JewelAmuletItem) {
                        amount = 8.0;
                        break;
                    }
                    amount = 4.0;
                    break;
                }
                case 4: {
                    amount = 1.0;
                }
            }
            String uuid = JewelItem.getJewelUUID(stack);
            AttributeModifier attributeModifier = new AttributeModifier(UUID.fromString(uuid), (String)descriptionAttributesList.get(index), amount, AttributeModifier.Operation.ADDITION);
            jewelAttributesForRemoval.put(nameAttributesList.get(index), (Object)attributeModifier);
            if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_ATTRIBUTES.get()).booleanValue()) {
                jewelAttributes.put(nameAttributesList.get(index), (Object)attributeModifier);
            }
        }
    }

    public boolean legendaryEffectsEnabled(ItemStack stack) {
        return (Boolean)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_EFFECTS.get() != false && JewelItem.getJewelRarity(stack).equals(JewelRarity.LEGENDARY.getName());
    }

    public int effectsLength(ItemStack stack) {
        String rarity = JewelItem.getJewelRarity(stack);
        int effectLength = rarity.equals(JewelRarity.UNCOMMON.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_UNCOMMON_EFFECT_AMOUNT.get() : (rarity.equals(JewelRarity.RARE.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_RARE_EFFECT_AMOUNT.get() : (rarity.equals(JewelRarity.EPIC.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_EPIC_EFFECT_AMOUNT.get() : (rarity.equals(JewelRarity.LEGENDARY.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_EFFECT_AMOUNT.get() : 0)));
        return effectLength;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        block6: {
            block5: {
                String rarity = JewelItem.getJewelRarity(stack);
                if (!JewelRarity.containsRarity(rarity)) break block5;
                tooltip.set(0, tooltip.get(0).func_211708_a(JewelRarity.byName(rarity).getFormat()));
                if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_RARITY_NAME.get()).booleanValue()) {
                    tooltip.set(0, tooltip.get(0).func_150258_a(" (" + JewelRarity.byName(rarity).getDisplayName() + ")"));
                }
                if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_RARITY_TOOLTIP.get()).booleanValue()) {
                    tooltip.add((ITextComponent)new StringTextComponent(JewelRarity.byName(rarity).getFormat() + JewelRarity.byName(rarity).getDisplayName()));
                }
                if (this.legendaryEffectsEnabled(stack) && stack.func_77978_p().func_74764_b(NBT_LEGENDARY_EFFECT)) {
                    int j = JewelItem.getJewelLegendaryEffect(stack);
                    Effect effect = (Effect)legendaryEffectsList.toArray()[j];
                    String effectName = effect.func_199286_c().getString();
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + effectName));
                }
                if (!stack.func_77978_p().func_74764_b(NBT_EFFECTS)) break block6;
                for (int i = 0; i < this.effectsLength(stack); ++i) {
                    int j = JewelItem.getJewelEffects(stack)[i];
                    Effect effect = (Effect)defaultEffectsList.toArray()[j];
                    String effectName = effect.func_199286_c().getString();
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + effectName));
                }
                break block6;
            }
            String creativeJewelTooltip = new TranslationTextComponent("item.magicaljewelry.tooltip.creative", new Object[0]).getString();
            for (String s : creativeJewelTooltip.split("(?<=\\G.{25,}\\s)")) {
                tooltip.add(new StringTextComponent(s).func_211708_a(TextFormatting.RED));
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return JewelItem.getJewelRarity(stack).equals(JewelRarity.LEGENDARY.getName());
    }

    public static String getJewelRarity(ItemStack stack) {
        return stack.func_196082_o().func_74779_i(NBT_RARITY);
    }

    public static ItemStack setJewelRarity(ItemStack stack, String rarity) {
        stack.func_196082_o().func_74778_a(NBT_RARITY, rarity);
        return stack;
    }

    public static int[] getJewelEffects(ItemStack stack) {
        return stack.func_196082_o().func_74759_k(NBT_EFFECTS);
    }

    public static ItemStack setJewelEffects(ItemStack stack, List<Integer> effects) {
        stack.func_196082_o().func_197646_b(NBT_EFFECTS, effects);
        return stack;
    }

    public static int getJewelLegendaryEffect(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(NBT_LEGENDARY_EFFECT);
    }

    public static ItemStack setJewelLegendaryEffect(ItemStack stack, int legendaryEffect) {
        stack.func_196082_o().func_74768_a(NBT_LEGENDARY_EFFECT, legendaryEffect);
        return stack;
    }

    public static int getJewelAttributes(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(NBT_ATTRIBUTES);
    }

    public static ItemStack setJewelAttributes(ItemStack stack, int attributes) {
        stack.func_196082_o().func_74768_a(NBT_ATTRIBUTES, attributes);
        return stack;
    }

    public static String getJewelUUID(ItemStack stack) {
        return stack.func_196082_o().func_74779_i(NBT_UUID);
    }

    public static ItemStack setJewelUUID(ItemStack stack, String uuid) {
        stack.func_196082_o().func_74778_a(NBT_UUID, uuid);
        return stack;
    }

    public static String getGemColor(ItemStack stack) {
        return stack.func_196082_o().func_74779_i(NBT_COLOR);
    }

    public static ItemStack setGemColor(ItemStack stack, String color) {
        stack.func_196082_o().func_74778_a(NBT_COLOR, color);
        return stack;
    }

    public static int getItemColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return DyeColor.func_204271_a((String)JewelItem.getGemColor(stack), (DyeColor)DyeColor.WHITE).getColorValue();
        }
        return 0xFFFFFF;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (DyeColor color : DyeColor.values()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                JewelItem.setGemColor(stack, color.func_176610_l());
                items.add((Object)stack);
            }
        }
    }
}

