/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.util.enums;

import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public enum JewelRarity {
    UNCOMMON("uncommon", TextFormatting.DARK_GREEN),
    RARE("rare", TextFormatting.DARK_AQUA),
    EPIC("epic", TextFormatting.DARK_PURPLE),
    LEGENDARY("legendary", TextFormatting.GOLD);

    private final String name;
    private final TextFormatting format;
    private final ITextComponent displayName;

    private JewelRarity(String nameIn, TextFormatting formatIn) {
        this.name = nameIn;
        this.format = formatIn;
        this.displayName = new TranslationTextComponent("rarity.magicaljewelry." + nameIn, new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName.getString();
    }

    public TextFormatting getFormat() {
        return this.format;
    }

    public static JewelRarity byName(String name) {
        for (JewelRarity rarity : JewelRarity.values()) {
            if (!rarity.name.equals(name)) continue;
            return rarity;
        }
        return null;
    }

    public static boolean containsRarity(String name) {
        for (JewelRarity rarity : JewelRarity.values()) {
            if (!rarity.name.equals(name)) continue;
            return true;
        }
        return false;
    }
}

