/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.command;

import com.erfurt.magicaljewelry.MagicalJewelry;
import com.erfurt.magicaljewelry.data.loot.loottable.ModChestLootTablesBuilder;
import com.erfurt.magicaljewelry.data.loot.loottable.ModEntityLootTablesBuilder;
import com.erfurt.magicaljewelry.objects.items.JewelItem;
import com.erfurt.magicaljewelry.util.LootTableUtil;
import com.erfurt.magicaljewelry.util.config.MagicalJewelryConfigBuilder;
import com.erfurt.magicaljewelry.util.enums.JewelRarity;
import com.erfurt.magicaljewelry.util.interfaces.IJewelNBTHandler;
import com.erfurt.magicaljewelry.util.interfaces.IJewelRarity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public final class JewelCommands
implements IJewelNBTHandler {
    private static final String jewelTestLoot = "jewelTestLoot";
    private static final String jewelGive = "jewelGive";
    private static final String targets = "targets";
    private static final String itemId = "itemId";
    private static final String rarityId = "rarity";
    private static final String randomRarity = "random";
    private static final String lootTableSettings = "lootTable";
    private static final String hostileLootDrop = ModEntityLootTablesBuilder.hostileLootTable;
    private static final String bossLootDrop = ModEntityLootTablesBuilder.bossLootTable;
    private static final String chestLootDrop = ModChestLootTablesBuilder.chestLootTable;
    private static final String allLootTables = "all_jewel_drops";
    private static final String chestHostileDrop = "chests_hostile_jewel_drops";
    private static final String[] rarities = new String[]{"random", JewelRarity.UNCOMMON.getName(), JewelRarity.RARE.getName(), JewelRarity.EPIC.getName(), JewelRarity.LEGENDARY.getName()};
    private static final String[] testLootTables = new String[]{hostileLootDrop, bossLootDrop, chestLootDrop, "chests_hostile_jewel_drops", "all_jewel_drops"};
    private static final SuggestionProvider<CommandSource> itemIdSuggestions = (context, builder) -> ISuggestionProvider.func_212476_a(ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof JewelItem).map(ForgeRegistryEntry::getRegistryName), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSource> raritySuggestions = (context, builder) -> ISuggestionProvider.func_197008_a((String[])rarities, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSource> testLootSuggestions = (context, builder) -> ISuggestionProvider.func_197008_a((String[])testLootTables, (SuggestionsBuilder)builder);

    private JewelCommands() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builderJewelGive = (LiteralArgumentBuilder)Commands.func_197057_a((String)jewelGive).requires(source -> source.func_197034_c(2));
        LiteralArgumentBuilder builderTestLoot = Commands.func_197057_a((String)jewelTestLoot);
        builderJewelGive.then(Commands.func_197056_a((String)targets, (ArgumentType)EntityArgument.func_197094_d()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)itemId, (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(itemIdSuggestions).executes(context -> JewelCommands.giveJewel((CommandSource)context.getSource(), ResourceLocationArgument.func_197195_e((CommandContext)context, (String)itemId), EntityArgument.func_197090_e((CommandContext)context, (String)targets), randomRarity))).then(Commands.func_197056_a((String)rarityId, (ArgumentType)StringArgumentType.string()).suggests(raritySuggestions).executes(context -> JewelCommands.giveJewel((CommandSource)context.getSource(), ResourceLocationArgument.func_197195_e((CommandContext)context, (String)itemId), EntityArgument.func_197090_e((CommandContext)context, (String)targets), StringArgumentType.getString((CommandContext)context, (String)rarityId).toLowerCase(Locale.ROOT))))));
        ((LiteralArgumentBuilder)builderTestLoot.executes(context -> JewelCommands.testLoot((CommandSource)context.getSource(), allLootTables))).then(Commands.func_197056_a((String)lootTableSettings, (ArgumentType)StringArgumentType.string()).suggests(testLootSuggestions).executes(context -> JewelCommands.testLoot((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)lootTableSettings))));
        dispatcher.register(builderJewelGive);
        dispatcher.register(builderTestLoot);
    }

    private static int giveJewel(CommandSource source, ResourceLocation itemId, Collection<ServerPlayerEntity> targets, String rarity) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        if (item == null) {
            source.func_197021_a((ITextComponent)JewelCommands.translationTextComponent(jewelGive, "failure.exist", itemId.toString()));
            return 0;
        }
        if (!(item instanceof JewelItem)) {
            source.func_197021_a((ITextComponent)JewelCommands.translationTextComponent(jewelGive, "failure.item", itemId.toString()));
            return 0;
        }
        ItemStack stack = new ItemStack((IItemProvider)item, 1);
        for (ServerPlayerEntity player : targets) {
            ItemEntity entityItem;
            if (rarity.equals(randomRarity)) {
                rarity = IJewelRarity.getRarityCommand();
            } else if (!JewelRarity.containsRarity(rarity)) {
                source.func_197021_a((ITextComponent)JewelCommands.translationTextComponent(jewelGive, "failure.rarity", rarity));
                return 0;
            }
            IJewelNBTHandler.setJewelNBTData(stack, rarity);
            boolean addedToInventory = player.field_71071_by.func_70441_a(stack);
            if (addedToInventory && stack.func_190926_b()) {
                stack.func_190920_e(1);
                entityItem = player.func_71019_a(stack, false);
                if (entityItem != null) {
                    entityItem.func_174870_v();
                }
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.field_71069_bz.func_75142_b();
                continue;
            }
            entityItem = player.func_71019_a(stack, false);
            if (entityItem == null) continue;
            entityItem.func_174868_q();
            entityItem.func_200217_b(player.func_110124_au());
        }
        IFormattableTextComponent itemText = stack.func_151000_E().func_230532_e_().func_240699_a_(JewelRarity.byName(rarity).getFormat());
        if (targets.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.give.success.single", new Object[]{1, itemText, targets.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.give.success.single", new Object[]{1, itemText, targets.size()}), true);
        }
        return targets.size();
    }

    private static int testLoot(CommandSource source, String lootTable) {
        MinecraftServer server = source.func_197028_i();
        String[] settings = new String[]{jewelTestLoot, "settings"};
        String[] droprate = new String[]{jewelTestLoot, "droprate"};
        String[] dropratewith = new String[]{jewelTestLoot, "dropratewith"};
        String[] config1 = new String[]{jewelTestLoot, "config1"};
        String[] config2 = new String[]{jewelTestLoot, "config2"};
        String looting = Enchantments.field_185304_p.func_200305_d(3).getString();
        TranslationTextComponent typeHostile = JewelCommands.translationTextComponent(jewelTestLoot, "type.hostile");
        TranslationTextComponent typeBoss = JewelCommands.translationTextComponent(jewelTestLoot, "type.boss");
        TranslationTextComponent typeChest = JewelCommands.translationTextComponent(jewelTestLoot, "type.chest");
        TranslationTextComponent hostile = JewelCommands.translationTextComponent(settings, typeHostile.getString());
        TranslationTextComponent chest = JewelCommands.translationTextComponent(settings, typeChest.getString());
        TranslationTextComponent boss = JewelCommands.translationTextComponent(settings, typeBoss.getString());
        TranslationTextComponent chestHostile = JewelCommands.translationTextComponent(settings, typeChest.getString() + " & " + typeHostile.getString());
        float hostileDropRate = LootTableUtil.getChance(MagicalJewelry.getId("entities/" + hostileLootDrop), server);
        float hostileLootingMultiplier = LootTableUtil.getLootingMultiplier(MagicalJewelry.getId("entities/" + hostileLootDrop), server);
        float bossDropRate = LootTableUtil.getChance(MagicalJewelry.getId("entities/" + bossLootDrop), server);
        float bossLootingMultiplier = LootTableUtil.getLootingMultiplier(MagicalJewelry.getId("entities/" + bossLootDrop), server);
        float chestDropRate = LootTableUtil.getChance(MagicalJewelry.getId("inject/chests/" + chestLootDrop), server);
        IFormattableTextComponent hostileDropRatePercent = null;
        IFormattableTextComponent hostileDropRateLooting = null;
        IFormattableTextComponent bossDropRatePercent = null;
        IFormattableTextComponent bossDropRateLooting = null;
        IFormattableTextComponent chestDropRatePercent = null;
        if (hostileLootingMultiplier >= 0.0f && hostileDropRate >= 0.0f) {
            hostileDropRatePercent = new StringTextComponent(typeHostile.getString() + " - ").func_230529_a_((ITextComponent)JewelCommands.translationTextComponent(droprate, JewelCommands.floatToDeci(hostileDropRate * 100.0f))).func_240699_a_(TextFormatting.GREEN);
            hostileDropRateLooting = new StringTextComponent(typeHostile.getString() + " - ").func_230529_a_((ITextComponent)JewelCommands.translationTextComponent(dropratewith, looting, JewelCommands.dropRateWithLootingPercent(hostileDropRate, hostileLootingMultiplier))).func_240699_a_(TextFormatting.GREEN);
        } else if (hostileDropRate >= 0.0f) {
            hostileDropRatePercent = new StringTextComponent(typeHostile.getString() + " - ").func_230529_a_((ITextComponent)JewelCommands.translationTextComponent(droprate, JewelCommands.floatToDeci(hostileDropRate * 100.0f))).func_240699_a_(TextFormatting.GREEN);
        }
        if (bossLootingMultiplier >= 0.0f && bossDropRate >= 0.0f) {
            bossDropRatePercent = new StringTextComponent(typeBoss.getString() + " - ").func_230529_a_((ITextComponent)JewelCommands.translationTextComponent(droprate, JewelCommands.floatToDeci(bossDropRate * 100.0f))).func_240699_a_(TextFormatting.GREEN);
            bossDropRateLooting = new StringTextComponent(typeBoss.getString() + " - ").func_230529_a_((ITextComponent)JewelCommands.translationTextComponent(dropratewith, looting, JewelCommands.dropRateWithLootingPercent(bossDropRate, bossLootingMultiplier))).func_240699_a_(TextFormatting.GREEN);
        } else if (bossDropRate >= 0.0f) {
            bossDropRatePercent = new StringTextComponent(typeBoss.getString() + " - ").func_230529_a_((ITextComponent)JewelCommands.translationTextComponent(droprate, JewelCommands.floatToDeci(bossDropRate * 100.0f))).func_240699_a_(TextFormatting.GREEN);
        }
        if (chestDropRate >= 0.0f) {
            chestDropRatePercent = new StringTextComponent(typeChest.getString() + " - ").func_230529_a_((ITextComponent)JewelCommands.translationTextComponent(droprate, JewelCommands.floatToDeci(chestDropRate * 100.0f))).func_240699_a_(TextFormatting.GREEN);
        }
        IFormattableTextComponent oneRarityDrop = JewelCommands.translationTextComponent(config1, "'oneRarityDrop'", "true").func_240699_a_(TextFormatting.YELLOW);
        IFormattableTextComponent legendaryUpgradeOnly = JewelCommands.translationTextComponent(config1, "'legendaryUpgradeOnly'", "true").func_240699_a_(TextFormatting.YELLOW);
        IFormattableTextComponent bothConfigOptions = JewelCommands.translationTextComponent(config2, "'legendaryUpgradeOnly'", "'oneRarityDrop'", "false").func_240699_a_(TextFormatting.YELLOW);
        IFormattableTextComponent chestDisable = JewelCommands.translationTextComponent(config1, "'jewelsInChest'", "false").func_240699_a_(TextFormatting.YELLOW);
        float legendaryRate = ((Integer)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_DROP_RATE.get()).intValue();
        float epicRate = ((Integer)MagicalJewelryConfigBuilder.JEWEL_EPIC_DROP_RATE.get()).intValue();
        float rareRate = ((Integer)MagicalJewelryConfigBuilder.JEWEL_RARE_DROP_RATE.get()).intValue();
        float uncommonRate = 100.0f - legendaryRate - epicRate - rareRate;
        if (!Arrays.asList(testLootTables).contains(lootTable)) {
            source.func_197021_a((ITextComponent)JewelCommands.translationTextComponent(jewelTestLoot, "failure", lootTable));
        }
        if (lootTable.equals(hostileLootDrop) || lootTable.equals(chestLootDrop) || lootTable.equals(chestHostileDrop) || lootTable.equals(allLootTables)) {
            if (lootTable.equals(hostileLootDrop)) {
                source.func_197030_a((ITextComponent)hostile, true);
                chestDropRatePercent = null;
            } else if (lootTable.equals(chestLootDrop)) {
                source.func_197030_a((ITextComponent)chest, true);
                hostileDropRatePercent = null;
                hostileDropRateLooting = null;
            } else {
                source.func_197030_a((ITextComponent)chestHostile, true);
                if (!((Boolean)MagicalJewelryConfigBuilder.JEWELS_IN_CHESTS.get()).booleanValue()) {
                    chestDropRatePercent = chestDisable;
                }
            }
            if (lootTable.equals(chestLootDrop) && !((Boolean)MagicalJewelryConfigBuilder.JEWELS_IN_CHESTS.get()).booleanValue()) {
                source.func_197030_a((ITextComponent)chestDisable, false);
            } else if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_ONE_RARITY_DROP.get()).booleanValue()) {
                JewelCommands.oneRarityDrop(source, hostileDropRatePercent, hostileDropRateLooting, chestDropRatePercent, oneRarityDrop);
            } else if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_UPGRADE_ONLY.get()).booleanValue()) {
                JewelCommands.legendaryUpgradeRarityDrop(source, hostileDropRatePercent, hostileDropRateLooting, chestDropRatePercent, legendaryUpgradeOnly, legendaryRate, epicRate, rareRate);
            } else {
                JewelCommands.defaultRarityDrop(source, hostileDropRatePercent, hostileDropRateLooting, chestDropRatePercent, bothConfigOptions, legendaryRate, epicRate, rareRate, uncommonRate);
            }
        }
        if (lootTable.equals(bossLootDrop) || lootTable.equals(allLootTables)) {
            source.func_197030_a((ITextComponent)boss, true);
            if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_ONE_RARITY_DROP.get()).booleanValue()) {
                JewelCommands.oneRarityDrop(source, bossDropRatePercent, bossDropRateLooting, null, oneRarityDrop);
            } else if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_UPGRADE_ONLY.get()).booleanValue()) {
                source.func_197030_a((ITextComponent)legendaryUpgradeOnly, false);
                if (bossDropRatePercent != null) {
                    source.func_197030_a((ITextComponent)bossDropRatePercent, false);
                }
                if (bossDropRateLooting != null) {
                    source.func_197030_a((ITextComponent)bossDropRateLooting, false);
                }
                source.func_197030_a((ITextComponent)JewelCommands.oneRarity(JewelRarity.EPIC), false);
            } else {
                source.func_197030_a((ITextComponent)bothConfigOptions, false);
                if (bossDropRatePercent != null) {
                    source.func_197030_a((ITextComponent)bossDropRatePercent, false);
                }
                if (bossDropRateLooting != null) {
                    source.func_197030_a((ITextComponent)bossDropRateLooting, false);
                }
                float totalDropRate = legendaryRate + epicRate;
                float legendaryDropRate = legendaryRate / totalDropRate * 100.0f;
                float epicDropRate = epicRate / totalDropRate * 100.0f;
                source.func_197030_a((ITextComponent)new StringTextComponent(JewelRarity.LEGENDARY.getDisplayName() + ": " + JewelCommands.floatToDeci(legendaryDropRate)).func_240699_a_(JewelRarity.LEGENDARY.getFormat()), false);
                source.func_197030_a((ITextComponent)new StringTextComponent(JewelRarity.EPIC.getDisplayName() + ": " + JewelCommands.floatToDeci(epicDropRate)).func_240699_a_(JewelRarity.EPIC.getFormat()), false);
            }
        }
        return 0;
    }

    private static void oneRarityDrop(CommandSource source, @Nullable IFormattableTextComponent dropRatePercent, @Nullable IFormattableTextComponent dropRateLooting, @Nullable IFormattableTextComponent chestDropRatePercent, IFormattableTextComponent oneRarityDrop) {
        source.func_197030_a((ITextComponent)oneRarityDrop, false);
        if (chestDropRatePercent != null) {
            source.func_197030_a((ITextComponent)chestDropRatePercent, false);
        }
        if (dropRatePercent != null) {
            source.func_197030_a((ITextComponent)dropRatePercent, false);
        }
        if (dropRateLooting != null) {
            source.func_197030_a((ITextComponent)dropRateLooting, false);
        }
        JewelRarity rarity = (JewelRarity)((Object)MagicalJewelryConfigBuilder.JEWEL_RARITY_TO_DROP.get());
        source.func_197030_a((ITextComponent)JewelCommands.oneRarity(rarity), false);
    }

    private static void legendaryUpgradeRarityDrop(CommandSource source, @Nullable IFormattableTextComponent dropRatePercent, @Nullable IFormattableTextComponent dropRateLooting, @Nullable IFormattableTextComponent chestDropRatePercent, IFormattableTextComponent legendaryUpgradeOnly, float legendaryRate, float epicRate, float rareRate) {
        float totalDropRate = 100.0f - legendaryRate;
        float epicDropRate = epicRate / totalDropRate * 100.0f;
        float rareDropRate = rareRate / totalDropRate * 100.0f;
        float uncommonDropRate = 100.0f - epicDropRate - rareDropRate;
        source.func_197030_a((ITextComponent)legendaryUpgradeOnly, false);
        if (chestDropRatePercent != null) {
            source.func_197030_a((ITextComponent)chestDropRatePercent, false);
        }
        if (dropRatePercent != null) {
            source.func_197030_a((ITextComponent)dropRatePercent, false);
        }
        if (dropRateLooting != null) {
            source.func_197030_a((ITextComponent)dropRateLooting, false);
        }
        source.func_197030_a((ITextComponent)new StringTextComponent(JewelRarity.EPIC.getDisplayName() + ": " + JewelCommands.floatToDeci(epicDropRate)).func_240699_a_(JewelRarity.EPIC.getFormat()), false);
        source.func_197030_a((ITextComponent)new StringTextComponent(JewelRarity.RARE.getDisplayName() + ": " + JewelCommands.floatToDeci(rareDropRate)).func_240699_a_(JewelRarity.RARE.getFormat()), false);
        source.func_197030_a((ITextComponent)new StringTextComponent(JewelRarity.UNCOMMON.getDisplayName() + ": " + JewelCommands.floatToDeci(uncommonDropRate)).func_240699_a_(JewelRarity.UNCOMMON.getFormat()), false);
    }

    private static void defaultRarityDrop(CommandSource source, @Nullable IFormattableTextComponent dropRatePercent, @Nullable IFormattableTextComponent dropRateLooting, @Nullable IFormattableTextComponent chestDropRatePercent, IFormattableTextComponent bothConfigOptions, float legendaryRate, float epicRate, float rareRate, float uncommonDropRate) {
        source.func_197030_a((ITextComponent)bothConfigOptions, false);
        if (chestDropRatePercent != null) {
            source.func_197030_a((ITextComponent)chestDropRatePercent, false);
        }
        if (dropRatePercent != null) {
            source.func_197030_a((ITextComponent)dropRatePercent, false);
        }
        if (dropRateLooting != null) {
            source.func_197030_a((ITextComponent)dropRateLooting, false);
        }
        source.func_197030_a((ITextComponent)new StringTextComponent(JewelRarity.LEGENDARY.getDisplayName() + ": " + JewelCommands.floatToDeci(legendaryRate)).func_240699_a_(JewelRarity.LEGENDARY.getFormat()), false);
        source.func_197030_a((ITextComponent)new StringTextComponent(JewelRarity.EPIC.getDisplayName() + ": " + JewelCommands.floatToDeci(epicRate)).func_240699_a_(JewelRarity.EPIC.getFormat()), false);
        source.func_197030_a((ITextComponent)new StringTextComponent(JewelRarity.RARE.getDisplayName() + ": " + JewelCommands.floatToDeci(rareRate)).func_240699_a_(JewelRarity.RARE.getFormat()), false);
        source.func_197030_a((ITextComponent)new StringTextComponent(JewelRarity.UNCOMMON.getDisplayName() + ": " + JewelCommands.floatToDeci(uncommonDropRate)).func_240699_a_(JewelRarity.UNCOMMON.getFormat()), false);
    }

    private static String dropRateWithLootingPercent(float dropRate, float lootingMultiplier) {
        if (dropRate <= 0.0f && lootingMultiplier <= 0.0f) {
            return "0,0F";
        }
        if (dropRate < 1.0E-4f && dropRate != 0.0f && lootingMultiplier < 1.0E-4f && lootingMultiplier != 0.0f) {
            return "<0,01%";
        }
        if (dropRate < 1.0E-4f && dropRate != 0.0f) {
            return "~" + String.format("%.2f", Float.valueOf(3.0f * lootingMultiplier * 100.0f)) + "%";
        }
        if (lootingMultiplier < 1.0E-4f && lootingMultiplier != 0.0f) {
            return "~" + String.format("%.2f", Float.valueOf(dropRate * 100.0f)) + "%";
        }
        if ((dropRate + 3.0f * lootingMultiplier) * 100.0f >= 100.0f) {
            return "100,00%";
        }
        return String.format("%.2f", Float.valueOf((dropRate + 3.0f * lootingMultiplier) * 100.0f)) + "%";
    }

    private static String floatToDeci(float dropRate) {
        if (dropRate <= 0.0f) {
            return "0,00%";
        }
        if (dropRate < 0.01f) {
            return "<0,01%";
        }
        if (dropRate > 100.0f) {
            return "100,00%";
        }
        return String.format("%.2f", Float.valueOf(dropRate)) + "%";
    }

    private static IFormattableTextComponent oneRarity(JewelRarity rarityIn) {
        return JewelCommands.translationTextComponent(jewelTestLoot, "onerarity", rarityIn.getDisplayName()).func_240699_a_(rarityIn.getFormat());
    }

    private static TranslationTextComponent translationTextComponent(String[] strings, String stringIn) {
        return JewelCommands.translationTextComponent(strings, stringIn, null);
    }

    private static TranslationTextComponent translationTextComponent(String[] strings, String string1In, String string2In) {
        return JewelCommands.translationTextComponent(strings, string1In, string2In, null);
    }

    private static TranslationTextComponent translationTextComponent(String[] strings, String string1In, String string2In, String string3In) {
        return JewelCommands.translationTextComponent(strings[0], strings[1], string1In, string2In, string3In);
    }

    private static TranslationTextComponent translationTextComponent(String type, String nameIn) {
        return JewelCommands.translationTextComponent(type, nameIn, null);
    }

    private static TranslationTextComponent translationTextComponent(String type, String nameIn, String stringIn) {
        return JewelCommands.translationTextComponent(type, nameIn, stringIn, null, null);
    }

    private static TranslationTextComponent translationTextComponent(String type, String nameIn, @Nullable String string1In, @Nullable String string2In, @Nullable String string3In) {
        return new TranslationTextComponent("commands.magicaljewelry." + type + "." + nameIn, new Object[]{string1In, string2In, string3In});
    }
}

