/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.data.client;

import com.erfurt.magicaljewelry.init.ItemInit;
import com.erfurt.magicaljewelry.util.enums.JewelRarity;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.common.data.LanguageProvider;

public class ModLangProvider
extends LanguageProvider {
    public ModLangProvider(DataGenerator gen) {
        super(gen, "magicaljewelry", "en_us");
    }

    protected void addTranslations() {
        this.addItem((Supplier)ItemInit.GOLD_AMULET, "Gold Amulet");
        this.addItem((Supplier)ItemInit.SILVER_AMULET, "Silver Amulet");
        this.addItem((Supplier)ItemInit.GOLD_RING, "Gold Ring");
        this.addItem((Supplier)ItemInit.SILVER_RING, "Silver Ring");
        this.addItem((Supplier)ItemInit.GOLD_BRACELET, "Gold Bracelet");
        this.addItem((Supplier)ItemInit.SILVER_BRACELET, "Silver Bracelet");
        this.addItem((Supplier)ItemInit.THE_ONE_RING, "The One Ring");
        this.add("item.magicaljewelry.tooltip.creative", "This item have no effects or attributes attached to it, and therefore does nothing! This item can't be upgraded!");
        this.add(this.rarity(JewelRarity.UNCOMMON), "Uncommon");
        this.add(this.rarity(JewelRarity.RARE), "Rare");
        this.add(this.rarity(JewelRarity.EPIC), "Epic");
        this.add(this.rarity(JewelRarity.LEGENDARY), "Legendary");
        this.add(this.jewelGiveFailureCommand("exist"), "Item '%s' does not exist?");
        this.add(this.jewelGiveFailureCommand("item"), "Item '%s' is not valid!");
        this.add(this.jewelGiveFailureCommand("rarity"), "Rarity '%s' is not valid!");
        this.add(this.jewelTestLootCommand("settings"), "Rarity Drop Setting for %s");
        this.add(this.jewelTestLootCommand("type.hostile"), "Hostile mobs");
        this.add(this.jewelTestLootCommand("type.boss"), "Boss mobs");
        this.add(this.jewelTestLootCommand("type.chest"), "Chests");
        this.add(this.jewelTestLootCommand("droprate"), "Default drop rate: %s");
        this.add(this.jewelTestLootCommand("dropratewith"), "Default drop rate with %s: %s");
        this.add(this.jewelTestLootCommand("onerarity"), "The only rarity that can drop is: %s");
        this.add(this.jewelTestLootCommand("config1"), "Config option %s is set to %s");
        this.add(this.jewelTestLootCommand("config2"), "Config option %s and %s are both set to %s");
        this.add(this.jewelTestLootCommand("failure"), "Loot Table '%s' is not valid for testing!");
        this.add("itemGroup.magicaljewelryGroup", "Magical Jewelry");
    }

    private String rarity(JewelRarity rarity) {
        return "rarity.magicaljewelry." + rarity.getName();
    }

    private String jewelGiveFailureCommand(String type) {
        return "commands.magicaljewelry.jewelGive.failure." + type;
    }

    private String jewelTestLootCommand(String type) {
        return "commands.magicaljewelry.jewelTestLoot." + type;
    }
}

