/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class JewelModifier
extends LootModifier {
    private final ResourceLocation lootTable;
    boolean doubleEntryPrevention = false;

    public JewelModifier(ILootCondition[] lootConditions, ResourceLocation lootTable) {
        super(lootConditions);
        this.lootTable = lootTable;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.doubleEntryPrevention) {
            return generatedLoot;
        }
        this.doubleEntryPrevention = true;
        LootTable lootTable = context.func_227502_a_(this.lootTable);
        List loot = lootTable.func_216113_a(context);
        generatedLoot.addAll(loot);
        this.doubleEntryPrevention = false;
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<JewelModifier> {
        String add_loot_table = "add_loot_table";

        public JewelModifier read(ResourceLocation location, JsonObject object, ILootCondition[] iLootCondition) {
            ResourceLocation lootTable = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)this.add_loot_table));
            return new JewelModifier(iLootCondition, lootTable);
        }

        public JsonObject write(JewelModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty(this.add_loot_table, instance.lootTable.toString());
            return json;
        }
    }
}

