/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.command;

import com.erfurt.magicaljewelry.MagicalJewelry;
import com.erfurt.magicaljewelry.data.loot.loottable.ModChestLootTablesBuilder;
import com.erfurt.magicaljewelry.data.loot.loottable.ModEntityLootTablesBuilder;
import com.erfurt.magicaljewelry.objects.items.JewelItem;
import com.erfurt.magicaljewelry.util.LootTableUtil;
import com.erfurt.magicaljewelry.util.config.MagicalJewelryConfigBuilder;
import com.erfurt.magicaljewelry.util.enums.JewelRarity;
import com.erfurt.magicaljewelry.util.interfaces.IJewelNBTHandler;
import com.erfurt.magicaljewelry.util.interfaces.IJewelRarity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public final class JewelCommands
implements IJewelNBTHandler {
    private static final String jewelTestLoot = "jewelTestLoot";
    private static final String jewelGive = "jewelGive";
    private static final String targets = "targets";
    private static final String itemId = "itemId";
    private static final String rarityId = "rarity";
    private static final String randomRarity = "random";
    private static final String lootTableSettings = "lootTable";
    private static final String hostileLootDrop = ModEntityLootTablesBuilder.hostileLootTable;
    private static final String bossLootDrop = ModEntityLootTablesBuilder.bossLootTable;
    private static final String chestLootDrop = ModChestLootTablesBuilder.chestLootTable;
    private static final String allLootTables = "all_jewel_drops";
    private static final String chestHostileDrop = "chests_hostile_jewel_drops";
    private static final String[] rarities = new String[]{"random", JewelRarity.UNCOMMON.getName(), JewelRarity.RARE.getName(), JewelRarity.EPIC.getName(), JewelRarity.LEGENDARY.getName()};
    private static final String[] testLootTables = new String[]{hostileLootDrop, bossLootDrop, chestLootDrop, "chests_hostile_jewel_drops", "all_jewel_drops"};
    private static final SuggestionProvider<CommandSourceStack> itemIdSuggestions = (context, builder) -> SharedSuggestionProvider.m_82957_(ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof JewelItem).map(ForgeRegistryEntry::getRegistryName), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> raritySuggestions = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])rarities, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> testLootSuggestions = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])testLootTables, (SuggestionsBuilder)builder);

    private JewelCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builderJewelGive = (LiteralArgumentBuilder)Commands.m_82127_((String)jewelGive).requires(source -> source.m_6761_(2));
        LiteralArgumentBuilder builderTestLoot = Commands.m_82127_((String)jewelTestLoot);
        builderJewelGive.then(Commands.m_82129_((String)targets, (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)itemId, (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(itemIdSuggestions).executes(context -> JewelCommands.giveJewel((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)itemId), EntityArgument.m_91477_((CommandContext)context, (String)targets), randomRarity))).then(Commands.m_82129_((String)rarityId, (ArgumentType)StringArgumentType.string()).suggests(raritySuggestions).executes(context -> JewelCommands.giveJewel((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)itemId), EntityArgument.m_91477_((CommandContext)context, (String)targets), StringArgumentType.getString((CommandContext)context, (String)rarityId).toLowerCase(Locale.ROOT))))));
        ((LiteralArgumentBuilder)builderTestLoot.executes(context -> JewelCommands.testLoot((CommandSourceStack)context.getSource(), allLootTables))).then(Commands.m_82129_((String)lootTableSettings, (ArgumentType)StringArgumentType.string()).suggests(testLootSuggestions).executes(context -> JewelCommands.testLoot((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)lootTableSettings))));
        dispatcher.register(builderJewelGive);
        dispatcher.register(builderTestLoot);
    }

    private static int giveJewel(CommandSourceStack source, ResourceLocation itemId, Collection<ServerPlayer> targets, String rarity) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        if (item == null) {
            source.m_81352_((Component)JewelCommands.TranslatableComponent(jewelGive, "failure.exist", itemId.toString()));
            return 0;
        }
        if (!(item instanceof JewelItem)) {
            source.m_81352_((Component)JewelCommands.TranslatableComponent(jewelGive, "failure.item", itemId.toString()));
            return 0;
        }
        ItemStack stack = new ItemStack((ItemLike)item, 1);
        for (ServerPlayer player : targets) {
            ItemEntity entityItem;
            if (rarity.equals(randomRarity)) {
                rarity = IJewelRarity.getRarityCommand();
            } else if (!JewelRarity.containsRarity(rarity)) {
                source.m_81352_((Component)JewelCommands.TranslatableComponent(jewelGive, "failure.rarity", rarity));
                return 0;
            }
            IJewelNBTHandler.setJewelNBTData(stack, rarity);
            boolean addedToInventory = player.m_150109_().m_36054_(stack);
            if (addedToInventory && stack.m_41619_()) {
                stack.m_41764_(1);
                entityItem = player.m_36176_(stack, false);
                if (entityItem != null) {
                    entityItem.m_32065_();
                }
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_21187_().nextFloat() - player.m_21187_().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.f_36096_.m_38946_();
                continue;
            }
            entityItem = player.m_36176_(stack, false);
            if (entityItem == null) continue;
            entityItem.m_32061_();
            entityItem.m_32047_(player.m_142081_());
        }
        MutableComponent itemText = stack.m_41611_().m_6881_().m_130940_(JewelRarity.byName(rarity).getFormat());
        if (targets.size() == 1) {
            source.m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, itemText, targets.iterator().next().m_5446_()}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, itemText, targets.size()}), true);
        }
        return targets.size();
    }

    private static int testLoot(CommandSourceStack source, String lootTable) {
        MinecraftServer server = source.m_81377_();
        String[] settings = new String[]{jewelTestLoot, "settings"};
        String[] droprate = new String[]{jewelTestLoot, "droprate"};
        String[] dropratewith = new String[]{jewelTestLoot, "dropratewith"};
        String[] config1 = new String[]{jewelTestLoot, "config1"};
        String[] config2 = new String[]{jewelTestLoot, "config2"};
        String looting = Enchantments.f_44982_.m_44700_(3).getString();
        TranslatableComponent typeHostile = JewelCommands.TranslatableComponent(jewelTestLoot, "type.hostile");
        TranslatableComponent typeBoss = JewelCommands.TranslatableComponent(jewelTestLoot, "type.boss");
        TranslatableComponent typeChest = JewelCommands.TranslatableComponent(jewelTestLoot, "type.chest");
        TranslatableComponent hostile = JewelCommands.TranslatableComponent(settings, typeHostile.getString());
        TranslatableComponent chest = JewelCommands.TranslatableComponent(settings, typeChest.getString());
        TranslatableComponent boss = JewelCommands.TranslatableComponent(settings, typeBoss.getString());
        TranslatableComponent chestHostile = JewelCommands.TranslatableComponent(settings, typeChest.getString() + " & " + typeHostile.getString());
        float hostileDropRate = LootTableUtil.getChance(MagicalJewelry.getId("entities/" + hostileLootDrop), server);
        float hostileLootingMultiplier = LootTableUtil.getLootingMultiplier(MagicalJewelry.getId("entities/" + hostileLootDrop), server);
        float bossDropRate = LootTableUtil.getChance(MagicalJewelry.getId("entities/" + bossLootDrop), server);
        float bossLootingMultiplier = LootTableUtil.getLootingMultiplier(MagicalJewelry.getId("entities/" + bossLootDrop), server);
        float chestDropRate = LootTableUtil.getChance(MagicalJewelry.getId("inject/chests/" + chestLootDrop), server);
        MutableComponent hostileDropRatePercent = null;
        MutableComponent hostileDropRateLooting = null;
        MutableComponent bossDropRatePercent = null;
        MutableComponent bossDropRateLooting = null;
        MutableComponent chestDropRatePercent = null;
        if (hostileLootingMultiplier >= 0.0f && hostileDropRate >= 0.0f) {
            hostileDropRatePercent = new TextComponent(typeHostile.getString() + " - ").m_7220_((Component)JewelCommands.TranslatableComponent(droprate, JewelCommands.floatToDeci(hostileDropRate * 100.0f))).m_130940_(ChatFormatting.GREEN);
            hostileDropRateLooting = new TextComponent(typeHostile.getString() + " - ").m_7220_((Component)JewelCommands.TranslatableComponent(dropratewith, looting, JewelCommands.dropRateWithLootingPercent(hostileDropRate, hostileLootingMultiplier))).m_130940_(ChatFormatting.GREEN);
        } else if (hostileDropRate >= 0.0f) {
            hostileDropRatePercent = new TextComponent(typeHostile.getString() + " - ").m_7220_((Component)JewelCommands.TranslatableComponent(droprate, JewelCommands.floatToDeci(hostileDropRate * 100.0f))).m_130940_(ChatFormatting.GREEN);
        }
        if (bossLootingMultiplier >= 0.0f && bossDropRate >= 0.0f) {
            bossDropRatePercent = new TextComponent(typeBoss.getString() + " - ").m_7220_((Component)JewelCommands.TranslatableComponent(droprate, JewelCommands.floatToDeci(bossDropRate * 100.0f))).m_130940_(ChatFormatting.GREEN);
            bossDropRateLooting = new TextComponent(typeBoss.getString() + " - ").m_7220_((Component)JewelCommands.TranslatableComponent(dropratewith, looting, JewelCommands.dropRateWithLootingPercent(bossDropRate, bossLootingMultiplier))).m_130940_(ChatFormatting.GREEN);
        } else if (bossDropRate >= 0.0f) {
            bossDropRatePercent = new TextComponent(typeBoss.getString() + " - ").m_7220_((Component)JewelCommands.TranslatableComponent(droprate, JewelCommands.floatToDeci(bossDropRate * 100.0f))).m_130940_(ChatFormatting.GREEN);
        }
        if (chestDropRate >= 0.0f) {
            chestDropRatePercent = new TextComponent(typeChest.getString() + " - ").m_7220_((Component)JewelCommands.TranslatableComponent(droprate, JewelCommands.floatToDeci(chestDropRate * 100.0f))).m_130940_(ChatFormatting.GREEN);
        }
        MutableComponent oneRarityDrop = JewelCommands.TranslatableComponent(config1, "'oneRarityDrop'", "true").m_130940_(ChatFormatting.YELLOW);
        MutableComponent legendaryUpgradeOnly = JewelCommands.TranslatableComponent(config1, "'legendaryUpgradeOnly'", "true").m_130940_(ChatFormatting.YELLOW);
        MutableComponent bothConfigOptions = JewelCommands.TranslatableComponent(config2, "'legendaryUpgradeOnly'", "'oneRarityDrop'", "false").m_130940_(ChatFormatting.YELLOW);
        MutableComponent chestDisable = JewelCommands.TranslatableComponent(config1, "'jewelsInChest'", "false").m_130940_(ChatFormatting.YELLOW);
        float legendaryRate = ((Integer)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_DROP_RATE.get()).intValue();
        float epicRate = ((Integer)MagicalJewelryConfigBuilder.JEWEL_EPIC_DROP_RATE.get()).intValue();
        float rareRate = ((Integer)MagicalJewelryConfigBuilder.JEWEL_RARE_DROP_RATE.get()).intValue();
        float uncommonRate = 100.0f - legendaryRate - epicRate - rareRate;
        if (!Arrays.asList(testLootTables).contains(lootTable)) {
            source.m_81352_((Component)JewelCommands.TranslatableComponent(jewelTestLoot, "failure", lootTable));
        }
        if (lootTable.equals(hostileLootDrop) || lootTable.equals(chestLootDrop) || lootTable.equals(chestHostileDrop) || lootTable.equals(allLootTables)) {
            if (lootTable.equals(hostileLootDrop)) {
                source.m_81354_((Component)hostile, true);
                chestDropRatePercent = null;
            } else if (lootTable.equals(chestLootDrop)) {
                source.m_81354_((Component)chest, true);
                hostileDropRatePercent = null;
                hostileDropRateLooting = null;
            } else {
                source.m_81354_((Component)chestHostile, true);
                if (!((Boolean)MagicalJewelryConfigBuilder.JEWELS_IN_CHESTS.get()).booleanValue()) {
                    chestDropRatePercent = chestDisable;
                }
            }
            if (lootTable.equals(chestLootDrop) && !((Boolean)MagicalJewelryConfigBuilder.JEWELS_IN_CHESTS.get()).booleanValue()) {
                source.m_81354_((Component)chestDisable, false);
            } else if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_ONE_RARITY_DROP.get()).booleanValue()) {
                JewelCommands.oneRarityDrop(source, hostileDropRatePercent, hostileDropRateLooting, chestDropRatePercent, oneRarityDrop);
            } else if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_UPGRADE_ONLY.get()).booleanValue()) {
                JewelCommands.legendaryUpgradeRarityDrop(source, hostileDropRatePercent, hostileDropRateLooting, chestDropRatePercent, legendaryUpgradeOnly, legendaryRate, epicRate, rareRate);
            } else {
                JewelCommands.defaultRarityDrop(source, hostileDropRatePercent, hostileDropRateLooting, chestDropRatePercent, bothConfigOptions, legendaryRate, epicRate, rareRate, uncommonRate);
            }
        }
        if (lootTable.equals(bossLootDrop) || lootTable.equals(allLootTables)) {
            source.m_81354_((Component)boss, true);
            if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_ONE_RARITY_DROP.get()).booleanValue()) {
                JewelCommands.oneRarityDrop(source, bossDropRatePercent, bossDropRateLooting, null, oneRarityDrop);
            } else if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_UPGRADE_ONLY.get()).booleanValue()) {
                source.m_81354_((Component)legendaryUpgradeOnly, false);
                if (bossDropRatePercent != null) {
                    source.m_81354_((Component)bossDropRatePercent, false);
                }
                if (bossDropRateLooting != null) {
                    source.m_81354_((Component)bossDropRateLooting, false);
                }
                source.m_81354_((Component)JewelCommands.oneRarity(JewelRarity.EPIC), false);
            } else {
                source.m_81354_((Component)bothConfigOptions, false);
                if (bossDropRatePercent != null) {
                    source.m_81354_((Component)bossDropRatePercent, false);
                }
                if (bossDropRateLooting != null) {
                    source.m_81354_((Component)bossDropRateLooting, false);
                }
                float totalDropRate = legendaryRate + epicRate;
                float legendaryDropRate = legendaryRate / totalDropRate * 100.0f;
                float epicDropRate = epicRate / totalDropRate * 100.0f;
                source.m_81354_((Component)new TextComponent(JewelRarity.LEGENDARY.getDisplayName() + ": " + JewelCommands.floatToDeci(legendaryDropRate)).m_130940_(JewelRarity.LEGENDARY.getFormat()), false);
                source.m_81354_((Component)new TextComponent(JewelRarity.EPIC.getDisplayName() + ": " + JewelCommands.floatToDeci(epicDropRate)).m_130940_(JewelRarity.EPIC.getFormat()), false);
            }
        }
        return 0;
    }

    private static void oneRarityDrop(CommandSourceStack source, @Nullable MutableComponent dropRatePercent, @Nullable MutableComponent dropRateLooting, @Nullable MutableComponent chestDropRatePercent, MutableComponent oneRarityDrop) {
        source.m_81354_((Component)oneRarityDrop, false);
        if (chestDropRatePercent != null) {
            source.m_81354_((Component)chestDropRatePercent, false);
        }
        if (dropRatePercent != null) {
            source.m_81354_((Component)dropRatePercent, false);
        }
        if (dropRateLooting != null) {
            source.m_81354_((Component)dropRateLooting, false);
        }
        JewelRarity rarity = (JewelRarity)((Object)MagicalJewelryConfigBuilder.JEWEL_RARITY_TO_DROP.get());
        source.m_81354_((Component)JewelCommands.oneRarity(rarity), false);
    }

    private static void legendaryUpgradeRarityDrop(CommandSourceStack source, @Nullable MutableComponent dropRatePercent, @Nullable MutableComponent dropRateLooting, @Nullable MutableComponent chestDropRatePercent, MutableComponent legendaryUpgradeOnly, float legendaryRate, float epicRate, float rareRate) {
        float totalDropRate = 100.0f - legendaryRate;
        float epicDropRate = epicRate / totalDropRate * 100.0f;
        float rareDropRate = rareRate / totalDropRate * 100.0f;
        float uncommonDropRate = 100.0f - epicDropRate - rareDropRate;
        source.m_81354_((Component)legendaryUpgradeOnly, false);
        if (chestDropRatePercent != null) {
            source.m_81354_((Component)chestDropRatePercent, false);
        }
        if (dropRatePercent != null) {
            source.m_81354_((Component)dropRatePercent, false);
        }
        if (dropRateLooting != null) {
            source.m_81354_((Component)dropRateLooting, false);
        }
        source.m_81354_((Component)new TextComponent(JewelRarity.EPIC.getDisplayName() + ": " + JewelCommands.floatToDeci(epicDropRate)).m_130940_(JewelRarity.EPIC.getFormat()), false);
        source.m_81354_((Component)new TextComponent(JewelRarity.RARE.getDisplayName() + ": " + JewelCommands.floatToDeci(rareDropRate)).m_130940_(JewelRarity.RARE.getFormat()), false);
        source.m_81354_((Component)new TextComponent(JewelRarity.UNCOMMON.getDisplayName() + ": " + JewelCommands.floatToDeci(uncommonDropRate)).m_130940_(JewelRarity.UNCOMMON.getFormat()), false);
    }

    private static void defaultRarityDrop(CommandSourceStack source, @Nullable MutableComponent dropRatePercent, @Nullable MutableComponent dropRateLooting, @Nullable MutableComponent chestDropRatePercent, MutableComponent bothConfigOptions, float legendaryRate, float epicRate, float rareRate, float uncommonDropRate) {
        source.m_81354_((Component)bothConfigOptions, false);
        if (chestDropRatePercent != null) {
            source.m_81354_((Component)chestDropRatePercent, false);
        }
        if (dropRatePercent != null) {
            source.m_81354_((Component)dropRatePercent, false);
        }
        if (dropRateLooting != null) {
            source.m_81354_((Component)dropRateLooting, false);
        }
        source.m_81354_((Component)new TextComponent(JewelRarity.LEGENDARY.getDisplayName() + ": " + JewelCommands.floatToDeci(legendaryRate)).m_130940_(JewelRarity.LEGENDARY.getFormat()), false);
        source.m_81354_((Component)new TextComponent(JewelRarity.EPIC.getDisplayName() + ": " + JewelCommands.floatToDeci(epicRate)).m_130940_(JewelRarity.EPIC.getFormat()), false);
        source.m_81354_((Component)new TextComponent(JewelRarity.RARE.getDisplayName() + ": " + JewelCommands.floatToDeci(rareRate)).m_130940_(JewelRarity.RARE.getFormat()), false);
        source.m_81354_((Component)new TextComponent(JewelRarity.UNCOMMON.getDisplayName() + ": " + JewelCommands.floatToDeci(uncommonDropRate)).m_130940_(JewelRarity.UNCOMMON.getFormat()), false);
    }

    private static String dropRateWithLootingPercent(float dropRate, float lootingMultiplier) {
        if (dropRate <= 0.0f && lootingMultiplier <= 0.0f) {
            return "0,0F";
        }
        if (dropRate < 1.0E-4f && dropRate != 0.0f && lootingMultiplier < 1.0E-4f && lootingMultiplier != 0.0f) {
            return "<0,01%";
        }
        if (dropRate < 1.0E-4f && dropRate != 0.0f) {
            return "~" + String.format("%.2f", Float.valueOf(3.0f * lootingMultiplier * 100.0f)) + "%";
        }
        if (lootingMultiplier < 1.0E-4f && lootingMultiplier != 0.0f) {
            return "~" + String.format("%.2f", Float.valueOf(dropRate * 100.0f)) + "%";
        }
        if ((dropRate + 3.0f * lootingMultiplier) * 100.0f >= 100.0f) {
            return "100,00%";
        }
        return String.format("%.2f", Float.valueOf((dropRate + 3.0f * lootingMultiplier) * 100.0f)) + "%";
    }

    private static String floatToDeci(float dropRate) {
        if (dropRate <= 0.0f) {
            return "0,00%";
        }
        if (dropRate < 0.01f) {
            return "<0,01%";
        }
        if (dropRate > 100.0f) {
            return "100,00%";
        }
        return String.format("%.2f", Float.valueOf(dropRate)) + "%";
    }

    private static MutableComponent oneRarity(JewelRarity rarityIn) {
        return JewelCommands.TranslatableComponent(jewelTestLoot, "onerarity", rarityIn.getDisplayName()).m_130940_(rarityIn.getFormat());
    }

    private static TranslatableComponent TranslatableComponent(String[] strings, String stringIn) {
        return JewelCommands.TranslatableComponent(strings, stringIn, null);
    }

    private static TranslatableComponent TranslatableComponent(String[] strings, String string1In, String string2In) {
        return JewelCommands.TranslatableComponent(strings, string1In, string2In, null);
    }

    private static TranslatableComponent TranslatableComponent(String[] strings, String string1In, String string2In, String string3In) {
        return JewelCommands.TranslatableComponent(strings[0], strings[1], string1In, string2In, string3In);
    }

    private static TranslatableComponent TranslatableComponent(String type, String nameIn) {
        return JewelCommands.TranslatableComponent(type, nameIn, null);
    }

    private static TranslatableComponent TranslatableComponent(String type, String nameIn, String stringIn) {
        return JewelCommands.TranslatableComponent(type, nameIn, stringIn, null, null);
    }

    private static TranslatableComponent TranslatableComponent(String type, String nameIn, @Nullable String string1In, @Nullable String string2In, @Nullable String string3In) {
        return new TranslatableComponent("commands.magicaljewelry." + type + "." + nameIn, new Object[]{string1In, string2In, string3In});
    }
}

