/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.data.recipes;

import com.erfurt.magicaljewelry.MagicalJewelry;
import com.erfurt.magicaljewelry.recipes.JewelUpgradeRecipe;
import com.erfurt.magicaljewelry.recipes.UpgradeNBTIngredient;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class JewelUpgradeRecipeBuilder {
    private final Item addition;
    private final Item jewel;
    private final String rarityIn;
    private final String rarityOut;
    private final RecipeSerializer<?> serializer;

    public JewelUpgradeRecipeBuilder(RecipeSerializer<?> serializer, Item addition, Item jewel, String rarityIn, String rarityOut) {
        this.serializer = serializer;
        this.addition = addition;
        this.jewel = jewel;
        this.rarityIn = rarityIn;
        this.rarityOut = rarityOut;
    }

    public static JewelUpgradeRecipeBuilder jewelUpgradeRecipe(Item jewel, Item addition, String rarityIn, String rarityOut) {
        return new JewelUpgradeRecipeBuilder(JewelUpgradeRecipe.Serializer.SERIALIZER, addition, jewel, rarityIn, rarityOut);
    }

    public void build(Consumer<FinishedRecipe> consumer, String id) {
        this.build(consumer, MagicalJewelry.getId(id + "_upgrade_" + this.rarityIn + "_to_" + this.rarityOut));
    }

    public void build(Consumer<FinishedRecipe> recipe, ResourceLocation id) {
        recipe.accept(new Result(id, this.serializer, this.addition, this.jewel, this.rarityIn, this.rarityOut));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient addition;
        private final Item jewel;
        private final String rarityIn;
        private final String rarityOut;
        private final RecipeSerializer<?> serializer;

        public Result(ResourceLocation id, RecipeSerializer<?> serializer, Item addition, Item jewel, String rarityIn, String rarityOut) {
            this.id = id;
            this.serializer = serializer;
            this.addition = Ingredient.m_43929_((ItemLike[])new ItemLike[]{addition});
            this.jewel = jewel;
            this.rarityIn = rarityIn;
            this.rarityOut = rarityOut;
        }

        public void m_7917_(JsonObject json) {
            JsonObject jsonBase = new JsonObject();
            jsonBase.addProperty("type", CraftingHelper.getID((IIngredientSerializer)UpgradeNBTIngredient.Serializer.INSTANCE).toString());
            jsonBase.addProperty("item", this.jewel.getRegistryName().toString());
            JsonObject jsonNBTin = new JsonObject();
            jsonNBTin.addProperty("Rarity", this.rarityIn);
            jsonBase.add("nbt", (JsonElement)jsonNBTin);
            json.add("base", (JsonElement)jsonBase);
            json.add("addition", this.addition.m_43942_());
            JsonObject jsonResult = new JsonObject();
            jsonResult.addProperty("item", this.jewel.getRegistryName().toString());
            JsonObject jsonNBTout = new JsonObject();
            jsonNBTout.addProperty("Rarity", this.rarityOut);
            jsonResult.add("nbt", (JsonElement)jsonNBTout);
            json.add("result", (JsonElement)jsonResult);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

