/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class JewelModifier
extends LootModifier {
    private final ResourceLocation lootTable;
    boolean doubleEntryPrevention = false;

    public JewelModifier(LootItemCondition[] lootConditions, ResourceLocation lootTable) {
        super(lootConditions);
        this.lootTable = lootTable;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.doubleEntryPrevention) {
            return generatedLoot;
        }
        this.doubleEntryPrevention = true;
        LootTable lootTable = context.m_78940_(this.lootTable);
        List loot = lootTable.m_79129_(context);
        generatedLoot.addAll(loot);
        this.doubleEntryPrevention = false;
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<JewelModifier> {
        String add_loot_table = "add_loot_table";

        public JewelModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] iLootCondition) {
            ResourceLocation lootTable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)this.add_loot_table));
            return new JewelModifier(iLootCondition, lootTable);
        }

        public JsonObject write(JewelModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty(this.add_loot_table, instance.lootTable.toString());
            return json;
        }
    }
}

