/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.objects.items;

import com.erfurt.magicaljewelry.MagicalJewelry;
import com.erfurt.magicaljewelry.capability.JewelItemCapability;
import com.erfurt.magicaljewelry.objects.items.JewelAmuletItem;
import com.erfurt.magicaljewelry.util.config.MagicalJewelryConfigBuilder;
import com.erfurt.magicaljewelry.util.enums.JewelRarity;
import com.erfurt.magicaljewelry.util.interfaces.IJewel;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class JewelItem
extends Item
implements IJewel {
    public static final String NBT_RARITY = "Rarity";
    public static final String NBT_EFFECTS = "Effects";
    public static final String NBT_LEGENDARY_EFFECT = "LegendaryEffect";
    public static final String NBT_ATTRIBUTES = "Attributes";
    public static final String NBT_UUID = "UUID";
    public static final String NBT_COLOR = "GemColor";
    public static List<Integer> jewelEffects = new ArrayList<Integer>();
    public static Map<LivingEntity, Map<MobEffect, Integer>> totalJewelEffectsPlayer = new LinkedHashMap<LivingEntity, Map<MobEffect, Integer>>();
    public static Multimap<Attribute, AttributeModifier> jewelAttributesForRemoval = HashMultimap.create();

    public JewelItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(MagicalJewelry.GROUP));
    }

    public int getMaxDamage(ItemStack stack) {
        String rarity = JewelItem.getJewelRarity(stack);
        int durability = rarity.equals(JewelRarity.UNCOMMON.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_UNCOMMON_DURABILITY.get() : (rarity.equals(JewelRarity.RARE.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_RARE_DURABILITY.get() : (rarity.equals(JewelRarity.EPIC.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_EPIC_DURABILITY.get() : 0));
        return durability;
    }

    public boolean isDamageable(ItemStack stack) {
        return (Boolean)MagicalJewelryConfigBuilder.JEWEL_DURABILITY.get() != false && JewelRarity.containsRarity(JewelItem.getJewelRarity(stack)) && !JewelItem.getJewelRarity(stack).equals(JewelRarity.LEGENDARY.getName());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return JewelItemCapability.createProvider(new ICurio(){

            public void curioTick(SlotContext slotContext) {
                LivingEntity livingEntity = slotContext.entity();
                if (!livingEntity.m_20193_().f_46443_ && stack.m_41720_() instanceof JewelItem) {
                    if (livingEntity.f_19797_ % 19 == 0) {
                        stack.m_41622_(1, livingEntity, livingEntity1 -> {});
                    }
                    if (livingEntity.f_19797_ % 199 == 0 && totalJewelEffectsPlayer.containsKey(livingEntity) && !totalJewelEffectsPlayer.get(livingEntity).isEmpty()) {
                        JewelItem.this.updateJewelEffects(stack, livingEntity, false);
                        if (!((Boolean)MagicalJewelryConfigBuilder.JEWEL_ATTRIBUTES.get()).booleanValue()) {
                            livingEntity.m_21204_().m_22161_(jewelAttributesForRemoval);
                        }
                    }
                }
            }

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (stack.m_41720_() instanceof JewelItem) {
                    JewelItem.this.getTotalJewelEffects(stack, livingEntity);
                    JewelItem.this.updateJewelEffects(stack, livingEntity, false);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (stack.m_41720_() instanceof JewelItem) {
                    JewelItem.this.updateJewelEffects(stack, livingEntity, true);
                }
            }

            public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid) {
                HashMultimap attributes = HashMultimap.create();
                if (stack.m_41720_() instanceof JewelItem && stack.m_41783_().m_128441_(JewelItem.NBT_ATTRIBUTES) && stack.m_41783_().m_128441_(JewelItem.NBT_UUID)) {
                    JewelItem.this.updateJewelAttributes(stack, (Multimap<Attribute, AttributeModifier>)attributes);
                }
                return attributes;
            }

            public boolean canEquipFromUse(SlotContext slotContext) {
                return true;
            }
        });
    }

    public void updateJewelEffects(ItemStack stack, LivingEntity player, boolean removeEffects) {
        block10: {
            block9: {
                if (!removeEffects) break block9;
                if (this.legendaryEffectsEnabled(stack)) {
                    int j = JewelItem.getJewelLegendaryEffect(stack);
                    MobEffect effect = (MobEffect)legendaryEffectsList.toArray()[j];
                    this.updateJewelEffects(player, effect);
                }
                for (int i = 0; i < this.effectsLength(stack); ++i) {
                    int j = JewelItem.getJewelEffects(stack)[i];
                    MobEffect effect = (MobEffect)defaultEffectsList.toArray()[j];
                    this.updateJewelEffects(player, effect);
                }
                break block10;
            }
            String rarity = JewelItem.getJewelRarity(stack);
            if (!JewelRarity.containsRarity(rarity)) break block10;
            for (int i = 0; i < totalJewelEffectsPlayer.get(player).size(); ++i) {
                MobEffect effect = (MobEffect)totalJewelEffectsPlayer.get(player).keySet().toArray()[i];
                int level = (Integer)totalJewelEffectsPlayer.get(player).values().toArray()[i] - 1;
                int maxLevel = (Integer)MagicalJewelryConfigBuilder.JEWEL_MAX_EFFECT_LEVEL.get();
                switch (maxLevel) {
                    case 1: {
                        level = 0;
                        break;
                    }
                    case 2: {
                        if (level <= 1) break;
                        level = 1;
                        break;
                    }
                    case 3: {
                        if (level <= 2) break;
                        level = 2;
                    }
                }
                boolean legendaryFlag = legendaryEffectsList.contains(effect);
                if (legendaryFlag) {
                    level = 0;
                }
                player.m_7292_(new MobEffectInstance(effect, Integer.MAX_VALUE, level, true, false, (Boolean)MagicalJewelryConfigBuilder.JEWEL_EFFECT_ICON.get() == false));
                if (!rarity.equals(JewelRarity.LEGENDARY.getName())) continue;
                this.legendaryEffectRemoval(stack, player);
            }
        }
    }

    private void updateJewelEffects(LivingEntity player, MobEffect effect) {
        int length = totalJewelEffectsPlayer.get(player).size();
        for (int k = 0; k < length; ++k) {
            if (!totalJewelEffectsPlayer.get(player).keySet().toArray()[k].equals(effect)) continue;
            int oldValue = (Integer)totalJewelEffectsPlayer.get(player).values().toArray()[k];
            int newValue = (Integer)totalJewelEffectsPlayer.get(player).values().toArray()[k] - 1;
            totalJewelEffectsPlayer.get(player).replace(effect, oldValue, newValue);
            if (newValue < 1) {
                totalJewelEffectsPlayer.get(player).remove(effect);
                player.m_21195_(effect);
                break;
            }
            boolean legendaryFlag = legendaryEffectsList.contains(effect);
            if (legendaryFlag || newValue >= (Integer)MagicalJewelryConfigBuilder.JEWEL_MAX_EFFECT_LEVEL.get()) continue;
            player.m_21195_(effect);
            player.m_7292_(new MobEffectInstance(effect, Integer.MAX_VALUE, newValue - 1, true, false, (Boolean)MagicalJewelryConfigBuilder.JEWEL_EFFECT_ICON.get() == false));
        }
    }

    private void legendaryEffectRemoval(ItemStack stack, LivingEntity player) {
        if (!this.legendaryEffectsEnabled(stack)) {
            int j = JewelItem.getJewelLegendaryEffect(stack);
            MobEffect effect = (MobEffect)legendaryEffectsList.toArray()[j];
            boolean effectIsActive = player.m_21221_().containsKey(effect);
            if (effectIsActive) {
                boolean effectDuration;
                boolean bl = effectDuration = player.m_21124_(effect).m_19557_() > 10000;
                if (effectDuration) {
                    player.m_21195_(effect);
                }
            }
        }
    }

    public void getTotalJewelEffects(ItemStack stack, LivingEntity player) {
        if (this.legendaryEffectsEnabled(stack)) {
            int j = JewelItem.getJewelLegendaryEffect(stack);
            MobEffect effect = (MobEffect)legendaryEffectsList.toArray()[j];
            this.updateTotalJewelEffects(effect, player);
        }
        for (int i = 0; i < this.effectsLength(stack); ++i) {
            int j = JewelItem.getJewelEffects(stack)[i];
            MobEffect effect = (MobEffect)defaultEffectsList.toArray()[j];
            this.updateTotalJewelEffects(effect, player);
        }
    }

    private void updateTotalJewelEffects(MobEffect effect, LivingEntity player) {
        if (totalJewelEffectsPlayer.containsKey(player)) {
            if (!totalJewelEffectsPlayer.get(player).isEmpty()) {
                int length = totalJewelEffectsPlayer.get(player).size();
                for (int k = 0; k < length; ++k) {
                    if (totalJewelEffectsPlayer.get(player).keySet().toArray()[k].equals(effect)) {
                        int oldValue = (Integer)totalJewelEffectsPlayer.get(player).values().toArray()[k];
                        int newValue = (Integer)totalJewelEffectsPlayer.get(player).values().toArray()[k] + 1;
                        totalJewelEffectsPlayer.get(player).replace(effect, oldValue, newValue);
                        break;
                    }
                    if (k != length - 1) continue;
                    totalJewelEffectsPlayer.get(player).put(effect, 1);
                }
            } else {
                totalJewelEffectsPlayer.get(player).put(effect, 1);
            }
        } else {
            totalJewelEffectsPlayer.put(player, new HashMap());
            totalJewelEffectsPlayer.get(player).put(effect, 1);
        }
    }

    public void updateJewelAttributes(ItemStack stack, Multimap<Attribute, AttributeModifier> jewelAttributes) {
        if (JewelItem.getJewelRarity(stack).equals(JewelRarity.LEGENDARY.getName()) || JewelItem.getJewelRarity(stack).equals(JewelRarity.EPIC.getName())) {
            double amount = 2.0;
            int index = JewelItem.getJewelAttributes(stack);
            switch (index) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (!(stack.m_41720_() instanceof JewelAmuletItem)) break;
                    amount = 4.0;
                    break;
                }
                case 3: {
                    if (stack.m_41720_() instanceof JewelAmuletItem) {
                        amount = 8.0;
                        break;
                    }
                    amount = 4.0;
                    break;
                }
                case 4: {
                    amount = 1.0;
                }
            }
            String uuid = JewelItem.getJewelUUID(stack);
            AttributeModifier attributeModifier = new AttributeModifier(UUID.fromString(uuid), (String)descriptionAttributesList.get(index), amount, AttributeModifier.Operation.ADDITION);
            jewelAttributesForRemoval.put((Object)((Attribute)attributesList.get(index)), (Object)attributeModifier);
            if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_ATTRIBUTES.get()).booleanValue()) {
                jewelAttributes.put((Object)((Attribute)attributesList.get(index)), (Object)attributeModifier);
            }
        }
    }

    public boolean legendaryEffectsEnabled(ItemStack stack) {
        return (Boolean)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_EFFECTS.get() != false && JewelItem.getJewelRarity(stack).equals(JewelRarity.LEGENDARY.getName());
    }

    public int effectsLength(ItemStack stack) {
        String rarity = JewelItem.getJewelRarity(stack);
        int effectLength = rarity.equals(JewelRarity.UNCOMMON.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_UNCOMMON_EFFECT_AMOUNT.get() : (rarity.equals(JewelRarity.RARE.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_RARE_EFFECT_AMOUNT.get() : (rarity.equals(JewelRarity.EPIC.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_EPIC_EFFECT_AMOUNT.get() : (rarity.equals(JewelRarity.LEGENDARY.getName()) ? (Integer)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_EFFECT_AMOUNT.get() : 0)));
        return effectLength;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        block6: {
            block5: {
                String rarity = JewelItem.getJewelRarity(stack);
                if (!JewelRarity.containsRarity(rarity)) break block5;
                tooltip.set(0, (Component)tooltip.get(0).m_6881_().m_130940_(JewelRarity.byName(rarity).getFormat()));
                if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_RARITY_NAME.get()).booleanValue()) {
                    tooltip.set(0, (Component)tooltip.get(0).m_6881_().m_130946_(" (" + JewelRarity.byName(rarity).getDisplayName() + ")"));
                }
                if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_RARITY_TOOLTIP.get()).booleanValue()) {
                    tooltip.add((Component)new TextComponent(JewelRarity.byName(rarity).getFormat() + JewelRarity.byName(rarity).getDisplayName()));
                }
                if (this.legendaryEffectsEnabled(stack) && stack.m_41783_().m_128441_(NBT_LEGENDARY_EFFECT)) {
                    int j = JewelItem.getJewelLegendaryEffect(stack);
                    MobEffect effect = (MobEffect)legendaryEffectsList.toArray()[j];
                    String effectName = effect.m_19482_().getString();
                    tooltip.add((Component)new TextComponent(ChatFormatting.BLUE + effectName));
                }
                if (!stack.m_41783_().m_128441_(NBT_EFFECTS)) break block6;
                for (int i = 0; i < this.effectsLength(stack); ++i) {
                    int j = JewelItem.getJewelEffects(stack)[i];
                    MobEffect effect = (MobEffect)defaultEffectsList.toArray()[j];
                    String effectName = effect.m_19482_().getString();
                    tooltip.add((Component)new TextComponent(ChatFormatting.BLUE + effectName));
                }
                break block6;
            }
            String creativeJewelTooltip = new TranslatableComponent("item.magicaljewelry.tooltip.creative").getString();
            for (String s : creativeJewelTooltip.split("(?<=\\G.{25,}\\s)")) {
                tooltip.add((Component)new TextComponent(s).m_6881_().m_130940_(ChatFormatting.RED));
            }
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return JewelItem.getJewelRarity(stack).equals(JewelRarity.LEGENDARY.getName());
    }

    public static String getJewelRarity(ItemStack stack) {
        return stack.m_41784_().m_128461_(NBT_RARITY);
    }

    public static ItemStack setJewelRarity(ItemStack stack, String rarity) {
        stack.m_41784_().m_128359_(NBT_RARITY, rarity);
        return stack;
    }

    public static int[] getJewelEffects(ItemStack stack) {
        return stack.m_41784_().m_128465_(NBT_EFFECTS);
    }

    public static ItemStack setJewelEffects(ItemStack stack, List<Integer> effects) {
        stack.m_41784_().m_128408_(NBT_EFFECTS, effects);
        return stack;
    }

    public static int getJewelLegendaryEffect(ItemStack stack) {
        return stack.m_41784_().m_128451_(NBT_LEGENDARY_EFFECT);
    }

    public static ItemStack setJewelLegendaryEffect(ItemStack stack, int legendaryEffect) {
        stack.m_41784_().m_128405_(NBT_LEGENDARY_EFFECT, legendaryEffect);
        return stack;
    }

    public static int getJewelAttributes(ItemStack stack) {
        return stack.m_41784_().m_128451_(NBT_ATTRIBUTES);
    }

    public static ItemStack setJewelAttributes(ItemStack stack, int attributes) {
        stack.m_41784_().m_128405_(NBT_ATTRIBUTES, attributes);
        return stack;
    }

    public static String getJewelUUID(ItemStack stack) {
        return stack.m_41784_().m_128461_(NBT_UUID);
    }

    public static ItemStack setJewelUUID(ItemStack stack, String uuid) {
        stack.m_41784_().m_128359_(NBT_UUID, uuid);
        return stack;
    }

    public static String getGemColor(ItemStack stack) {
        return stack.m_41784_().m_128461_(NBT_COLOR);
    }

    public static ItemStack setGemColor(ItemStack stack, String color) {
        stack.m_41784_().m_128359_(NBT_COLOR, color);
        return stack;
    }

    private static int getColorValue(ItemStack stack) {
        float[] textureDiffuseColors = DyeColor.m_41057_((String)JewelItem.getGemColor(stack), (DyeColor)DyeColor.WHITE).m_41068_();
        int i = (int)(textureDiffuseColors[0] * 255.0f);
        int j = (int)(textureDiffuseColors[1] * 255.0f);
        int k = (int)(textureDiffuseColors[2] * 255.0f);
        int color = (i << 8) + j;
        color = (color << 8) + k;
        return color;
    }

    public static int getItemColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return JewelItem.getColorValue(stack);
        }
        return 0xFFFFFF;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            for (DyeColor color : DyeColor.values()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                JewelItem.setGemColor(stack, color.m_7912_());
                items.add((Object)stack);
            }
        }
    }
}

