/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.recipes;

import com.erfurt.magicaljewelry.MagicalJewelry;
import com.erfurt.magicaljewelry.objects.items.JewelItem;
import com.erfurt.magicaljewelry.recipes.UpgradeNBTIngredient;
import com.erfurt.magicaljewelry.util.config.MagicalJewelryConfigBuilder;
import com.erfurt.magicaljewelry.util.enums.JewelRarity;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class JewelUpgradeRecipe
extends UpgradeRecipe
implements Recipe<Container> {
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack result;
    private final ResourceLocation recipeId;

    public JewelUpgradeRecipe(ResourceLocation recipeId, Ingredient base, Ingredient addition, ItemStack result) {
        super(recipeId, base, addition, result);
        this.recipeId = recipeId;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack stackIn = inv.m_8020_(0);
        ItemStack stackOut = this.result.m_41777_();
        boolean rarityInCheck = false;
        if (stackIn.m_41720_() instanceof JewelItem) {
            rarityInCheck = JewelRarity.containsRarity(JewelItem.getJewelRarity(stackIn));
        }
        boolean rarityOutCheck = false;
        if (stackOut.m_41720_() instanceof JewelItem) {
            rarityOutCheck = JewelRarity.containsRarity(JewelItem.getJewelRarity(stackOut));
        }
        boolean upgradeEnabled = (Boolean)MagicalJewelryConfigBuilder.JEWEL_UPGRADE_DISABLE.get();
        return this.base.test(stackIn) && this.addition.test(inv.m_8020_(1)) && rarityInCheck && rarityOutCheck && !upgradeEnabled;
    }

    public ItemStack m_5874_(Container inv) {
        ItemStack stackOut = this.result.m_41777_();
        ItemStack stackIn = inv.m_8020_(0);
        if (stackIn.m_41782_() && stackOut.m_41782_()) {
            String rarityOut = stackOut.m_41783_().m_128423_("Rarity").m_7916_();
            CompoundTag nbtIn = stackIn.m_41783_();
            stackOut.m_41751_(nbtIn.m_6426_());
            JewelItem.setJewelRarity(stackOut, rarityOut);
            stackOut.m_41783_().m_128473_("Damage");
        }
        return stackOut;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)Blocks.f_50625_);
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44113_;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<JewelUpgradeRecipe> {
        public static final Serializer SERIALIZER = new Serializer();

        public JewelUpgradeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = UpgradeNBTIngredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"base"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"addition"));
            ItemStack stackOut = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new JewelUpgradeRecipe(recipeId, ingredient, ingredient1, stackOut);
        }

        public JewelUpgradeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = UpgradeNBTIngredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack stackOut = buffer.m_130267_();
            return new JewelUpgradeRecipe(recipeId, ingredient, ingredient1, stackOut);
        }

        public void toNetwork(FriendlyByteBuf buffer, JewelUpgradeRecipe recipe) {
            recipe.base.m_43923_(buffer);
            recipe.addition.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
        }

        static {
            SERIALIZER.setRegistryName(MagicalJewelry.getId("jewel_upgrade"));
        }
    }
}

