/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.recipes;

import com.erfurt.magicaljewelry.objects.items.JewelItem;
import com.erfurt.magicaljewelry.util.enums.JewelRarity;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class UpgradeNBTIngredient
extends Ingredient {
    private final ItemStack stack;

    protected UpgradeNBTIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.ItemValue(stack)));
        this.stack = stack;
    }

    public boolean test(@Nullable ItemStack input) {
        boolean rarityCheckTemp;
        JsonObject json = this.m_43942_().getAsJsonObject();
        boolean rarityCheck = false;
        if (input != null && input.m_41782_() && input.m_41720_() instanceof JewelItem && (rarityCheckTemp = JewelRarity.containsRarity(JewelItem.getJewelRarity(input)))) {
            String rarityTemp = json.get("nbt").getAsString();
            int stringSize = rarityTemp.length();
            String rarity = rarityTemp.substring(1, stringSize - 1);
            rarityCheck = Objects.requireNonNull(input.m_41783_().m_128423_("Rarity")).m_7916_().equals(rarity);
        }
        return this.stack.m_41720_() == input.m_41720_() && rarityCheck;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("item", this.stack.m_41720_().getRegistryName().toString());
        if (this.stack.m_41782_()) {
            json.addProperty("nbt", this.stack.m_41783_().m_128423_("Rarity").toString());
        }
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<UpgradeNBTIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public UpgradeNBTIngredient parse(FriendlyByteBuf buffer) {
            return new UpgradeNBTIngredient(buffer.m_130267_());
        }

        public UpgradeNBTIngredient parse(JsonObject json) {
            return new UpgradeNBTIngredient(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
        }

        public void write(FriendlyByteBuf buffer, UpgradeNBTIngredient ingredient) {
            buffer.m_130055_(ingredient.stack);
        }
    }
}

