/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.util;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class LootTableUtil {
    private static List<LootPool> getPools(LootTable table) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"f_79109_");
    }

    private static List<LootItemCondition> getLootConditions(LootPool pool) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"f_79024_");
    }

    private static float getLootItemRandomChanceConditionValue(LootItemRandomChanceCondition condition) {
        return ((Float)ObfuscationReflectionHelper.getPrivateValue(LootItemRandomChanceCondition.class, (Object)condition, (String)"f_81921_")).floatValue();
    }

    private static float getLootItemRandomChanceWithLootingConditionValue(LootItemRandomChanceWithLootingCondition condition) {
        return ((Float)ObfuscationReflectionHelper.getPrivateValue(LootItemRandomChanceWithLootingCondition.class, (Object)condition, (String)"f_81953_")).floatValue();
    }

    private static float getLootingMultiplierValue(LootItemRandomChanceWithLootingCondition condition) {
        return ((Float)ObfuscationReflectionHelper.getPrivateValue(LootItemRandomChanceWithLootingCondition.class, (Object)condition, (String)"f_81954_")).floatValue();
    }

    public static float getChance(ResourceLocation resource, MinecraftServer server) {
        float[] chance = new float[]{-0.1f};
        LootTables manager = server.m_129898_();
        LootTable table = manager.m_79217_(resource);
        LootTableUtil.getPools(table).forEach(pool -> {
            List<LootItemCondition> poolConditions = LootTableUtil.getLootConditions(pool);
            poolConditions.forEach(condition -> {
                if (condition instanceof LootItemRandomChanceCondition) {
                    chance[0] = LootTableUtil.getLootItemRandomChanceConditionValue((LootItemRandomChanceCondition)condition);
                } else if (condition instanceof LootItemRandomChanceWithLootingCondition) {
                    chance[0] = LootTableUtil.getLootItemRandomChanceWithLootingConditionValue((LootItemRandomChanceWithLootingCondition)condition);
                }
            });
        });
        return chance[0];
    }

    public static float getLootingMultiplier(ResourceLocation resource, MinecraftServer server) {
        float[] lootingMultiplier = new float[]{-0.1f};
        LootTables manager = server.m_129898_();
        LootTable table = manager.m_79217_(resource);
        LootTableUtil.getPools(table).forEach(pool -> {
            List<LootItemCondition> poolConditions = LootTableUtil.getLootConditions(pool);
            poolConditions.forEach(condition -> {
                if (condition instanceof LootItemRandomChanceWithLootingCondition) {
                    lootingMultiplier[0] = LootTableUtil.getLootingMultiplierValue((LootItemRandomChanceWithLootingCondition)condition);
                }
            });
        });
        return lootingMultiplier[0];
    }
}

