/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.util.enums;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public enum JewelRarity {
    UNCOMMON("uncommon", ChatFormatting.DARK_GREEN),
    RARE("rare", ChatFormatting.DARK_AQUA),
    EPIC("epic", ChatFormatting.DARK_PURPLE),
    LEGENDARY("legendary", ChatFormatting.GOLD);

    private final String name;
    private final ChatFormatting format;
    private final Component displayName;

    private JewelRarity(String nameIn, ChatFormatting formatIn) {
        this.name = nameIn;
        this.format = formatIn;
        this.displayName = new TranslatableComponent("rarity.magicaljewelry." + nameIn);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName.getString();
    }

    public ChatFormatting getFormat() {
        return this.format;
    }

    public static JewelRarity byName(String name) {
        for (JewelRarity rarity : JewelRarity.values()) {
            if (!rarity.name.equals(name)) continue;
            return rarity;
        }
        return null;
    }

    public static boolean containsRarity(String name) {
        for (JewelRarity rarity : JewelRarity.values()) {
            if (!rarity.name.equals(name)) continue;
            return true;
        }
        return false;
    }
}

