/*
 * Decompiled with CFR 0.152.
 */
package com.erfurt.magicaljewelry.util.interfaces;

import com.erfurt.magicaljewelry.util.config.MagicalJewelryConfigBuilder;
import com.erfurt.magicaljewelry.util.enums.JewelRarity;
import java.util.Random;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public interface IJewelRarity {
    public static final Random rand = new Random();
    public static final int legendaryLuckIncrease = 3;
    public static final int epicLuckIncrease = 2;
    public static final int rareLuckIncrease = 1;

    public static String getRarity(LivingEntity livingEntity) {
        String rarity;
        if (!((Boolean)MagicalJewelryConfigBuilder.JEWEL_ONE_RARITY_DROP.get()).booleanValue()) {
            int chance;
            int rareDropRate;
            int epicDropRate;
            int legendaryDropRate;
            int legendaryDRConfig = (Integer)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_DROP_RATE.get();
            int epicDRConfig = (Integer)MagicalJewelryConfigBuilder.JEWEL_EPIC_DROP_RATE.get();
            int rareDRConfig = (Integer)MagicalJewelryConfigBuilder.JEWEL_RARE_DROP_RATE.get();
            if (livingEntity != null && livingEntity.m_21221_().containsKey(MobEffects.f_19621_)) {
                int luckLevel = livingEntity.m_21124_(MobEffects.f_19621_).m_19564_() + 1;
                legendaryDropRate = legendaryDRConfig + 3 * luckLevel;
                epicDropRate = epicDRConfig + 2 * luckLevel;
                rareDropRate = rareDRConfig + 1 * luckLevel;
            } else {
                legendaryDropRate = legendaryDRConfig;
                epicDropRate = epicDRConfig;
                rareDropRate = rareDRConfig;
            }
            int totalEpicDropRate = epicDropRate + legendaryDropRate;
            int totalRareDropRate = rareDropRate + totalEpicDropRate;
            int totalChance = 100;
            if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_UPGRADE_ONLY.get()).booleanValue()) {
                totalChance -= legendaryDropRate;
            }
            rarity = (chance = rand.nextInt(totalChance) + 1) > 100 - legendaryDropRate ? JewelRarity.LEGENDARY.getName() : (chance > totalChance - totalEpicDropRate ? JewelRarity.EPIC.getName() : (chance > totalChance - totalRareDropRate ? JewelRarity.RARE.getName() : JewelRarity.UNCOMMON.getName()));
        } else {
            rarity = ((JewelRarity)((Object)MagicalJewelryConfigBuilder.JEWEL_RARITY_TO_DROP.get())).getName();
        }
        return rarity;
    }

    public static String getRarityBoss(LivingEntity livingEntity) {
        String rarity;
        if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_UPGRADE_ONLY.get()).booleanValue() && !((Boolean)MagicalJewelryConfigBuilder.JEWEL_ONE_RARITY_DROP.get()).booleanValue()) {
            rarity = JewelRarity.EPIC.getName();
        } else if (((Boolean)MagicalJewelryConfigBuilder.JEWEL_ONE_RARITY_DROP.get()).booleanValue()) {
            rarity = ((JewelRarity)((Object)MagicalJewelryConfigBuilder.JEWEL_RARITY_TO_DROP.get())).getName();
        } else {
            int epicDropRate;
            int legendaryDropRate;
            int legendaryDRConfig = (Integer)MagicalJewelryConfigBuilder.JEWEL_LEGENDARY_DROP_RATE.get();
            int epicDRConfig = (Integer)MagicalJewelryConfigBuilder.JEWEL_EPIC_DROP_RATE.get();
            if (livingEntity != null && livingEntity.m_21221_().containsKey(MobEffects.f_19621_)) {
                int luckLevel = livingEntity.m_21124_(MobEffects.f_19621_).m_19564_() + 1;
                legendaryDropRate = legendaryDRConfig + 3 * luckLevel;
                epicDropRate = epicDRConfig + 2 * luckLevel;
            } else {
                legendaryDropRate = legendaryDRConfig;
                epicDropRate = epicDRConfig;
            }
            int totalEpicDropRate = epicDropRate + legendaryDropRate;
            int chance = rand.nextInt(totalEpicDropRate) + 1;
            rarity = chance <= legendaryDropRate ? JewelRarity.LEGENDARY.getName() : JewelRarity.EPIC.getName();
        }
        return rarity;
    }

    public static String getRarityCommand() {
        String rarity = JewelRarity.UNCOMMON.getName();
        int random = rand.nextInt(JewelRarity.values().length);
        if (random == 0) {
            rarity = JewelRarity.LEGENDARY.getName();
        } else if (random == 1) {
            rarity = JewelRarity.EPIC.getName();
        } else if (random == 2) {
            rarity = JewelRarity.RARE.getName();
        }
        return rarity;
    }
}

