/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum;

import java.awt.Color;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;

@OnlyIn(value=Dist.CLIENT)
public class ClientHelper {
    public static void spawnBlockParticles(BlockPos pos, BlockState state) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71452_i.func_180533_a(pos, state);
    }

    public static void registerItemColorTint(ItemColors itemColors, RegistryObject<Item> item, Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        itemColors.func_199877_a((stack, c) -> {
            if (c == 0) {
                return r << 16 | g << 8 | b;
            }
            return 0xFFFFFF;
        }, new IItemProvider[]{(IItemProvider)item.get()});
    }

    public static void registerItemColor(ItemColors itemColors, RegistryObject<Item> item, Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        itemColors.func_199877_a((stack, i) -> r << 16 | g << 8 | b, new IItemProvider[]{(IItemProvider)item.get()});
    }

    public static IFormattableTextComponent simpleComponent(String message) {
        return new StringTextComponent(message).func_240699_a_(TextFormatting.WHITE);
    }

    public static IFormattableTextComponent simpleTranslatableComponent(String message) {
        return new TranslationTextComponent(message).func_240699_a_(TextFormatting.WHITE);
    }

    public static IFormattableTextComponent importantComponent(String message) {
        return new StringTextComponent(message).func_240701_a_(new TextFormatting[]{TextFormatting.DARK_PURPLE, TextFormatting.ITALIC});
    }

    public static IFormattableTextComponent importantTranslatableComponent(String message) {
        return new TranslationTextComponent(message).func_240701_a_(new TextFormatting[]{TextFormatting.DARK_PURPLE, TextFormatting.ITALIC});
    }

    public static IFormattableTextComponent combinedComponent(IFormattableTextComponent ... components) {
        IFormattableTextComponent finalComponent = components[0];
        for (IFormattableTextComponent component : components) {
            if (component.equals(finalComponent)) continue;
            finalComponent.func_230529_a_((ITextComponent)component);
        }
        return finalComponent;
    }
}

