/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blocks.spiritaltar;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.spiritaltar.SpiritAltarTileEntity;
import com.sammy.malum.common.items.SpiritItem;
import com.sammy.malum.core.init.MalumSounds;
import com.sammy.malum.core.init.items.MalumItems;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SpiritAltarBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public SpiritAltarBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (worldIn instanceof ServerWorld) {
            this.func_220062_a(state, (ServerWorld)worldIn, pos, player.func_184607_cu());
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_220062_a(BlockState state, ServerWorld worldIn, BlockPos pos, ItemStack stack) {
        if (worldIn.func_175625_s(pos) instanceof SpiritAltarTileEntity) {
            SpiritAltarTileEntity tileEntity = (SpiritAltarTileEntity)worldIn.func_175625_s(pos);
            worldIn.func_217376_c((Entity)new ItemEntity((World)worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), tileEntity.inventory.getStackInSlot(0)));
            for (ItemStack itemStack : tileEntity.spiritInventory.stacks()) {
                worldIn.func_217376_c((Entity)new ItemEntity((World)worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), itemStack));
            }
            for (ItemStack itemStack : tileEntity.extrasInventory.stacks()) {
                worldIn.func_217376_c((Entity)new ItemEntity((World)worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), itemStack));
            }
        }
        super.func_220062_a(state, worldIn, pos, stack);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (MalumHelper.areWeOnClient(worldIn)) {
            return ActionResultType.SUCCESS;
        }
        if (handIn.equals((Object)Hand.MAIN_HAND) && worldIn.func_175625_s(pos) instanceof SpiritAltarTileEntity) {
            boolean success;
            SpiritAltarTileEntity tileEntity = (SpiritAltarTileEntity)worldIn.func_175625_s(pos);
            ItemStack heldStack = player.func_184614_ca();
            if (heldStack.func_77973_b().equals(MalumItems.HEX_ASH.get()) && !tileEntity.inventory.getStackInSlot(0).func_190926_b()) {
                if (!tileEntity.spedUp) {
                    heldStack.func_190918_g(1);
                    tileEntity.progress = 0;
                    tileEntity.spedUp = true;
                    worldIn.func_184133_a(null, pos, MalumSounds.ALTAR_SPEED_UP, SoundCategory.BLOCKS, 1.0f, 0.9f + worldIn.field_73012_v.nextFloat() * 0.2f);
                    MalumHelper.updateState(worldIn, pos);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.PASS;
            }
            if (!(heldStack.func_77973_b() instanceof SpiritItem) && (success = tileEntity.inventory.playerHandleItem(worldIn, player, handIn))) {
                return ActionResultType.SUCCESS;
            }
            if ((heldStack.func_77973_b() instanceof SpiritItem || heldStack.func_190926_b()) && (success = tileEntity.spiritInventory.playerHandleItem(worldIn, player, handIn))) {
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SpiritAltarTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
        super.func_206840_a(builder);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }
}

