/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blocks.spiritaltar;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.spiritaltar.IAltarProvider;
import com.sammy.malum.common.items.SpiritItem;
import com.sammy.malum.core.init.MalumSounds;
import com.sammy.malum.core.init.blocks.MalumTileEntities;
import com.sammy.malum.core.init.particles.MalumParticles;
import com.sammy.malum.core.modcontent.MalumSpiritAltarRecipes;
import com.sammy.malum.core.systems.inventory.SimpleInventory;
import com.sammy.malum.core.systems.particles.ParticleManager;
import com.sammy.malum.core.systems.recipes.SpiritIngredient;
import com.sammy.malum.core.systems.spirits.SpiritHelper;
import com.sammy.malum.core.systems.tileentities.SimpleTileEntity;
import com.sammy.malum.network.NetworkManager;
import com.sammy.malum.network.packets.particle.altar.SpiritAltarConsumeParticlePacket;
import com.sammy.malum.network.packets.particle.altar.SpiritAltarCraftParticlePacket;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;

public class SpiritAltarTileEntity
extends SimpleTileEntity
implements ITickableTileEntity {
    public int soundCooldown;
    public int progress;
    public boolean spedUp;
    public int spinUp;
    public float spin;
    public SimpleInventory inventory = new SimpleInventory(1, 64, t -> !(t.func_77973_b() instanceof SpiritItem)){

        protected void onContentsChanged(int slot) {
            SpiritAltarTileEntity.this.func_70296_d();
            SpiritAltarTileEntity.this.func_145836_u();
            MalumHelper.updateAndNotifyState(SpiritAltarTileEntity.this.field_145850_b, SpiritAltarTileEntity.this.field_174879_c);
            SpiritAltarTileEntity.this.recipe = MalumSpiritAltarRecipes.getRecipe(SpiritAltarTileEntity.this.inventory.getStackInSlot(slot), SpiritAltarTileEntity.this.spiritInventory.nonEmptyStacks());
        }
    };
    public SimpleInventory extrasInventory = new SimpleInventory(8, 1){

        protected void onContentsChanged(int slot) {
            SpiritAltarTileEntity.this.func_70296_d();
            SpiritAltarTileEntity.this.func_145836_u();
            MalumHelper.updateAndNotifyState(SpiritAltarTileEntity.this.field_145850_b, SpiritAltarTileEntity.this.field_174879_c);
        }
    };
    public SimpleInventory spiritInventory = new SimpleInventory(8, 64, t -> t.func_77973_b() instanceof SpiritItem){

        protected void onContentsChanged(int slot) {
            SpiritAltarTileEntity.this.func_70296_d();
            SpiritAltarTileEntity.this.func_145836_u();
            MalumHelper.updateAndNotifyState(SpiritAltarTileEntity.this.field_145850_b, SpiritAltarTileEntity.this.field_174879_c);
            SpiritAltarTileEntity.this.recipe = MalumSpiritAltarRecipes.getRecipe(SpiritAltarTileEntity.this.inventory.getStackInSlot(0), SpiritAltarTileEntity.this.spiritInventory.nonEmptyStacks());
        }
    };
    public MalumSpiritAltarRecipes.MalumSpiritAltarRecipe recipe;

    public SpiritAltarTileEntity() {
        super((TileEntityType)MalumTileEntities.SPIRIT_ALTAR_TILE_ENTITY.get());
    }

    @Override
    public CompoundNBT writeData(CompoundNBT compound) {
        if (this.progress != 0) {
            compound.func_74768_a("progress", this.progress);
        }
        if (this.spinUp != 0) {
            compound.func_74768_a("spinUp", this.spinUp);
        }
        if (this.spedUp) {
            compound.func_74774_a("spedUp", (byte)0);
        }
        this.inventory.writeData(compound);
        this.spiritInventory.writeData(compound, "spiritInventory");
        this.extrasInventory.writeData(compound, "extrasInventory");
        return super.writeData(compound);
    }

    @Override
    public void readData(CompoundNBT compound) {
        this.progress = compound.func_74762_e("progress");
        this.spinUp = compound.func_74762_e("spinUp");
        if (compound.func_74764_b("spedUp")) {
            this.spedUp = true;
        }
        this.inventory.readData(compound);
        this.spiritInventory.readData(compound, "spiritInventory");
        this.extrasInventory.readData(compound, "extrasInventory");
        this.recipe = MalumSpiritAltarRecipes.getRecipe(this.inventory.getStackInSlot(0), this.spiritInventory.nonEmptyStacks());
    }

    public void func_73660_a() {
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
        if (this.recipe != null) {
            int spinCap;
            int n = spinCap = this.spedUp ? 30 : 10;
            if (this.spinUp < spinCap) {
                ++this.spinUp;
            }
            if (MalumHelper.areWeOnServer(this.field_145850_b)) {
                int progressCap;
                if (this.soundCooldown == 0) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, MalumSounds.ALTAR_LOOP, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.soundCooldown = 180;
                }
                ItemStack stack = this.inventory.getStackInSlot(0);
                ++this.progress;
                int n2 = progressCap = this.spedUp ? 60 : 360;
                if (this.progress >= progressCap) {
                    Vector3d itemPos = SpiritAltarTileEntity.itemPos(this);
                    int extras = this.extrasInventory.nonEmptyItems();
                    if (extras != this.recipe.extraItemIngredients.size()) {
                        this.progress = (int)((float)this.progress * 0.5f);
                        int horizontal = 4;
                        int vertical = 2;
                        ArrayList<BlockPos> nearbyBlocks = MalumHelper.getBlocks(this.field_174879_c, horizontal, vertical, horizontal);
                        for (BlockPos pos : nearbyBlocks) {
                            if (!(this.field_145850_b.func_175625_s(pos) instanceof IAltarProvider)) continue;
                            IAltarProvider tileEntity = (IAltarProvider)this.field_145850_b.func_175625_s(pos);
                            ItemStack providedStack = tileEntity.providedInventory().getStackInSlot(0);
                            if (!this.recipe.extraItemIngredients.get(this.extrasInventory.nonEmptyItems()).matches(providedStack)) continue;
                            this.field_145850_b.func_184133_a(null, pos, MalumSounds.ALTAR_CONSUME, SoundCategory.BLOCKS, 1.0f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
                            Vector3d providedItemPos = tileEntity.providedItemPos();
                            NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(pos)), (Object)SpiritAltarConsumeParticlePacket.fromIngredients(providedStack, this.recipe.spiritIngredients, providedItemPos.field_72450_a, providedItemPos.field_72448_b, providedItemPos.field_72449_c, itemPos.field_72450_a, itemPos.field_72448_b, itemPos.field_72449_c));
                            this.extrasInventory.playerInsertItem(this.field_145850_b, providedStack.func_77979_a(1));
                            MalumHelper.updateAndNotifyState(this.field_145850_b, pos);
                            MalumHelper.updateAndNotifyState(this.field_145850_b, this.field_174879_c);
                            break;
                        }
                        return;
                    }
                    block1: for (SpiritIngredient ingredient : this.recipe.spiritIngredients) {
                        for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                            ItemStack spiritStack = this.spiritInventory.getStackInSlot(i);
                            if (!ingredient.matches(spiritStack)) continue;
                            spiritStack.func_190918_g(ingredient.count);
                            continue block1;
                        }
                    }
                    NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)SpiritAltarCraftParticlePacket.fromIngredients(this.recipe.spiritIngredients, itemPos.field_72450_a, itemPos.field_72448_b, itemPos.field_72449_c));
                    stack.func_190918_g(this.recipe.inputIngredient.count);
                    ItemEntity entity = new ItemEntity(this.field_145850_b, itemPos.field_72450_a, itemPos.field_72448_b, itemPos.field_72449_c, this.recipe.outputIngredient.getItem());
                    this.field_145850_b.func_217376_c((Entity)entity);
                    this.progress = 0;
                    this.extrasInventory.clearItems();
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, MalumSounds.ALTAR_CRAFT, SoundCategory.BLOCKS, 1.0f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
                    if (this.recipe != null && !this.recipe.matches(this.spiritInventory.nonEmptyStacks())) {
                        this.recipe = null;
                    }
                    MalumHelper.updateAndNotifyState(this.field_145850_b, this.field_174879_c);
                }
            }
        } else {
            this.progress = 0;
            if (this.spinUp > 0) {
                --this.spinUp;
            }
            this.spedUp = false;
        }
        if (MalumHelper.areWeOnClient(this.field_145850_b)) {
            this.passiveParticles();
        }
    }

    public static Vector3d itemPos(SimpleTileEntity tileEntity) {
        return MalumHelper.pos(tileEntity.func_174877_v()).func_72441_c(0.5, (double)1.15f, 0.5);
    }

    public static Vector3d itemOffset(SpiritAltarTileEntity tileEntity, int slot) {
        float distance = 1.0f - Math.min(0.25f, (float)tileEntity.spinUp / 40.0f) + (float)Math.sin(tileEntity.spin / 20.0f) * 0.025f;
        float height = 0.75f + Math.min(0.5f, (float)tileEntity.spinUp / 20.0f);
        return MalumHelper.rotatedCirclePosition(new Vector3d(0.5, (double)height, 0.5), distance, slot, tileEntity.spiritInventory.nonEmptyItems(), (long)tileEntity.spin, 360.0f);
    }

    public void passiveParticles() {
        Vector3d itemPos = SpiritAltarTileEntity.itemPos(this);
        this.spin += 1.0f + (float)this.spinUp / 5.0f;
        for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
            ItemStack item = this.spiritInventory.getStackInSlot(i);
            if (!(item.func_77973_b() instanceof SpiritItem)) continue;
            Vector3d offset = SpiritAltarTileEntity.itemOffset(this, i);
            Random rand = this.field_145850_b.field_73012_v;
            double x = (double)this.func_174877_v().func_177958_n() + offset.func_82615_a();
            double y = (double)this.func_174877_v().func_177956_o() + offset.func_82617_b();
            double z = (double)this.func_174877_v().func_177952_p() + offset.func_82616_c();
            SpiritItem spiritSplinterItem = (SpiritItem)item.func_77973_b();
            Color color = spiritSplinterItem.type.color;
            SpiritHelper.spiritParticles(this.field_145850_b, x, y, z, color);
            if (this.recipe == null) continue;
            Vector3d velocity = new Vector3d(x, y, z).func_178788_d(itemPos).func_72432_b().func_186678_a((double)-0.03f);
            ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.15f, 0.0f).setLifetime(40).setScale(0.2f, 0.0f).randomOffset(0.02f).randomVelocity(0.01f, 0.01f).setColor(color, color.darker()).randomVelocity(0.0025f, 0.0025f).addVelocity(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c).enableNoClip().repeat(this.field_145850_b, x, y, z, this.spedUp ? 4 : 2);
            float alpha = 0.08f / (float)this.spiritInventory.nonEmptyItems();
            ParticleManager.create(MalumParticles.SPARKLE_PARTICLE).setAlpha(alpha, 0.0f).setLifetime(20).setScale(0.5f, 0.0f).randomOffset(0.1, 0.1).randomVelocity(0.02f, 0.02f).setColor(color, color.darker()).randomVelocity(0.0025f, 0.0025f).enableNoClip().repeat(this.field_145850_b, itemPos.field_72450_a, itemPos.field_72448_b, itemPos.field_72449_c, this.spedUp ? 4 : 2);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

