/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blocks.spiritjar;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.spiritjar.SpiritJarTileEntity;
import com.sammy.malum.common.items.SpiritItem;
import com.sammy.malum.core.init.particles.MalumParticles;
import com.sammy.malum.core.systems.particles.ParticleManager;
import com.sammy.malum.core.systems.spirits.MalumSpiritType;
import java.awt.Color;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.ItemHandlerHelper;

public class SpiritJarBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape SHAPE = Stream.of(Block.func_208617_a((double)2.5, (double)0.5, (double)2.5, (double)13.5, (double)13.5, (double)13.5), Block.func_208617_a((double)3.5, (double)14.5, (double)3.5, (double)12.5, (double)16.5, (double)12.5), Block.func_208617_a((double)4.5, (double)13.5, (double)4.5, (double)11.5, (double)14.5, (double)11.5), Block.func_208617_a((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)1.0, (double)10.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public SpiritJarBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (worldIn instanceof ServerWorld) {
            this.func_220062_a(state, (ServerWorld)worldIn, pos, player.func_184607_cu());
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_220062_a(BlockState state, ServerWorld worldIn, BlockPos pos, ItemStack stack) {
        if (worldIn.func_175625_s(pos) instanceof SpiritJarTileEntity) {
            SpiritJarTileEntity tileEntity = (SpiritJarTileEntity)worldIn.func_175625_s(pos);
            while (tileEntity.count > 0) {
                int stackCount = Math.min(tileEntity.count, 64);
                worldIn.func_217376_c((Entity)new ItemEntity((World)worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), new ItemStack((IItemProvider)tileEntity.field_200663_e.splinterItem(), stackCount)));
                tileEntity.count -= stackCount;
            }
        }
        super.func_220062_a(state, worldIn, pos, stack);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        if (worldIn.func_175625_s(pos) instanceof SpiritJarTileEntity) {
            SpiritJarTileEntity tileEntity = (SpiritJarTileEntity)worldIn.func_175625_s(pos);
            if (heldItem.func_77973_b() instanceof SpiritItem) {
                SpiritItem spiritSplinterItem = (SpiritItem)heldItem.func_77973_b();
                if (tileEntity.field_200663_e == null) {
                    tileEntity.field_200663_e = spiritSplinterItem.type;
                    tileEntity.count = heldItem.func_190916_E();
                    player.func_184611_a(handIn, ItemStack.field_190927_a);
                    this.particles(worldIn, hit, tileEntity.field_200663_e);
                    return ActionResultType.SUCCESS;
                }
                if (tileEntity.field_200663_e.equals(spiritSplinterItem.type)) {
                    tileEntity.count += heldItem.func_190916_E();
                    player.func_184611_a(handIn, ItemStack.field_190927_a);
                    this.particles(worldIn, hit, tileEntity.field_200663_e);
                    return ActionResultType.SUCCESS;
                }
            } else if (tileEntity.field_200663_e != null) {
                int max = player.func_225608_bj_() ? 64 : 1;
                int count = Math.min(tileEntity.count, max);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)tileEntity.field_200663_e.splinterItem(), count));
                tileEntity.count -= count;
                this.particles(worldIn, hit, tileEntity.field_200663_e);
                if (tileEntity.count == 0) {
                    tileEntity.field_200663_e = null;
                }
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void particles(World world, BlockRayTraceResult hit, MalumSpiritType type) {
        if (MalumHelper.areWeOnClient(world)) {
            Color color = type.color;
            ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.4f, 0.0f).setLifetime(20).setScale(0.3f, 0.0f).setSpin(0.2f).randomOffset(0.1f, 0.1f).setColor(color, color.darker()).enableNoClip().repeat(world, hit.func_216347_e().func_82615_a(), hit.func_216347_e().field_72448_b, hit.func_216347_e().field_72449_c, 10);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SpiritJarTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
        super.func_206840_a(builder);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }
}

