/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blocks.totem;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.totem.pole.TotemPoleTileEntity;
import com.sammy.malum.core.init.MalumSounds;
import com.sammy.malum.core.init.blocks.MalumTileEntities;
import com.sammy.malum.core.modcontent.MalumRites;
import com.sammy.malum.core.systems.rites.MalumRiteType;
import com.sammy.malum.core.systems.spirits.MalumSpiritType;
import com.sammy.malum.core.systems.spirits.SpiritHelper;
import com.sammy.malum.core.systems.tileentities.SimpleTileEntity;
import com.sammy.malum.network.NetworkManager;
import com.sammy.malum.network.packets.particle.totem.TotemParticlePacket;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class TotemBaseTileEntity
extends SimpleTileEntity
implements ITickableTileEntity {
    public MalumRiteType rite;
    public ArrayList<MalumSpiritType> spirits = new ArrayList();
    public boolean active;
    public int progress;
    public int height;

    public TotemBaseTileEntity() {
        super((TileEntityType)MalumTileEntities.TOTEM_BASE_TILE_ENTITY.get());
    }

    @Override
    public CompoundNBT writeData(CompoundNBT compound) {
        if (this.rite != null) {
            compound.func_74778_a("rite", this.rite.identifier);
        }
        compound.func_74768_a("spiritCount", this.spirits.size());
        for (int i = 0; i < this.spirits.size(); ++i) {
            MalumSpiritType type = this.spirits.get(i);
            compound.func_74778_a("spirit_" + i, type.identifier);
        }
        compound.func_74757_a("active", this.active);
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("height", this.height);
        return super.writeData(compound);
    }

    @Override
    public void readData(CompoundNBT compound) {
        this.rite = MalumRites.getRite(compound.func_74779_i("rite"));
        int size = compound.func_74762_e("spiritCount");
        for (int i = 0; i < size; ++i) {
            this.spirits.add(SpiritHelper.figureOutType(compound.func_74779_i("spirit_" + i)));
        }
        this.active = compound.func_74767_n("active");
        this.progress = compound.func_74762_e("progress");
        this.height = compound.func_74762_e("height");
        super.readData(compound);
    }

    public void func_73660_a() {
        if (MalumHelper.areWeOnServer(this.field_145850_b)) {
            if (this.rite != null) {
                ++this.progress;
                if (this.progress >= this.rite.interval()) {
                    this.rite.executeRite((ServerWorld)this.field_145850_b, this.field_174879_c);
                    this.progress = 0;
                }
            } else if (this.active) {
                --this.progress;
                if (this.progress <= 0) {
                    ++this.height;
                    this.progress = 20;
                    BlockPos polePos = this.field_174879_c.func_177981_b(this.height);
                    if (this.field_145850_b.func_175625_s(polePos) instanceof TotemPoleTileEntity) {
                        Direction poleFacing = (Direction)this.field_145850_b.func_180495_p(polePos).func_177229_b((Property)BlockStateProperties.field_208157_J);
                        Direction baseFacing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
                        if (this.height == 1) {
                            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)poleFacing));
                            MalumHelper.updateState(this.field_145850_b, this.field_174879_c);
                        }
                        if (poleFacing.equals((Object)baseFacing)) {
                            TotemPoleTileEntity tileEntity = (TotemPoleTileEntity)this.field_145850_b.func_175625_s(polePos);
                            if (tileEntity.field_200663_e != null) {
                                this.spirits.add(tileEntity.field_200663_e);
                                tileEntity.riteStarting(this.height);
                            }
                        }
                    } else {
                        MalumRiteType rite = MalumRites.getRite(this.spirits);
                        if (rite == null) {
                            this.riteEnding();
                        } else {
                            this.riteComplete(rite);
                        }
                    }
                }
            }
        }
    }

    public ArrayList<TotemPoleTileEntity> poles() {
        ArrayList<TotemPoleTileEntity> poles = new ArrayList<TotemPoleTileEntity>();
        for (int i = 1; i <= this.height; ++i) {
            if (!(this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(i)) instanceof TotemPoleTileEntity)) continue;
            poles.add((TotemPoleTileEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(i)));
        }
        return poles;
    }

    public void reset() {
        this.poles().forEach(TotemPoleTileEntity::riteEnding);
        this.height = 0;
        this.rite = null;
        this.active = false;
        this.progress = 0;
        this.spirits.clear();
        MalumHelper.updateAndNotifyState(this.field_145850_b, this.field_174879_c);
    }

    public void riteStarting() {
        this.active = true;
        MalumHelper.updateAndNotifyState(this.field_145850_b, this.field_174879_c);
    }

    public void riteComplete(MalumRiteType rite) {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, MalumSounds.TOTEM_CHARGED, SoundCategory.BLOCKS, 1.0f, 1.0f);
        NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)TotemParticlePacket.fromSpirits(this.spirits, this.field_174879_c, true));
        this.poles().forEach(p -> p.riteComplete(this.height));
        this.progress = 0;
        if (rite.isInstant) {
            rite.executeRite((ServerWorld)this.field_145850_b, this.field_174879_c);
            this.reset();
            return;
        }
        this.rite = rite;
        MalumHelper.updateAndNotifyState(this.field_145850_b, this.field_174879_c);
    }

    public void riteEnding() {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, MalumSounds.TOTEM_CHARGE, SoundCategory.BLOCKS, 1.0f, 0.5f);
        NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)TotemParticlePacket.fromSpirits(this.spirits, this.field_174879_c, false));
        this.reset();
    }
}

