/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blocks.totem.pole;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.totem.pole.TotemPoleTileEntity;
import com.sammy.malum.core.modcontent.MalumSpiritTypes;
import com.sammy.malum.core.systems.spirits.MalumSpiritType;
import java.awt.Color;
import java.util.HashMap;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class TotemPoleRenderer
extends TileEntityRenderer<TotemPoleTileEntity> {
    public static boolean setup = false;
    public static HashMap<MalumSpiritType, RenderMaterial> overlayHashmap = new HashMap();
    public static HashMap<MalumSpiritType, RenderMaterial> cutoutHashmap = new HashMap();
    public static final RenderMaterial RUNEWOOD_LOG = new RenderMaterial(AtlasTexture.field_110575_b, MalumHelper.prefix("block/runewood_log"));

    public TotemPoleRenderer(Object rendererDispatcherIn) {
        super((TileEntityRendererDispatcher)rendererDispatcherIn);
    }

    public void render(TotemPoleTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntityIn.field_200663_e == null) {
            this.renderQuad(RUNEWOOD_LOG, new Color(255, 255, 255), combinedLightIn, tileEntityIn, matrixStackIn, bufferIn);
            return;
        }
        if (!setup) {
            MalumSpiritTypes.SPIRITS.forEach(s -> {
                overlayHashmap.put((MalumSpiritType)s, new RenderMaterial(AtlasTexture.field_110575_b, MalumHelper.prefix("spirit/overlay_" + s.identifier)));
                cutoutHashmap.put((MalumSpiritType)s, new RenderMaterial(AtlasTexture.field_110575_b, MalumHelper.prefix("spirit/cutout_" + s.identifier)));
            });
            setup = true;
        }
        this.renderQuad(cutoutHashmap.get(tileEntityIn.field_200663_e), new Color(255, 255, 255), combinedLightIn, tileEntityIn, matrixStackIn, bufferIn);
        this.renderQuad(overlayHashmap.get(tileEntityIn.field_200663_e), this.color(tileEntityIn), combinedLightIn, tileEntityIn, matrixStackIn, bufferIn);
    }

    public Color color(TotemPoleTileEntity totemPoleTileEntity) {
        Color color1 = new Color(12, 8, 7);
        Color color2 = totemPoleTileEntity.field_200663_e.color;
        int red = (int)MathHelper.func_219799_g((float)((float)totemPoleTileEntity.currentColor / 20.0f), (float)color1.getRed(), (float)color2.getRed());
        int green = (int)MathHelper.func_219799_g((float)((float)totemPoleTileEntity.currentColor / 20.0f), (float)color1.getGreen(), (float)color2.getGreen());
        int blue = (int)MathHelper.func_219799_g((float)((float)totemPoleTileEntity.currentColor / 20.0f), (float)color1.getBlue(), (float)color2.getBlue());
        return new Color(red, green, blue);
    }

    public void renderQuad(RenderMaterial material, Color color, int light, TotemPoleTileEntity totemPoleTileEntity, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        matrixStackIn.func_227860_a_();
        TextureAtlasSprite sprite = material.func_229314_c_();
        IVertexBuilder builder = material.func_229311_a_(bufferIn, r -> RenderType.func_228643_e_());
        matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(this.rotation(totemPoleTileEntity)));
        matrixStackIn.func_227861_a_(-0.5, 0.0, -0.5);
        this.add(builder, matrixStackIn, color, light, 1.0f, 1.0f, 1.0f, sprite.func_94209_e(), sprite.func_94206_g());
        this.add(builder, matrixStackIn, color, light, 1.0f, 0.0f, 1.0f, sprite.func_94209_e(), sprite.func_94210_h());
        this.add(builder, matrixStackIn, color, light, 1.0f, 0.0f, 0.0f, sprite.func_94212_f(), sprite.func_94210_h());
        this.add(builder, matrixStackIn, color, light, 1.0f, 1.0f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g());
        matrixStackIn.func_227865_b_();
    }

    public float rotation(TotemPoleTileEntity totemPoleTileEntity) {
        Direction direction = (Direction)totemPoleTileEntity.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            direction = direction.func_176734_d();
        }
        return 90.0f + direction.func_185119_l();
    }

    private void add(IVertexBuilder renderer, MatrixStack stack, Color color, int light, float x, float y, float z, float u, float v) {
        renderer.func_227888_a_(stack.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f).func_225583_a_(u, v).func_225587_b_(light & 0xFFFF, light >> 16 & 0xFFFF).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
    }
}

