/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blocks.totem.pole;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.totem.TotemBaseTileEntity;
import com.sammy.malum.core.init.MalumSounds;
import com.sammy.malum.core.init.blocks.MalumTileEntities;
import com.sammy.malum.core.init.particles.MalumParticles;
import com.sammy.malum.core.systems.particles.ParticleManager;
import com.sammy.malum.core.systems.spirits.MalumSpiritType;
import com.sammy.malum.core.systems.spirits.SpiritHelper;
import com.sammy.malum.core.systems.tileentities.SimpleTileEntity;
import com.sammy.malum.network.NetworkManager;
import com.sammy.malum.network.packets.particle.totem.SpiritEngraveParticlePacket;
import com.sammy.malum.network.packets.particle.totem.TotemPoleParticlePacket;
import java.awt.Color;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.PacketDistributor;

public class TotemPoleTileEntity
extends SimpleTileEntity
implements ITickableTileEntity {
    public MalumSpiritType field_200663_e;
    public int desiredColor;
    public int currentColor;
    public int baseLevel;

    public TotemPoleTileEntity() {
        super((TileEntityType)MalumTileEntities.TOTEM_POLE_TILE_ENTITY.get());
    }

    public void func_73660_a() {
        if (this.currentColor > this.desiredColor) {
            --this.currentColor;
        }
        if (this.currentColor < this.desiredColor) {
            ++this.currentColor;
        }
        if (MalumHelper.areWeOnClient(this.field_145850_b) && this.field_200663_e != null && this.desiredColor != 0) {
            this.passiveParticles();
        }
    }

    @Override
    public CompoundNBT writeData(CompoundNBT compound) {
        if (this.field_200663_e != null) {
            compound.func_74778_a("type", this.field_200663_e.identifier);
        }
        compound.func_74768_a("desiredColor", this.desiredColor);
        compound.func_74768_a("currentColor", this.currentColor);
        compound.func_74768_a("baseLevel", this.baseLevel);
        return super.writeData(compound);
    }

    @Override
    public void readData(CompoundNBT compound) {
        if (compound.func_74764_b("type")) {
            this.field_200663_e = SpiritHelper.figureOutType(compound.func_74779_i("type"));
        }
        this.desiredColor = compound.func_74762_e("desiredColor");
        this.currentColor = compound.func_74762_e("currentColor");
        this.baseLevel = compound.func_74762_e("baseLevel");
        super.readData(compound);
    }

    public void create(MalumSpiritType type) {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, MalumSounds.TOTEM_ENGRAVE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)new SpiritEngraveParticlePacket(type.identifier, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
        this.field_200663_e = type;
        this.currentColor = 10;
    }

    public void riteStarting(int height) {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, MalumSounds.TOTEM_CHARGE, SoundCategory.BLOCKS, 1.0f, 1.0f + 0.2f * (float)height);
        NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)new TotemPoleParticlePacket(this.field_200663_e.identifier, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), false));
        this.desiredColor = 10;
        this.baseLevel = this.field_174879_c.func_177956_o() - height;
        MalumHelper.updateAndNotifyState(this.field_145850_b, this.field_174879_c);
    }

    public void riteComplete(int height) {
        this.desiredColor = 20;
        MalumHelper.updateAndNotifyState(this.field_145850_b, this.field_174879_c);
    }

    public void riteEnding() {
        this.desiredColor = 0;
        MalumHelper.updateAndNotifyState(this.field_145850_b, this.field_174879_c);
    }

    public void func_145843_s() {
        if (MalumHelper.areWeOnClient(this.field_145850_b)) {
            return;
        }
        BlockPos basePos = new BlockPos(this.field_174879_c.func_177958_n(), this.baseLevel, this.field_174879_c.func_177952_p());
        if (this.field_145850_b.func_175625_s(basePos) instanceof TotemBaseTileEntity) {
            TotemBaseTileEntity totemBaseTileEntity = (TotemBaseTileEntity)this.field_145850_b.func_175625_s(basePos);
            if (totemBaseTileEntity.active) {
                totemBaseTileEntity.riteEnding();
            }
        }
        super.func_145843_s();
    }

    public void passiveParticles() {
        Color color = this.field_200663_e.color;
        for (int i = -1; i <= 1; ++i) {
            float extraVelocity = 0.03f * (float)i;
            ParticleManager.create(MalumParticles.WISP_PARTICLE).setAlpha(0.025f, 0.0f).setLifetime(20).setSpin(0.2f).setScale(0.25f, 0.0f).setColor(color, color).addVelocity(0.0, extraVelocity, 0.0).enableNoClip().randomOffset(0.1f, 0.1f).randomVelocity(0.001f, 0.001f).evenlyRepeatEdges(this.field_145850_b, this.field_174879_c, 1, Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH);
            ParticleManager.create(MalumParticles.SMOKE_PARTICLE).setAlpha(0.025f, 0.0f).setLifetime(40).setSpin(0.1f).setScale(0.35f, 0.0f).setColor(color, color).addVelocity(0.0, extraVelocity, 0.0).randomOffset(0.2f).enableNoClip().randomVelocity(0.001f, 0.001f).evenlyRepeatEdges(this.field_145850_b, this.field_174879_c, 1, Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH);
        }
    }
}

