/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.book;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.sammy.malum.ClientHelper;
import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.book.categories.BookCategory;
import com.sammy.malum.common.book.entries.BookEntry;
import com.sammy.malum.common.book.entries.BookEntryGrouping;
import com.sammy.malum.common.book.objects.BackArrowObject;
import com.sammy.malum.common.book.objects.BookObject;
import com.sammy.malum.common.book.objects.CategoryObject;
import com.sammy.malum.common.book.objects.EntryObject;
import com.sammy.malum.common.book.objects.HeadlineObject;
import com.sammy.malum.common.book.objects.LinkedEntryObject;
import com.sammy.malum.common.book.objects.NextArrowObject;
import com.sammy.malum.common.book.pages.BookPage;
import com.sammy.malum.core.modcontent.MalumBookCategories;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class BookScreen
extends Screen {
    public static final ResourceLocation BOOK_LECTERN_TEXTURE = MalumHelper.prefix("textures/gui/book_lectern.png");
    public static final ResourceLocation BOOK_ITEM_TEXTURE = MalumHelper.prefix("textures/gui/book_item.png");
    public final int bookWidth = 292;
    public final int bookHeight = 190;
    public static BookScreen screen;
    public ArrayList<BookObject> highPriorityObjects;
    public ArrayList<BookObject> objects;
    public BookObject firstCategory;
    public BookObject currentObject;
    public int currentGrouping;
    public boolean isLectern;
    public int currentPage;

    public ResourceLocation texture() {
        if (BookScreen.screen.isLectern) {
            return BOOK_LECTERN_TEXTURE;
        }
        return BOOK_ITEM_TEXTURE;
    }

    public void setupObjects(Minecraft mc) {
        this.highPriorityObjects = new ArrayList();
        this.objects = new ArrayList();
        this.field_230708_k_ = mc.func_228018_at_().func_198107_o();
        this.field_230709_l_ = mc.func_228018_at_().func_198087_p();
        int guiLeft = (this.field_230708_k_ - 292) / 2;
        int guiTop = (this.field_230709_l_ - 190) / 2;
        int posX = guiLeft + 13;
        int posY = guiTop - 15;
        BookObject backArrowObject = new BackArrowObject(posX, posY, 24, 24).renderAfterPages();
        this.highPriorityObjects.add(backArrowObject);
        posX = guiLeft + 255;
        BookObject nextArrowObject = new NextArrowObject(posX, posY, 24, 24).renderAfterPages();
        this.highPriorityObjects.add(nextArrowObject);
        ArrayList<BookObject> lastObjects = new ArrayList<BookObject>();
        for (int i = 0; i < MalumBookCategories.CATEGORIES.size(); ++i) {
            BookCategory category = MalumBookCategories.CATEGORIES.get(i);
            posX = guiLeft - 15;
            posY = guiTop + 12 + i * 26;
            CategoryObject categoryObject = new CategoryObject(category, posX, posY, 24, 24);
            if (i == 0) {
                this.firstCategory = categoryObject;
            }
            posX = guiLeft + 11;
            posY = guiTop + 8;
            HeadlineObject categoryNameObject = (HeadlineObject)new HeadlineObject(category.translationKey, posX, posY, 128, 24).addSpecialPredicate(s -> this.currentObject.equals(categoryObject) && this.currentGrouping == 0);
            this.objects.add(categoryNameObject);
            for (int j = 0; j < category.groupings.size(); ++j) {
                BookEntryGrouping grouping = category.groupings.get(j);
                for (int k = 0; k < grouping.entries.size(); ++k) {
                    BookEntry entry = grouping.entries.get(k);
                    posX = guiLeft + 11;
                    posY = guiTop + 12 + k * 25;
                    int skipRequirement = 5;
                    if (grouping.isFirst) {
                        posY += 25;
                        --skipRequirement;
                    }
                    if (k > skipRequirement) {
                        posX = guiLeft + 153;
                        posY -= 150;
                    }
                    int finalJ = j;
                    EntryObject entryObject = (EntryObject)new EntryObject(posX, posY, 128, 24, categoryObject, entry).addSpecialPredicate(s -> this.currentObject != null && s.currentObject.equals(categoryObject) && s.currentGrouping == finalJ);
                    this.objects.add(entryObject);
                    for (int l = 0; l < entry.links.size(); ++l) {
                        posX = guiLeft + 283;
                        posY = guiTop + 12 + l * 26;
                        BookEntry linkedEntry = entry.links.get(l).get();
                        LinkedEntryObject linkedPageObject = (LinkedEntryObject)new LinkedEntryObject(posX, posY, 24, 24, entryObject, linkedEntry).addSpecialPredicate(s -> {
                            if (this.currentObject instanceof LinkedEntryObject && this.currentObject.returnObject.equals(entryObject)) {
                                return true;
                            }
                            return this.currentObject != null && s.currentObject.equals(entryObject);
                        });
                        lastObjects.add(linkedPageObject);
                    }
                }
            }
            lastObjects.add(categoryObject);
        }
        this.objects.addAll(lastObjects);
        this.currentObject = this.firstCategory;
    }

    protected BookScreen() {
        super((ITextComponent)ClientHelper.simpleTranslatableComponent("malum.gui.book.title"));
        MalumBookCategories.init();
        this.setupObjects(Minecraft.func_71410_x());
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        this.setupObjects(minecraft);
        super.func_231152_a_(minecraft, width, height);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(this.texture());
        int guiLeft = (this.field_230708_k_ - 292) / 2;
        int guiTop = (this.field_230709_l_ - 190) / 2;
        BookScreen.func_238463_a_((MatrixStack)matrixStack, (int)guiLeft, (int)guiTop, (float)1.0f, (float)1.0f, (int)292, (int)190, (int)512, (int)512);
        for (BookObject object : this.highPriorityObjects) {
            this.drawBookObject(object, mouseX, mouseY, matrixStack, partialTicks);
        }
        if (this.currentObject instanceof EntryObject) {
            EntryObject entryObject = (EntryObject)this.currentObject;
            for (int i = 1; i >= 0; --i) {
                int page = this.currentPage * 2 + i;
                if (entryObject.entry.pages.size() <= page) continue;
                BookPage bookPage = entryObject.entry.pages.get(page);
                bookPage.draw(matrixStack, entryObject, this, mouseX, mouseY, guiLeft, guiTop, i == 1);
            }
        }
        for (BookObject object : this.objects) {
            this.drawBookObject(object, mouseX, mouseY, matrixStack, partialTicks);
        }
    }

    public void drawBookObject(BookObject object, int mouseX, int mouseY, MatrixStack matrixStack, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (object.canAccess(this)) {
            object.draw += 1.0f;
            if (this.isHovering(mouseX, mouseY, object.posX, object.posY, object.width, object.height)) {
                if (object.hover < 20.0f) {
                    object.hover += 1.0f;
                }
                object.isHovering = true;
            } else {
                if (object.hover > 0.0f) {
                    object.hover -= 1.0f;
                }
                object.isHovering = false;
            }
            object.draw(mc, matrixStack, mouseX, mouseY, partialTicks);
        } else if (object.draw > 0.0f) {
            object.draw = 0.0f;
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        ArrayList<BookObject> allObjects = this.objects;
        allObjects.addAll(this.highPriorityObjects);
        for (BookObject object : allObjects) {
            if (!object.canAccess(this) || !this.isHovering((int)mouseX, (int)mouseY, object.posX, object.posY, object.width, object.height)) continue;
            object.interact(screen);
            return true;
        }
        return false;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public static BookScreen getInstance(boolean isLectern) {
        if (screen == null) {
            screen = new BookScreen();
            BookScreen.screen.currentObject = BookScreen.screen.firstCategory;
        }
        BookScreen.screen.isLectern = isLectern;
        return screen;
    }

    public void drawItem(MatrixStack matrixStack, ItemStack stack, int posX, int posY, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, posX, posY);
        Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, posX, posY, null);
        if (screen.isHovering(mouseX, mouseY, posX, posY, 16, 16)) {
            screen.func_238652_a_(matrixStack, (ITextComponent)ClientHelper.simpleTranslatableComponent(stack.func_77977_a()), mouseX, mouseY);
        }
    }

    public void drawItem(MatrixStack matrixStack, String translationKey, ItemStack stack, int posX, int posY, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, posX, posY);
        Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, posX, posY, null);
        if (screen.isHovering(mouseX, mouseY, posX, posY, 16, 16)) {
            screen.func_238652_a_(matrixStack, (ITextComponent)ClientHelper.simpleTranslatableComponent(translationKey), mouseX, mouseY);
        }
    }

    public void playSound() {
        ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
        playerEntity.func_213823_a(SoundEvents.field_219617_ah, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public static void openScreen(boolean isLectern) {
        Minecraft.func_71410_x().func_147108_a((Screen)BookScreen.getInstance(isLectern));
        screen.playSound();
    }

    public boolean isHovering(int mouseX, int mouseY, int posX, int posY, int width, int height) {
        return mouseX > posX && mouseX < posX + width && mouseY > posY && mouseY < posY + height;
    }

    public static int packColor(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static void drawWrappingText(MatrixStack mStack, ITextComponent component, int x, int y, int w, float brightness) {
        BookScreen.drawWrappingText(mStack, component.getString(), x, y, w, brightness);
    }

    public static void drawWrappingText(MatrixStack mStack, String text, int x, int y, int w, float brightness) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        String line = "";
        for (String s : words) {
            if (font.func_78256_a(line) + font.func_78256_a(s) > w) {
                lines.add(line);
                line = s + " ";
                continue;
            }
            line = line + s + " ";
        }
        if (!line.isEmpty()) {
            lines.add(line);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String string = (String)lines.get(i);
            font.getClass();
            screen.renderPurpleText(mStack, string, x, y + i * (9 + 1), Math.max(0.0f, Math.min(brightness, 1.0f)));
            brightness *= 0.85f;
        }
    }

    public void renderPurpleText(MatrixStack stack, ITextComponent component, int x, int y, float brightness) {
        this.renderPurpleText(stack, component.getString(), x, y, brightness);
    }

    public void renderPurpleText(MatrixStack stack, String text, int x, int y, float brightness) {
        int r = (int)MathHelper.func_219799_g((float)brightness, (float)112.0f, (float)203.0f);
        int g = (int)MathHelper.func_219799_g((float)brightness, (float)30.0f, (float)81.0f);
        int b = (int)MathHelper.func_219799_g((float)brightness, (float)169.0f, (float)204.0f);
        this.field_230712_o_.func_238421_b_(stack, text, (float)x, (float)(y - 1), BookScreen.packColor(128, 255, 183, 236));
        this.field_230712_o_.func_238421_b_(stack, text, (float)(x - 1), (float)y, BookScreen.packColor(128, 255, 210, 243));
        this.field_230712_o_.func_238421_b_(stack, text, (float)(x + 1), (float)y, BookScreen.packColor(128, 240, 131, 232));
        this.field_230712_o_.func_238421_b_(stack, text, (float)x, (float)(y + 1), BookScreen.packColor(128, 236, 110, 226));
        this.field_230712_o_.func_238421_b_(stack, text, (float)x, (float)y, BookScreen.packColor(255, r, g, b));
    }
}

