/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.book.categories;

import com.sammy.malum.common.book.entries.BookEntry;
import com.sammy.malum.common.book.entries.BookEntryGrouping;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class BookCategory {
    public static float PAGES_PER_GROUPING = 12.0f;
    public final ItemStack iconStack;
    public final String translationKey;
    public ArrayList<BookEntryGrouping> groupings;

    public BookCategory(ItemStack iconStack, String translationKey) {
        this.iconStack = iconStack;
        this.translationKey = "malum.gui.book.chapter." + translationKey;
    }

    public void addEntries(BookEntry ... pages) {
        ArrayList<BookEntryGrouping> groupings = new ArrayList<BookEntryGrouping>();
        int currentPage = 0;
        int i = 0;
        while ((double)i <= Math.ceil((float)pages.length / PAGES_PER_GROUPING)) {
            BookEntryGrouping grouping = new BookEntryGrouping(i == 0);
            int entries = (int)PAGES_PER_GROUPING;
            if (i == 0) {
                --entries;
            }
            for (int j = 0; j < entries; ++j) {
                if (currentPage >= pages.length) continue;
                grouping.entries.add(pages[currentPage]);
                ++currentPage;
            }
            if (!grouping.entries.isEmpty()) {
                groupings.add(grouping);
            }
            ++i;
        }
        this.groupings = groupings;
    }
}

