/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.integration.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.book.BookScreen;
import com.sammy.malum.core.init.items.MalumItems;
import com.sammy.malum.core.systems.rites.MalumRiteType;
import com.sammy.malum.core.systems.spirits.MalumSpiritType;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class SpiritRitesRecipeCategory
implements IRecipeCategory<MalumRiteType> {
    public static final ResourceLocation UID = MalumHelper.prefix("spirit_rites");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    public static final ResourceLocation BACKGROUND = MalumHelper.prefix("textures/gui/spirit_rites_recipe_overlay.png");

    public SpiritRitesRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(132, 163);
        this.localizedName = I18n.func_135052_a((String)"malum.jei.spirit_rites", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(BACKGROUND, 0, 0, 130, 161);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)MalumItems.TOTEM_BASE.get()));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends MalumRiteType> getRecipeClass() {
        return MalumRiteType.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(MalumRiteType recipe, IIngredients iIngredients) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (MalumSpiritType spirit : recipe.spirits) {
            stacks.add(spirit.splinterItem().func_190903_i());
        }
        iIngredients.setInputs(VanillaTypes.ITEM, stacks);
    }

    public void draw(MalumRiteType recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        this.overlay.draw(matrixStack);
        TranslationTextComponent component = new TranslationTextComponent("malum.gui.book.entry." + recipe.identifier);
        String text = component.getString();
        int r = 112;
        int g = 30;
        int b = 169;
        int x = 65 - minecraft.field_71466_p.func_78256_a(component.getString()) / 2;
        int y = 5;
        minecraft.field_71466_p.func_238421_b_(matrixStack, text, (float)x, (float)(y - 1), BookScreen.packColor(128, 255, 183, 236));
        minecraft.field_71466_p.func_238421_b_(matrixStack, text, (float)(x - 1), (float)y, BookScreen.packColor(128, 255, 210, 243));
        minecraft.field_71466_p.func_238421_b_(matrixStack, text, (float)(x + 1), (float)y, BookScreen.packColor(128, 240, 131, 232));
        minecraft.field_71466_p.func_238421_b_(matrixStack, text, (float)x, (float)(y + 1), BookScreen.packColor(128, 236, 110, 226));
        minecraft.field_71466_p.func_238421_b_(matrixStack, text, (float)x, (float)y, BookScreen.packColor(255, r, g, b));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, MalumRiteType recipe, IIngredients iIngredients) {
        for (int i = 0; i < recipe.spirits.size(); ++i) {
            MalumSpiritType type = recipe.spirits.get(i);
            int itemPosX = 56;
            int itemPosY = 121 - i * 22;
            iRecipeLayout.getItemStacks().init(i, true, itemPosX, itemPosY);
            iRecipeLayout.getItemStacks().set(i, type.splinterItem().func_190903_i());
        }
    }
}

