/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.items.equipment.curios;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.sammy.malum.MalumHelper;
import com.sammy.malum.client.models.ModelDarkPrincesCrown;
import com.sammy.malum.client.models.ModelLapisTail;
import com.sammy.malum.common.items.equipment.curios.MalumCurioItem;
import com.sammy.malum.core.init.MalumSounds;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CurioTokenOfGratitude
extends MalumCurioItem {
    public static final String sammy_uuid = "0ca54301-6170-4c44-b3e0-b8afa6b81ed2";
    public final ResourceLocation sammy_texture = new ResourceLocation("malum", "textures/other/sammy_texture.png");
    public ModelLapisTail<LivingEntity> sammy_model;
    public static final String ura_uuid = "fddaefa0-31d2-4acf-9cd2-4711d0e5e5d5";
    public final ResourceLocation ura_texture = MalumHelper.prefix("textures/other/ura_texture.png");
    public ModelDarkPrincesCrown<LivingEntity> ura_model;

    public CurioTokenOfGratitude(Item.Properties builder) {
        super(builder);
    }

    @Override
    public void playRightClickEquipSound(LivingEntity livingEntity, ItemStack stack) {
        livingEntity.field_70170_p.func_184133_a(null, livingEntity.func_233580_cy_(), MalumSounds.SINISTER_EQUIP, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        livingEntity.field_70170_p.func_184133_a(null, livingEntity.func_233580_cy_(), MalumSounds.HOLY_EQUIP, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.DropRule getDropRule(LivingEntity livingEntity, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)livingEntity;
            if (playerEntity.func_110124_au().equals(UUID.fromString(ura_uuid))) {
                matrixStack.func_227860_a_();
                if (this.ura_model == null) {
                    this.ura_model = new ModelDarkPrincesCrown();
                }
                ICurio.RenderHelper.followHeadRotations((LivingEntity)livingEntity, (ModelRenderer[])new ModelRenderer[]{this.ura_model.crown});
                IVertexBuilder jtBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)this.ura_model.func_228282_a_(this.ura_texture), (boolean)false, (boolean)stack.func_77962_s());
                this.ura_model.func_225598_a_(matrixStack, jtBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStack.func_227865_b_();
            }
            if (playerEntity.func_110124_au().equals(UUID.fromString(sammy_uuid))) {
                double curSpeed;
                matrixStack.func_227860_a_();
                if (this.sammy_model == null) {
                    this.sammy_model = new ModelLapisTail();
                }
                if ((curSpeed = livingEntity.func_213322_ci().func_72433_c()) != 0.0) {
                    Vector3d A = new Vector3d(livingEntity.func_213322_ci().field_72450_a, 0.0, livingEntity.func_213322_ci().field_72449_c);
                    Vector3d yawLook = Vector3d.func_189986_a((float)0.0f, (float)livingEntity.field_70177_z);
                    Vector3d look = new Vector3d(yawLook.field_72450_a, 0.0, yawLook.field_72449_c);
                    Vector3d desiredDirection = look.func_178785_b((float)Math.toRadians(90.0)).func_72432_b();
                    Vector3d sidewaysVelocity = desiredDirection.func_186678_a(A.func_72430_b(desiredDirection));
                    double speedAndDirection = sidewaysVelocity.func_72433_c() * -Math.signum(desiredDirection.func_72430_b(sidewaysVelocity)) / curSpeed;
                    double rotation = speedAndDirection * 55.0;
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)rotation));
                }
                if (!playerEntity.func_225608_bj_()) {
                    double xRotation = Math.sin((float)livingEntity.field_70170_p.func_82737_E() / 18.0f) * 6.0;
                    matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)xRotation));
                }
                this.sammy_model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                this.sammy_model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
                ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{this.sammy_model});
                ICurio.RenderHelper.translateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
                ICurio.RenderHelper.rotateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
                IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)this.sammy_model.func_228282_a_(this.sammy_texture), (boolean)false, (boolean)false);
                this.sammy_model.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStack.func_227865_b_();
            }
        }
    }
}

