/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.MalumLeavesBlock;
import com.sammy.malum.common.blocks.RunewoodSaplingBlock;
import com.sammy.malum.core.init.blocks.MalumBlocks;
import com.sammy.malum.core.systems.worldgen.MalumFiller;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class RunewoodTreeFeature
extends Feature<NoFeatureConfig> {
    public static int minimumTrunkHeight = 9;
    public static int extraTrunkHeight = 3;
    public static int minimumSideTrunkHeight = 2;
    public static int extraSideTrunkHeight = 2;
    public static int minimumSideSideTrunkHeight = 1;
    public static int extraSideSideTrunkHeight = 1;
    public static int maximumDownwardsBranchOffset = 4;
    public static int minimumBranchCoreOffset = 3;
    public static int branchCoreOffsetExtra = 1;
    public static int minimumBranchHeight = 4;
    public static int branchHeightExtra = 3;
    public static int leavesHeight = 8;
    public static int leavesHeightExtra = 4;
    public static int leavesStartDownwardsOffset = 1;
    public static int leavesStartDownwardsOffsetExtra = 2;
    public static int leavesSize = 1;
    public static int leavesSizeCap = 3;
    public static int leavesSizeExtra = 1;
    public static int leavesShrinkStart = 5;

    public RunewoodTreeFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (reader.func_175623_d(pos.func_177977_b()) || !((Block)MalumBlocks.RUNEWOOD_SAPLING.get()).func_176223_P().func_196955_c((IWorldReader)reader, pos)) {
            return false;
        }
        BlockState defaultLog = ((Block)MalumBlocks.RUNEWOOD_LOG.get()).func_176223_P();
        MalumFiller treeFiller = new MalumFiller();
        MalumFiller leavesFiller = new MalumFiller();
        int trunkHeight = minimumTrunkHeight + rand.nextInt(extraTrunkHeight + 1);
        BlockPos trunkTop = pos.func_177981_b(trunkHeight);
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        for (int i = 0; i <= trunkHeight; ++i) {
            BlockPos trunkPos = pos.func_177981_b(i);
            if (!RunewoodTreeFeature.canPlace(reader, trunkPos)) {
                return false;
            }
            treeFiller.entries.add(new MalumFiller.BlockStateEntry(defaultLog, trunkPos));
        }
        RunewoodTreeFeature.makeLeafBlob(leavesFiller, rand, trunkTop);
        for (Direction direction : directions) {
            int sideTrunkHeight = minimumSideTrunkHeight + rand.nextInt(extraSideTrunkHeight + 1);
            for (int i = 0; i < sideTrunkHeight; ++i) {
                Direction[] sideTrunkPos = pos.func_177972_a(direction).func_177981_b(i);
                if (!RunewoodTreeFeature.canPlace(reader, (BlockPos)sideTrunkPos)) {
                    return false;
                }
                treeFiller.entries.add(new MalumFiller.BlockStateEntry(defaultLog, (BlockPos)sideTrunkPos));
            }
            int sideSideTrunkHeight = minimumSideSideTrunkHeight + rand.nextInt(extraSideSideTrunkHeight + 1);
            for (Direction direction2 : directions) {
                if (!(rand.nextFloat() < 0.4f)) continue;
                for (int i = 0; i < sideSideTrunkHeight; ++i) {
                    if (direction2.equals((Object)direction.func_176734_d()) || direction2.equals((Object)direction)) continue;
                    BlockPos sideSideTrunkPos = pos.func_177972_a(direction).func_177972_a(direction2).func_177981_b(i);
                    if (RunewoodTreeFeature.canPlace(reader, sideSideTrunkPos)) {
                        treeFiller.entries.add(new MalumFiller.BlockStateEntry(defaultLog, sideSideTrunkPos));
                        continue;
                    }
                    return false;
                }
                RunewoodTreeFeature.downwardsTrunk(reader, treeFiller, pos.func_177972_a(direction).func_177972_a(direction2));
            }
            RunewoodTreeFeature.downwardsTrunk(reader, treeFiller, pos.func_177972_a(direction));
        }
        for (Direction direction : directions) {
            int branchCoreOffset = rand.nextInt(maximumDownwardsBranchOffset + 1);
            int branchOffset = minimumBranchCoreOffset + rand.nextInt(branchCoreOffsetExtra + 1);
            BlockPos branchStartPos = trunkTop.func_177979_c(branchCoreOffset).func_177967_a(direction, branchOffset);
            for (int i = 0; i < branchOffset; ++i) {
                BlockPos branchConnectionPos = branchStartPos.func_177967_a(direction.func_176734_d(), i);
                if (!RunewoodTreeFeature.canPlace(reader, branchConnectionPos)) {
                    return false;
                }
                treeFiller.entries.add(new MalumFiller.BlockStateEntry((BlockState)defaultLog.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()), branchConnectionPos));
            }
            int branchHeight = minimumBranchHeight + rand.nextInt(branchHeightExtra + 1);
            for (int i = 0; i <= branchHeight; ++i) {
                BlockPos branchPos = branchStartPos.func_177981_b(i);
                if (!RunewoodTreeFeature.canPlace(reader, branchPos)) {
                    return false;
                }
                treeFiller.entries.add(new MalumFiller.BlockStateEntry(defaultLog, branchPos));
            }
            RunewoodTreeFeature.makeLeafBlob(leavesFiller, rand, branchStartPos.func_177981_b(branchHeight - 1));
        }
        MalumFiller groundFiller = new MalumFiller();
        MalumFiller grassFiller = new MalumFiller();
        RunewoodTreeFeature.makeHallowedGround(reader, groundFiller, grassFiller, rand, pos.func_177977_b(), 4, 0.0f);
        for (Direction direction : directions) {
            BlockPos groundPos = pos.func_177977_b().func_177967_a(direction, 2);
            RunewoodTreeFeature.makeHallowedGround(reader, groundFiller, grassFiller, rand, groundPos, 4, 0.2f);
        }
        for (int i = 0; i < 2 + rand.nextInt(3); ++i) {
            int x = MathHelper.func_76136_a((Random)rand, (int)-5, (int)5);
            int z = MathHelper.func_76136_a((Random)rand, (int)-5, (int)5);
            BlockPos groundPos = pos.func_177977_b().func_177982_a(x, 0, z);
            RunewoodTreeFeature.makeHallowedGround(reader, groundFiller, grassFiller, rand, groundPos, 3, 0.5f);
        }
        groundFiller.fill(reader, false);
        treeFiller.fill(reader, false);
        leavesFiller.fill(reader, true);
        grassFiller.fill(reader, true);
        return true;
    }

    public static void makeHallowedGround(ISeedReader reader, MalumFiller groundFiller, MalumFiller grassFiller, Random rand, BlockPos pos, int size, float tallGrassProbability) {
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                if (Math.abs(x) == size && Math.abs(z) == size) continue;
                BlockPos grassPos = reader.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos.func_177982_a(x, 0, z)).func_177977_b();
                while (reader.func_180495_p(grassPos).func_177230_c() instanceof BushBlock) {
                    groundFiller.entries.add(new MalumFiller.BlockStateEntry(Blocks.field_150350_a.func_176223_P(), grassPos));
                    grassPos = grassPos.func_177977_b();
                }
                if (!(reader.func_180495_p(grassPos).func_177230_c() instanceof GrassBlock)) continue;
                groundFiller.entries.add(new MalumFiller.BlockStateEntry(((Block)MalumBlocks.SUN_KISSED_GRASS_BLOCK.get()).func_176223_P(), grassPos));
                if (!(rand.nextFloat() < 0.25f)) continue;
                if (rand.nextFloat() < tallGrassProbability) {
                    DoublePlantBlock tallGrassBlock = null;
                    tallGrassBlock = rand.nextBoolean() ? (DoublePlantBlock)MalumBlocks.TALL_SUN_KISSED_GRASS.get() : (DoublePlantBlock)MalumBlocks.LAVENDER.get();
                    MalumFiller.BlockStateEntry tallGrassEntry = new MalumFiller.BlockStateEntry((BlockState)tallGrassBlock.func_176223_P().func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER), grassPos.func_177984_a()){

                        @Override
                        public boolean canPlace(ISeedReader reader) {
                            return super.canPlace(reader) && super.canPlace(reader, this.pos.func_177984_a());
                        }

                        @Override
                        public void additionalPlacement(ISeedReader reader) {
                            reader.func_180501_a(this.pos.func_177984_a(), (BlockState)this.state.func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER), 3);
                            if (reader instanceof World) {
                                MalumHelper.updateState((World)reader, this.pos.func_177984_a());
                            }
                        }
                    };
                    grassFiller.entries.add(tallGrassEntry);
                    continue;
                }
                groundFiller.entries.add(new MalumFiller.BlockStateEntry(((Block)MalumBlocks.SUN_KISSED_GRASS.get()).func_176223_P(), grassPos.func_177984_a()));
            }
        }
    }

    public static void downwardsTrunk(ISeedReader reader, MalumFiller filler, BlockPos pos) {
        BlockPos trunkPos;
        int i = 0;
        while (RunewoodTreeFeature.canPlace(reader, trunkPos = pos.func_177979_c(++i))) {
            filler.entries.add(new MalumFiller.BlockStateEntry(((Block)MalumBlocks.RUNEWOOD_LOG.get()).func_176223_P(), trunkPos));
            if (i <= reader.func_217301_I()) continue;
            break;
        }
    }

    public static void makeLeafBlob(MalumFiller filler, Random rand, BlockPos pos) {
        int randomOffset = leavesStartDownwardsOffset + rand.nextInt(leavesStartDownwardsOffsetExtra + 1);
        int finalLeavesHeight = leavesHeight + rand.nextInt(leavesHeightExtra + 1);
        int extraSize = rand.nextInt(leavesSizeExtra + 1);
        int sizeCap = leavesSizeCap + extraSize;
        int size = leavesSize - 1 + extraSize;
        for (int i = 0; i < finalLeavesHeight; ++i) {
            BlockPos blobSliceCenter = pos.func_177979_c(randomOffset).func_177981_b(i);
            size = i < leavesShrinkStart && size < sizeCap ? ++size : --size;
            int color = Math.min(i, 9);
            if (color == 9 && rand.nextBoolean()) {
                color -= rand.nextInt(3);
            }
            RunewoodTreeFeature.makeLeafSlice(filler, blobSliceCenter, size, color);
        }
    }

    public static void makeLeafSlice(MalumFiller filler, BlockPos pos, int leavesSize, int leavesColor) {
        for (int x = -leavesSize; x <= leavesSize; ++x) {
            for (int z = -leavesSize; z <= leavesSize; ++z) {
                if (Math.abs(x) == leavesSize && Math.abs(z) == leavesSize) continue;
                BlockPos leavesPos = new BlockPos((Vector3i)pos).func_177982_a(x, 0, z);
                filler.entries.add(new MalumFiller.BlockStateEntry((BlockState)((BlockState)((Block)MalumBlocks.SUN_KISSED_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1))).func_206870_a((Property)MalumLeavesBlock.COLOR, (Comparable)Integer.valueOf(leavesColor)), leavesPos));
            }
        }
    }

    public static boolean canPlace(ISeedReader reader, BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        BlockState state = reader.func_180495_p(pos);
        return state.func_177230_c() instanceof RunewoodSaplingBlock || reader.func_175623_d(pos) || state.func_185904_a().func_76222_j();
    }
}

