/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.particles;

import com.sammy.malum.core.systems.particles.data.MalumParticleData;
import com.sammy.malum.core.systems.particles.rendertypes.SpriteParticleRenderType;
import java.awt.Color;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.math.MathHelper;

public class GenericMalumParticle
extends SpriteTexturedParticle {
    MalumParticleData data;
    float[] hsv1 = new float[3];
    float[] hsv2 = new float[3];

    public GenericMalumParticle(ClientWorld world, MalumParticleData data, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.func_187109_b(x, y, z);
        this.data = data;
        this.field_187129_i = vx;
        this.field_187130_j = vy;
        this.field_187131_k = vz;
        this.func_187114_a(data.lifetime);
        this.field_70545_g = data.gravity ? 1.0f : 0.0f;
        this.field_190017_n = !data.noClip;
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r1)), (int)(255.0f * Math.min(1.0f, data.g1)), (int)(255.0f * Math.min(1.0f, data.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r2)), (int)(255.0f * Math.min(1.0f, data.g2)), (int)(255.0f * Math.min(1.0f, data.b2)), this.hsv2);
        this.updateTraits();
    }

    protected float getCoeff() {
        return (float)this.field_70546_d / (float)this.field_70547_e;
    }

    protected void updateTraits() {
        float coeff = this.getCoeff();
        this.field_70544_f = MathHelper.func_219799_g((float)coeff, (float)this.data.scale1, (float)this.data.scale2);
        float h = MathHelper.func_219805_h((float)coeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = MathHelper.func_219799_g((float)coeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = MathHelper.func_219799_g((float)coeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)ColorHelper.PackedColor.func_233007_b_((int)packed) / 255.0f;
        float g = (float)ColorHelper.PackedColor.func_233008_c_((int)packed) / 255.0f;
        float b = (float)ColorHelper.PackedColor.func_233009_d_((int)packed) / 255.0f;
        this.func_70538_b(r, g, b);
        this.func_82338_g(MathHelper.func_219799_g((float)coeff, (float)this.data.a1, (float)this.data.a2));
        this.field_190015_G = this.field_190014_F;
        this.field_190014_F += this.data.spin;
    }

    public void func_189213_a() {
        this.updateTraits();
        super.func_189213_a();
    }

    public IParticleRenderType func_217558_b() {
        return SpriteParticleRenderType.INSTANCE;
    }
}

