/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.particles;

import com.sammy.malum.core.systems.particles.data.MalumParticleData;
import java.awt.Color;
import java.util.Random;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class ParticleManager {
    public static ParticleBuilder create(ParticleType<?> type) {
        return new ParticleBuilder(type);
    }

    public static ParticleBuilder create(RegistryObject<?> type) {
        return new ParticleBuilder((ParticleType)type.get());
    }

    public static class ParticleBuilder {
        static Random random = new Random();
        ParticleType<?> type;
        MalumParticleData data;
        double vx = 0.0;
        double vy = 0.0;
        double vz = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        double maxXSpeed = 0.0;
        double maxYSpeed = 0.0;
        double maxZSpeed = 0.0;
        double maxXDist = 0.0;
        double maxYDist = 0.0;
        double maxZDist = 0.0;

        protected ParticleBuilder(ParticleType<?> type) {
            this.type = type;
            this.data = new MalumParticleData(type);
        }

        public ParticleBuilder setColor(float r, float g, float b) {
            this.setColor(r, g, b, this.data.a1, r, g, b, this.data.a2);
            return this;
        }

        public ParticleBuilder setColor(float r, float g, float b, float a) {
            this.setColor(r, g, b, a, r, g, b, a);
            return this;
        }

        public ParticleBuilder setColor(float r, float g, float b, float a1, float a2) {
            this.setColor(r, g, b, a1, r, g, b, a2);
            return this;
        }

        public ParticleBuilder setColor(float r1, float g1, float b1, float r2, float g2, float b2) {
            this.setColor(r1, g1, b1, this.data.a1, r2, g2, b2, this.data.a2);
            return this;
        }

        public ParticleBuilder setColor(float r1, float g1, float b1, float r2, float g2, float b2, float a) {
            this.setColor(r1, g1, b1, a, r2, g2, b2, a);
            return this;
        }

        public ParticleBuilder setColor(float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
            this.data.r1 = r1;
            this.data.g1 = g1;
            this.data.b1 = b1;
            this.data.a1 = a1;
            this.data.r2 = r2;
            this.data.g2 = g2;
            this.data.b2 = b2;
            this.data.a2 = a2;
            return this;
        }

        public ParticleBuilder setColor(Color c1, Color c2) {
            this.data.r1 = (float)c1.getRed() / 255.0f;
            this.data.g1 = (float)c1.getGreen() / 255.0f;
            this.data.b1 = (float)c1.getBlue() / 255.0f;
            this.data.r2 = (float)c2.getRed() / 255.0f;
            this.data.g2 = (float)c2.getGreen() / 255.0f;
            this.data.b2 = (float)c2.getBlue() / 255.0f;
            return this;
        }

        public ParticleBuilder setAlpha(float a) {
            this.setAlpha(a, a);
            return this;
        }

        public ParticleBuilder setAlpha(float a1, float a2) {
            this.data.a1 = a1;
            this.data.a2 = a2;
            return this;
        }

        public ParticleBuilder setScale(float scale) {
            this.setScale(scale, scale);
            return this;
        }

        public ParticleBuilder setScale(float scale1, float scale2) {
            this.data.scale1 = scale1;
            this.data.scale2 = scale2;
            return this;
        }

        public ParticleBuilder enableGravity() {
            this.data.gravity = true;
            return this;
        }

        public ParticleBuilder disableGravity() {
            this.data.gravity = false;
            return this;
        }

        public ParticleBuilder enableNoClip() {
            this.data.noClip = true;
            return this;
        }

        public ParticleBuilder disableNoClip() {
            this.data.noClip = false;
            return this;
        }

        public ParticleBuilder setSpin(float angularVelocity) {
            this.data.spin = angularVelocity;
            return this;
        }

        public ParticleBuilder setLifetime(int lifetime) {
            this.data.lifetime = lifetime;
            return this;
        }

        public ParticleBuilder randomVelocity(double maxSpeed) {
            this.randomVelocity(maxSpeed, maxSpeed, maxSpeed);
            return this;
        }

        public ParticleBuilder randomVelocity(double maxHSpeed, double maxVSpeed) {
            this.randomVelocity(maxHSpeed, maxVSpeed, maxHSpeed);
            return this;
        }

        public ParticleBuilder randomVelocity(double maxXSpeed, double maxYSpeed, double maxZSpeed) {
            this.maxXSpeed = maxXSpeed;
            this.maxYSpeed = maxYSpeed;
            this.maxZSpeed = maxZSpeed;
            return this;
        }

        public ParticleBuilder addVelocity(double vx, double vy, double vz) {
            this.vx += vx;
            this.vy += vy;
            this.vz += vz;
            return this;
        }

        public ParticleBuilder setVelocity(double vx, double vy, double vz) {
            this.vx = vx;
            this.vy = vy;
            this.vz = vz;
            return this;
        }

        public ParticleBuilder randomOffset(double maxDistance) {
            this.randomOffset(maxDistance, maxDistance, maxDistance);
            return this;
        }

        public ParticleBuilder randomOffset(double maxHDist, double maxVDist) {
            this.randomOffset(maxHDist, maxVDist, maxHDist);
            return this;
        }

        public ParticleBuilder randomOffset(double maxXDist, double maxYDist, double maxZDist) {
            this.maxXDist = maxXDist;
            this.maxYDist = maxYDist;
            this.maxZDist = maxZDist;
            return this;
        }

        public ParticleBuilder spawnCircle(World world, double x, double y, double z, double distance, double currentCount, double totalCount) {
            double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
            double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
            double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
            double theta = Math.PI * 2 / totalCount;
            double finalAngle = currentCount / totalCount + theta * currentCount;
            double dx2 = distance * Math.cos(finalAngle);
            double dz2 = distance * Math.sin(finalAngle);
            Vector3d vector2f = new Vector3d(dx2, 0.0, dz2);
            this.vx = vector2f.field_72450_a * xSpeed;
            this.vz = vector2f.field_72449_c * zSpeed;
            double yaw2 = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch2 = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xDist = (double)random.nextFloat() * this.maxXDist;
            double yDist = (double)random.nextFloat() * this.maxYDist;
            double zDist = (double)random.nextFloat() * this.maxZDist;
            this.dx = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
            this.dy = Math.sin(pitch2) * yDist;
            this.dz = Math.cos(yaw2) * Math.cos(pitch2) * zDist;
            world.func_195594_a((IParticleData)this.data, x + this.dx + dx2, y + this.dy, z + this.dz + dz2, this.vx, ySpeed, this.vz);
            return this;
        }

        public ParticleBuilder spawn(World world, double x, double y, double z) {
            double yaw = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
            double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
            double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
            this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
            this.vy += Math.sin(pitch) * ySpeed;
            this.vz += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
            double yaw2 = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch2 = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xDist = (double)random.nextFloat() * this.maxXDist;
            double yDist = (double)random.nextFloat() * this.maxYDist;
            double zDist = (double)random.nextFloat() * this.maxZDist;
            this.dx = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
            this.dy = Math.sin(pitch2) * yDist;
            this.dz = Math.cos(yaw2) * Math.cos(pitch2) * zDist;
            world.func_195594_a((IParticleData)this.data, x + this.dx, y + this.dy, z + this.dz, this.vx, this.vy, this.vz);
            return this;
        }

        public ParticleBuilder evenlySpawnAtEdges(World world, BlockPos pos) {
            for (Direction direction : Direction.values()) {
                double yaw = (double)random.nextFloat() * Math.PI * 2.0;
                double pitch = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
                double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
                double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
                double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
                this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
                this.vy += Math.sin(pitch) * ySpeed;
                this.vz += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
                Direction.Axis direction$axis = direction.func_176740_k();
                double d0 = 0.5625;
                this.dx = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.func_82601_c() : (double)random.nextFloat();
                this.dy = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.func_96559_d() : (double)random.nextFloat();
                this.dz = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.func_82599_e() : (double)random.nextFloat();
                world.func_195594_a((IParticleData)this.data, (double)pos.func_177958_n() + this.dx, (double)pos.func_177956_o() + this.dy, (double)pos.func_177952_p() + this.dz, this.vx, this.vy, this.vz);
            }
            return this;
        }

        public ParticleBuilder evenlySpawnAtEdges(World world, BlockPos pos, Direction ... directions) {
            for (Direction direction : directions) {
                double yaw = (double)random.nextFloat() * Math.PI * 2.0;
                double pitch = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
                double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
                double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
                double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
                this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
                this.vy += Math.sin(pitch) * ySpeed;
                this.vz += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
                Direction.Axis direction$axis = direction.func_176740_k();
                double d0 = 0.5625;
                this.dx = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.func_82601_c() : (double)random.nextFloat();
                this.dy = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.func_96559_d() : (double)random.nextFloat();
                this.dz = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.func_82599_e() : (double)random.nextFloat();
                world.func_195594_a((IParticleData)this.data, (double)pos.func_177958_n() + this.dx, (double)pos.func_177956_o() + this.dy, (double)pos.func_177952_p() + this.dz, this.vx, this.vy, this.vz);
            }
            return this;
        }

        public ParticleBuilder spawnAtEdges(World world, BlockPos pos) {
            Direction direction = Direction.values()[world.field_73012_v.nextInt(Direction.values().length)];
            double yaw = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
            double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
            double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
            this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
            this.vy += Math.sin(pitch) * ySpeed;
            this.vz += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
            Direction.Axis direction$axis = direction.func_176740_k();
            double d0 = 0.5625;
            this.dx = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.func_82601_c() : (double)random.nextFloat();
            this.dy = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.func_96559_d() : (double)random.nextFloat();
            this.dz = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.func_82599_e() : (double)random.nextFloat();
            world.func_195594_a((IParticleData)this.data, (double)pos.func_177958_n() + this.dx, (double)pos.func_177956_o() + this.dy, (double)pos.func_177952_p() + this.dz, this.vx, this.vy, this.vz);
            return this;
        }

        public ParticleBuilder repeat(World world, double x, double y, double z, int n) {
            for (int i = 0; i < n; ++i) {
                this.spawn(world, x, y, z);
            }
            return this;
        }

        public ParticleBuilder repeatEdges(World world, BlockPos pos, int n) {
            for (int i = 0; i < n; ++i) {
                this.spawnAtEdges(world, pos);
            }
            return this;
        }

        public ParticleBuilder evenlyRepeatEdges(World world, BlockPos pos, int n) {
            for (int i = 0; i < n; ++i) {
                this.evenlySpawnAtEdges(world, pos);
            }
            return this;
        }

        public ParticleBuilder evenlyRepeatEdges(World world, BlockPos pos, int n, Direction ... directions) {
            for (int i = 0; i < n; ++i) {
                this.evenlySpawnAtEdges(world, pos, directions);
            }
            return this;
        }

        public ParticleBuilder repeatCircle(World world, double x, double y, double z, double distance, int times) {
            for (int i = 0; i < times; ++i) {
                this.spawnCircle(world, x, y, z, distance, i, times);
            }
            return this;
        }
    }
}

