/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.recipes;

import com.sammy.malum.MalumMod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;

public class ItemIngredient {
    public ITag<Item> tag;
    public Item item;
    public int count;

    public boolean isSimple() {
        return this.tag == null;
    }

    public ItemStack getItem() {
        if (this.isSimple()) {
            return new ItemStack((IItemProvider)this.item, this.count);
        }
        ArrayList stacks = (ArrayList)this.stacks();
        return (ItemStack)stacks.get(MalumMod.RANDOM.nextInt(stacks.size()));
    }

    public ItemStack getItemAlt() {
        if (this.isSimple()) {
            return new ItemStack((IItemProvider)this.item, this.count);
        }
        return this.stacks().get(0);
    }

    public List<ItemStack> stacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.isSimple()) {
            stacks.add(new ItemStack((IItemProvider)this.item, this.count));
        } else {
            for (Item tagItem : this.tag.func_230236_b_()) {
                stacks.add(new ItemStack((IItemProvider)tagItem, this.count));
            }
        }
        return stacks;
    }

    public boolean matches(ItemStack stack) {
        if (this.isSimple()) {
            return stack.func_77973_b().equals(this.item) && stack.func_190916_E() >= this.count;
        }
        return this.tag.func_230235_a_((Object)stack.func_77973_b()) && stack.func_190916_E() >= this.count;
    }

    public ItemIngredient(ITag<Item> tag, int count) {
        this.tag = tag;
        this.count = count;
    }

    public ItemIngredient(Item item, int count) {
        this.item = item;
        this.count = count;
    }
}

